/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.overpass;

import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.common.XmlParser;
import de.westnordost.osmapi.map.MapDataFactory;
import de.westnordost.osmapi.map.data.BoundingBox;
import de.westnordost.osmapi.map.data.Element;
import de.westnordost.osmapi.map.data.LatLon;
import de.westnordost.osmapi.map.data.Node;
import de.westnordost.osmapi.map.data.OsmLatLon;
import de.westnordost.osmapi.map.data.Relation;
import de.westnordost.osmapi.map.data.RelationMember;
import de.westnordost.osmapi.map.data.Way;
import de.westnordost.osmapi.overpass.MapDataWithGeometryHandler;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MapDataWithGeometryParser
extends XmlParser
implements ApiResponseReader<Void> {
    private static final String NODE = "node";
    private static final String WAY = "way";
    private static final String RELATION = "relation";
    private static final String MEMBER = "member";
    private static final String ND = "nd";
    private static final String TAG = "tag";
    private static final String BOUNDS = "bounds";
    private final MapDataFactory factory;
    private final MapDataWithGeometryHandler handler;
    private long id;
    private int version;
    private Instant timestamp;
    private Double lat;
    private Double lon;
    private Map<String, String> tags;
    private List<RelationMember> members;
    private List<Long> nodeIds;
    private Map<Long, List<LatLon>> nodePositionsByWayId;
    private Map<Long, LatLon> nodePositionByNodeId;
    private List<LatLon> nodePositions;
    private BoundingBox bounds;

    public MapDataWithGeometryParser(@NotNull MapDataWithGeometryHandler handler, @NotNull MapDataFactory factory) {
        this.factory = factory;
        this.handler = handler;
    }

    public Void parse(@NotNull InputStream in) throws IOException {
        this.id = -1L;
        this.version = 0;
        this.doParse(in);
        return null;
    }

    protected void onStartElement() throws ParseException {
        String name;
        switch (name = this.getName()) {
            case "bounds": {
                this.bounds = new BoundingBox(this.getDoubleAttribute("minlat").doubleValue(), this.getDoubleAttribute("minlon").doubleValue(), this.getDoubleAttribute("maxlat").doubleValue(), this.getDoubleAttribute("maxlon").doubleValue());
                String parent = this.getParentName();
                if (WAY.equals(parent) || RELATION.equals(parent)) break;
                this.handler.handle(this.bounds);
                this.bounds = null;
                break;
            }
            case "tag": {
                if (this.tags == null) {
                    this.tags = new HashMap<String, String>();
                }
                this.tags.put(this.getAttribute("k"), this.getAttribute("v"));
                break;
            }
            case "nd": {
                if (WAY.equals(this.getParentName())) {
                    this.nodeIds.add(this.getLongAttribute("ref"));
                }
                OsmLatLon pos = new OsmLatLon(this.getDoubleAttribute("lat").doubleValue(), this.getDoubleAttribute("lon").doubleValue());
                this.nodePositions.add((LatLon)pos);
                break;
            }
            case "member": {
                long ref = this.getLongAttribute("ref");
                String role = this.getAttribute("role");
                Element.Type type = Element.Type.valueOf((String)this.getAttribute("type").toUpperCase(Locale.UK));
                this.members.add(this.factory.createRelationMember(ref, role, type));
                if (type == Element.Type.NODE) {
                    this.nodePositionByNodeId.put(ref, (LatLon)new OsmLatLon(this.getDoubleAttribute("lat").doubleValue(), this.getDoubleAttribute("lon").doubleValue()));
                    break;
                }
                if (type != Element.Type.WAY) break;
                this.nodePositions = new ArrayList<LatLon>();
                this.nodePositionsByWayId.put(ref, this.nodePositions);
                break;
            }
            case "node": {
                this.retrieveElementAttributes();
                this.lat = this.getDoubleAttribute("lat");
                this.lon = this.getDoubleAttribute("lon");
                break;
            }
            case "way": {
                this.retrieveElementAttributes();
                this.nodeIds = new ArrayList<Long>();
                this.nodePositions = new ArrayList<LatLon>();
                break;
            }
            case "relation": {
                this.retrieveElementAttributes();
                this.members = new ArrayList<RelationMember>();
                this.nodePositionsByWayId = new HashMap<Long, List<LatLon>>();
                this.nodePositionByNodeId = new HashMap<Long, LatLon>();
            }
        }
    }

    private void retrieveElementAttributes() throws ParseException {
        this.id = this.getLongAttribute("id");
        Integer v = this.getIntAttribute("version");
        this.version = v != null ? v : -1;
        this.timestamp = this.parseDate();
    }

    private Instant parseDate() {
        String timestamp = this.getAttribute("timestamp");
        if (timestamp == null) {
            return null;
        }
        return Instant.parse(timestamp);
    }

    protected void onEndElement() {
        String name;
        switch (name = this.getName()) {
            case "member": {
                this.nodePositions = null;
                break;
            }
            case "node": {
                Node node = this.factory.createNode(this.id, this.version, this.lat, this.lon, this.tags, null, this.timestamp);
                this.id = 0L;
                this.version = -1;
                this.lat = null;
                this.lon = null;
                this.tags = null;
                this.timestamp = null;
                this.handler.handle(node);
                break;
            }
            case "way": {
                Way way = this.factory.createWay(this.id, this.version, this.nodeIds, this.tags, null, this.timestamp);
                this.handler.handle(way, this.bounds, this.nodePositions);
                this.id = 0L;
                this.version = -1;
                this.nodeIds = null;
                this.tags = null;
                this.timestamp = null;
                this.nodePositions = null;
                this.bounds = null;
                break;
            }
            case "relation": {
                Relation relation = this.factory.createRelation(this.id, this.version, this.members, this.tags, null, this.timestamp);
                this.handler.handle(relation, this.bounds, this.nodePositionByNodeId, this.nodePositionsByWayId);
                this.id = 0L;
                this.version = -1;
                this.members = null;
                this.tags = null;
                this.timestamp = null;
                this.nodePositionsByWayId = null;
                this.nodePositionByNodeId = null;
                this.nodePositions = null;
                this.bounds = null;
            }
        }
    }
}

