/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.overpass;

import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.overpass.OverpassStatus;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class OverpassStatusParser
implements ApiResponseReader<OverpassStatus> {
    private final Pattern maxAvailableSlots = Pattern.compile("Rate limit: (\\d+)");
    private final Pattern availableSlotsPattern = Pattern.compile("(\\d+) slots available now");
    private final Pattern nextAvailableSlotPattern = Pattern.compile("Slot available after: ([0-9A-Z-:]+), in (\\d+) seconds");

    @NotNull
    public OverpassStatus parse(InputStream in) throws Exception {
        OverpassStatus result = new OverpassStatus();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher m = this.availableSlotsPattern.matcher(line);
                if (m.find()) {
                    result.availableSlots = Integer.parseInt(m.group(1));
                }
                if ((m = this.nextAvailableSlotPattern.matcher(line)).find()) {
                    int nextAvailableSlotIn = Integer.parseInt(m.group(2));
                    if (result.nextAvailableSlotIn == null || result.nextAvailableSlotIn > nextAvailableSlotIn) {
                        result.nextAvailableSlotIn = nextAvailableSlotIn;
                    }
                }
                if (!(m = this.maxAvailableSlots.matcher(line)).find()) continue;
                result.maxAvailableSlots = Integer.parseInt(m.group(1));
            }
        }
        return result;
    }
}

