/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.overpass;

import de.westnordost.osmapi.ApiRequestWriter;
import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.OsmConnection;
import de.westnordost.osmapi.common.Handler;
import de.westnordost.osmapi.common.errors.OsmApiException;
import de.westnordost.osmapi.map.MapDataFactory;
import de.westnordost.osmapi.map.MapDataParser;
import de.westnordost.osmapi.map.OsmMapDataFactory;
import de.westnordost.osmapi.map.handler.MapDataHandler;
import de.westnordost.osmapi.overpass.CsvParser;
import de.westnordost.osmapi.overpass.ElementCount;
import de.westnordost.osmapi.overpass.ElementCountParser;
import de.westnordost.osmapi.overpass.MapDataWithGeometryHandler;
import de.westnordost.osmapi.overpass.MapDataWithGeometryParser;
import de.westnordost.osmapi.overpass.OsmTooManyRequestsException;
import de.westnordost.osmapi.overpass.OverpassStatus;
import de.westnordost.osmapi.overpass.OverpassStatusParser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class OverpassMapDataApi {
    private final OsmConnection osm;
    private final MapDataFactory mapDataFactory;

    public OverpassMapDataApi(@NotNull OsmConnection osm, @NotNull MapDataFactory mapDataFactory) {
        this.osm = osm;
        this.mapDataFactory = mapDataFactory;
    }

    public OverpassMapDataApi(@NotNull OsmConnection osm) {
        this(osm, (MapDataFactory)new OsmMapDataFactory());
    }

    public void queryElements(@NotNull String query, @NotNull MapDataHandler handler) {
        this.query(query, (ApiResponseReader)new MapDataParser(handler, this.mapDataFactory));
    }

    public void queryElementsWithGeometry(@NotNull String query, @NotNull MapDataWithGeometryHandler handler) {
        this.query(query, new MapDataWithGeometryParser(handler, this.mapDataFactory));
    }

    public void queryTable(@NotNull String query, @NotNull Handler<String[]> handler, @NotNull String separator) {
        this.query(query, new CsvParser(handler, separator));
    }

    public void queryTable(@NotNull String query, @NotNull Handler<String[]> handler) {
        this.query(query, new CsvParser(handler));
    }

    @NotNull
    public ElementCount queryCount(@NotNull String query) {
        return this.query(query, new ElementCountParser());
    }

    public synchronized <T> T query(final @NotNull String query, ApiResponseReader<T> reader) {
        ApiRequestWriter writer = new ApiRequestWriter(){

            public String getContentType() {
                return "application/x-www-form-urlencoded";
            }

            public void write(OutputStream out) throws IOException {
                String request = "data=" + OverpassMapDataApi.this.urlEncode(query);
                out.write(request.getBytes(Charset.forName("UTF-8")));
            }
        };
        try {
            return (T)this.osm.makeRequest("interpreter", "POST", false, writer, reader);
        }
        catch (OsmApiException e) {
            if (e.getErrorCode() == 429) {
                throw new OsmTooManyRequestsException(e);
            }
            throw e;
        }
    }

    public synchronized void killMyQueries() {
        this.osm.makeRequest("kill_my_queries", null);
    }

    public synchronized OverpassStatus getStatus() {
        return (OverpassStatus)this.osm.makeRequest("status", (ApiResponseReader)new OverpassStatusParser());
    }

    private String urlEncode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

