/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.user;

import de.westnordost.osmapi.ApiRequestWriter;
import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.OsmConnection;
import de.westnordost.osmapi.common.PlainTextWriter;
import de.westnordost.osmapi.common.XmlWriter;
import de.westnordost.osmapi.common.errors.OsmNotFoundException;
import de.westnordost.osmapi.user.PreferencesParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class UserPreferencesApi {
    private static final String USERPREFS = "user/preferences/";
    private static final int BUFFER_SIZE_PREFS = 256;
    private final OsmConnection osm;

    public UserPreferencesApi(OsmConnection osm) {
        this.osm = osm;
    }

    public Map<String, String> getAll() {
        return (Map)this.osm.makeAuthenticatedRequest(USERPREFS, "GET", (ApiResponseReader)new PreferencesParser());
    }

    public String get(String key) {
        String urlKey = this.urlEncode(key);
        ApiResponseReader<String> reader = new ApiResponseReader<String>(){

            public String parse(InputStream in) throws Exception {
                InputStreamReader isr = new InputStreamReader(in, "UTF-8");
                BufferedReader reader = new BufferedReader(isr, 256);
                return reader.readLine();
            }
        };
        try {
            return (String)this.osm.makeAuthenticatedRequest(USERPREFS + urlKey, "GET", (ApiResponseReader)reader);
        }
        catch (OsmNotFoundException e) {
            return null;
        }
    }

    public void setAll(Map<String, String> preferences) {
        for (Map.Entry<String, String> preference : preferences.entrySet()) {
            this.checkPreferenceKeyLength(preference.getKey());
            this.checkPreferenceValueLength(preference.getValue());
        }
        final Map<String, String> prefs = preferences;
        this.osm.makeAuthenticatedRequest(USERPREFS, "PUT", (ApiRequestWriter)new XmlWriter(){

            protected void write() throws IOException {
                this.begin("osm");
                this.begin("preferences");
                for (Map.Entry preference : prefs.entrySet()) {
                    this.begin("preference");
                    this.attribute("k", (String)preference.getKey());
                    this.attribute("v", (String)preference.getValue());
                    this.end();
                }
                this.end();
                this.end();
            }
        });
    }

    public void set(String key, String value) {
        String urlKey = this.urlEncode(key);
        this.checkPreferenceKeyLength(urlKey);
        this.checkPreferenceValueLength(value);
        this.osm.makeAuthenticatedRequest(USERPREFS + urlKey, "PUT", (ApiRequestWriter)new PlainTextWriter(value));
    }

    public void delete(String key) {
        String urlKey = this.urlEncode(key);
        this.checkPreferenceKeyLength(urlKey);
        this.osm.makeAuthenticatedRequest(USERPREFS + urlKey, "DELETE");
    }

    private void checkPreferenceKeyLength(String key) {
        if (key.length() >= 256) {
            throw new IllegalArgumentException("Key \"" + key + "\" must be less than 256 characters.");
        }
    }

    private void checkPreferenceValueLength(String value) {
        if (value.length() >= 256) {
            throw new IllegalArgumentException("Value \"" + value + "\" must be less than 256 characters.");
        }
    }

    private String urlEncode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

