/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.froggy.auth.rest;

import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonView;
import de.whitefrog.froggy.auth.model.BaseUser;
import de.whitefrog.froggy.model.Base;
import de.whitefrog.froggy.model.Model;
import de.whitefrog.froggy.model.SaveContext;
import de.whitefrog.froggy.model.rest.SearchParameter;
import de.whitefrog.froggy.repository.Repository;
import de.whitefrog.froggy.rest.Views;
import de.whitefrog.froggy.rest.request.SearchParam;
import de.whitefrog.froggy.rest.response.Response;
import de.whitefrog.froggy.rest.service.RestService;
import io.dropwizard.auth.Auth;
import io.dropwizard.validation.Validated;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.neo4j.graphdb.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthCRUDService<R extends Repository<M>, M extends Model, U extends BaseUser>
extends RestService<R, M> {
    private static final Logger logger = LoggerFactory.getLogger(AuthCRUDService.class);

    @POST
    @RolesAllowed(value={"User"})
    public List<M> create(@Auth U user, List<M> models) {
        try (Transaction tx = this.service().beginTx();){
            for (Model model : models) {
                if (model.getPersisted()) {
                    throw new ForbiddenException("the model is not yet persisted");
                }
                SaveContext context = new SaveContext(this.repository(), (Base)model);
                this.authorize(user, model, context);
                try {
                    this.repository().save(context);
                }
                catch (Exception e) {
                    logger.error("failed to save {}", (Object)model);
                    throw e;
                }
            }
            tx.success();
        }
        return models;
    }

    @PUT
    @RolesAllowed(value={"User"})
    public List<M> update(@Auth U user, List<M> models) {
        try (Transaction tx = this.service().beginTx();){
            for (Model model : models) {
                if (!model.getPersisted()) {
                    throw new ForbiddenException("the model has to be created first");
                }
                SaveContext context = new SaveContext(this.repository(), (Base)model);
                this.authorize(user, model, context);
                try {
                    this.repository().save(context);
                }
                catch (Exception e) {
                    logger.error("failed to update {}", (Object)model);
                    throw e;
                }
            }
            tx.success();
        }
        return models;
    }

    @GET
    @Path(value="{id: [0-9]+}")
    @RolesAllowed(value={"User"})
    public M read(@Auth U user, @PathParam(value="id") long id, @SearchParam SearchParameter params) {
        return (M)((Model)this.search(user, params.ids(new Long[]{id})).singleton());
    }

    @GET
    @Path(value="{uuid: [a-zA-Z0-9]+}")
    @RolesAllowed(value={"User"})
    @JsonView(value={Views.Public.class})
    public Model read(@Auth U user, @PathParam(value="uuid") String uuid, @SearchParam SearchParameter params) {
        return (Model)this.search(user, params.uuids(new String[]{uuid})).singleton();
    }

    @GET
    @RolesAllowed(value={"User"})
    @JsonView(value={Views.Public.class})
    public Response search(@Auth U user, @SearchParam SearchParameter params) {
        Timer.Context timer = metrics.timer("myband." + this.repository().getModelClass().getSimpleName().toLowerCase() + ".search").time();
        Response response = new Response();
        try (Transaction tx = this.service().beginTx();){
            SearchParameter paramsClone = params.clone();
            if (params.limit() > 0) {
                List list = this.repository().search().params(params).list();
                response.setData(list);
            }
            timer.stop();
            response.setSuccess(true);
            if (params.count()) {
                response.setTotal(Long.valueOf(this.repository().search().params(paramsClone).count()));
            }
        }
        return response;
    }

    @POST
    @Path(value="search")
    @RolesAllowed(value={"User"})
    @JsonView(value={Views.Public.class})
    public Response searchPost(@Auth U user, SearchParameter params) {
        return this.search(user, params);
    }

    @DELETE
    @Path(value="{uuid: [a-zA-Z0-9]+}")
    @RolesAllowed(value={"User"})
    public void delete(@Auth U user, @PathParam(value="uuid") String uuid) {
        try (Transaction tx = this.service().beginTx();){
            Model model = (Model)this.repository().findByUuid(uuid, new String[0]);
            if (model == null) {
                throw new NotFoundException();
            }
            this.authorizeDelete(user, model);
            this.repository().remove((Base)model);
            tx.success();
        }
    }

    @POST
    @Path(value="authorize")
    public void authorize(@Validated Model model) {
    }

    public void authorize(U user, M model, SaveContext<M> context) {
    }

    public void authorizeDelete(U user, M model) {
    }
}

