/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.froggy.auth.rest.oauth;

import de.whitefrog.froggy.auth.model.BaseUser;
import de.whitefrog.froggy.auth.repository.BaseUserRepository;
import io.dropwizard.auth.AuthenticationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.graphdb.Transaction;

public class Authenticator<U extends BaseUser>
implements io.dropwizard.auth.Authenticator<String, U> {
    private static final boolean SimulateUnauthorized = false;
    public static final int ACCESS_TOKEN_EXPIRE_TIME_MIN = 30;
    private BaseUserRepository<U> repository;
    private static Map<String, Long> lastApiAccess = new HashMap<String, Long>(100000);

    public Authenticator(BaseUserRepository<U> repository) {
        this.repository = repository;
    }

    public static void updateLastApiAccess(String accessToken) {
        lastApiAccess.put(accessToken, System.currentTimeMillis());
    }

    public Optional<U> authenticate(String accessToken) throws AuthenticationException {
        if (accessToken.equals("public")) {
            BaseUser pub = (BaseUser)this.repository.createModel();
            pub.setRole("Public");
            return Optional.of(pub);
        }
        try {
            UUID.fromString(accessToken);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
        try (Transaction tx = this.repository.service().beginTx();){
            BaseUser user = (BaseUser)this.repository.search().filter("accessToken", accessToken).fields(new String[]{"role"}).single();
            if (user == null) {
                Optional optional = Optional.empty();
                return optional;
            }
            Optional<BaseUser> userOptional = Optional.of(user);
            if (!lastApiAccess.containsKey(accessToken)) {
                Optional optional = Optional.empty();
                return optional;
            }
            long lastLogin = lastApiAccess.get(accessToken);
            if (System.currentTimeMillis() - lastLogin > 1800000L) {
                Optional optional = Optional.empty();
                return optional;
            }
            lastApiAccess.put(accessToken, System.currentTimeMillis());
            tx.success();
            Optional<BaseUser> optional = userOptional;
            return optional;
        }
    }
}

