/*
 * Decompiled with CFR 0.152.
 */
package de.xn__ho_hia.quality.null_analysis;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class Nullsafe {
    private Nullsafe() {
    }

    public static <TYPE> @NonNull TYPE nonNull(@Nullable TYPE reference) {
        return Nullsafe.nonNull(reference, "Got unexpected NULL reference");
    }

    public static <TYPE> @NonNull TYPE nonNull(@Nullable TYPE reference, String message) {
        if (reference != null) {
            return reference;
        }
        throw new IllegalArgumentException(message);
    }

    public static <TYPE> @NonNull Stream<TYPE> safelyStream(@Nullable Collection<TYPE> collection) {
        return collection != null ? Nullsafe.nonNull(collection.stream()) : Nullsafe.nonNull(Stream.empty());
    }

    public static <TYPE> @NonNull List<TYPE> ensureList(@Nullable List<TYPE> list) {
        return list != null ? list : Nullsafe.nonNull(Collections.emptyList());
    }

    public static <TYPE> @NonNull Set<TYPE> ensureSet(@Nullable Set<TYPE> set) {
        return set != null ? set : Nullsafe.nonNull(Collections.emptySet());
    }

    public static <KEY, VALUE> @NonNull Map<KEY, VALUE> ensureMap(@Nullable Map<KEY, VALUE> map) {
        return map != null ? map : Nullsafe.nonNull(Collections.emptyMap());
    }

    public static boolean isNullOrEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static @NonNull BigInteger asBigInteger(long value) {
        return Nullsafe.nonNull(BigInteger.valueOf(value));
    }

    public static @NonNull Long asLong(long value) {
        return Nullsafe.nonNull(value);
    }

    public static @NonNull BigInteger addNullsafe(@Nullable BigInteger first, @Nullable BigInteger second) {
        return Nullsafe.nonNull(Nullsafe.nonNull(first).add(second));
    }

    public static @NonNull BigInteger subtractNullsafe(@Nullable BigInteger first, @Nullable BigInteger second) {
        return Nullsafe.nonNull(Nullsafe.nonNull(first).subtract(second));
    }

    public static @NonNull BigInteger divideNullsafe(@Nullable BigInteger first, @Nullable BigInteger second) {
        return Nullsafe.nonNull(Nullsafe.nonNull(first).divide(second));
    }

    public static @NonNull BigInteger multiplyNullsafe(@Nullable BigInteger first, @Nullable BigInteger second) {
        return Nullsafe.nonNull(Nullsafe.nonNull(first).multiply(second));
    }
}

