/*
 * Decompiled with CFR 0.152.
 */
package de.zazaz.iot.bosch.indego;

import de.zazaz.iot.bosch.indego.DeviceCommand;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DeviceStatus {
    private static final Map<Integer, DeviceStatus> statusMap = Collections.synchronizedMap(new HashMap());
    private int code;
    private String message;
    private DeviceCommand associatedCommand;

    private static void addAllKnownStatusCodes() {
        DeviceStatus.addStatus(0, "Reading status", DeviceCommand.RETURN);
        DeviceStatus.addStatus(257, "Charging", DeviceCommand.RETURN);
        DeviceStatus.addStatus(258, "Docked", DeviceCommand.RETURN);
        DeviceStatus.addStatus(259, "Docked - Software update", DeviceCommand.RETURN);
        DeviceStatus.addStatus(260, "Docked", DeviceCommand.RETURN);
        DeviceStatus.addStatus(261, "Docked", DeviceCommand.RETURN);
        DeviceStatus.addStatus(262, "Docked - Loading map", DeviceCommand.MOW);
        DeviceStatus.addStatus(263, "Docked - Saving map", DeviceCommand.RETURN);
        DeviceStatus.addStatus(513, "Mowing", DeviceCommand.MOW);
        DeviceStatus.addStatus(514, "Relocalising", DeviceCommand.MOW);
        DeviceStatus.addStatus(515, "Loading map", DeviceCommand.MOW);
        DeviceStatus.addStatus(516, "Learning lawn", DeviceCommand.MOW);
        DeviceStatus.addStatus(517, "Paused", DeviceCommand.PAUSE);
        DeviceStatus.addStatus(518, "Border cut", DeviceCommand.MOW);
        DeviceStatus.addStatus(519, "Idle in lawn", DeviceCommand.MOW);
        DeviceStatus.addStatus(769, "Returning to dock", DeviceCommand.RETURN);
        DeviceStatus.addStatus(770, "Returning to dock", DeviceCommand.RETURN);
        DeviceStatus.addStatus(771, "Returning to dock - Battery low", DeviceCommand.RETURN);
        DeviceStatus.addStatus(772, "Returning to dock - Calendar timeslot ended", DeviceCommand.RETURN);
        DeviceStatus.addStatus(773, "Returning to dock - Battery temp range", DeviceCommand.RETURN);
        DeviceStatus.addStatus(774, "Returning to dock", DeviceCommand.RETURN);
        DeviceStatus.addStatus(775, "Returning to dock - Lawn complete", DeviceCommand.RETURN);
        DeviceStatus.addStatus(776, "Returning to dock - Relocalising", DeviceCommand.RETURN);
        DeviceStatus.addStatus(1025, "Diagnostic mode", null);
        DeviceStatus.addStatus(1026, "End of live", null);
        DeviceStatus.addStatus(1281, "Software update", null);
    }

    private static void addStatus(int code_, String message_, DeviceCommand associatedCommand_) {
        statusMap.put(code_, new DeviceStatus(code_, message_, associatedCommand_));
    }

    private DeviceStatus(int code_, String message_, DeviceCommand associatedCommand_) {
        this.code = code_;
        this.message = message_;
        this.associatedCommand = associatedCommand_;
    }

    public static DeviceStatus decodeStatusCode(int code_) {
        DeviceStatus status;
        if (statusMap.isEmpty()) {
            DeviceStatus.addAllKnownStatusCodes();
        }
        if ((status = statusMap.get(code_)) == null) {
            DeviceCommand command = null;
            if ((code_ & 0xFF00) == 256) {
                command = DeviceCommand.RETURN;
            }
            if ((code_ & 0xFF00) == 512) {
                command = DeviceCommand.MOW;
            }
            if ((code_ & 0xFF00) == 768) {
                command = DeviceCommand.RETURN;
            }
            status = new DeviceStatus(code_, String.format("Unknown status code %d", code_), command);
            statusMap.put(status.getCode(), status);
        }
        return status;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public DeviceCommand getAssociatedCommand() {
        return this.associatedCommand;
    }

    public String toString() {
        return "DeviceStatus [code=" + this.code + ", message=" + this.message + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.code;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceStatus other = (DeviceStatus)obj;
        return this.code == other.code;
    }
}

