/*
 * Decompiled with CFR 0.152.
 */
package de.zazaz.iot.bosch.indego;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.zazaz.iot.bosch.indego.AuthenticationRequest;
import de.zazaz.iot.bosch.indego.AuthenticationResponse;
import de.zazaz.iot.bosch.indego.DeviceCalendar;
import de.zazaz.iot.bosch.indego.DeviceCommand;
import de.zazaz.iot.bosch.indego.DeviceStateInformation;
import de.zazaz.iot.bosch.indego.IndegoAuthenticationException;
import de.zazaz.iot.bosch.indego.IndegoException;
import de.zazaz.iot.bosch.indego.IndegoInvalidCommandException;
import de.zazaz.iot.bosch.indego.SetStateRequest;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class IndegoController {
    public static final String BASE_URL_DEFAULT = "https://api.indego.iot.bosch-si.com/api/v1/";
    public static final long MIN_STATE_QUERY_INTERVAL_MS = 60000L;
    private final String baseUrl;
    private final ObjectMapper mapper = new ObjectMapper();
    private final String authentication;
    private CloseableHttpClient httpClient;
    private AuthenticationResponse session;
    private long lastStateQueryTs;
    private DeviceStateInformation deviceStateCache;

    public IndegoController(String baseUrl_, String username_, String password_) {
        this.baseUrl = baseUrl_ == null ? BASE_URL_DEFAULT : this.normalizeBaseUrl(baseUrl_);
        this.authentication = Base64.encodeBase64String((byte[])(username_ + ":" + password_).getBytes());
    }

    public IndegoController(String username_, String password_) {
        this.baseUrl = BASE_URL_DEFAULT;
        this.authentication = Base64.encodeBase64String((byte[])(username_ + ":" + password_).getBytes());
    }

    private String normalizeBaseUrl(String baseUrl_) {
        return baseUrl_.endsWith("/") ? baseUrl_ : baseUrl_ + "/";
    }

    public void connect() throws IndegoAuthenticationException, IndegoException {
        if (this.httpClient != null) {
            throw new IndegoException("You are already connected");
        }
        try {
            this.httpClient = HttpClients.createDefault();
            this.session = this.doAuthenticate();
            this.lastStateQueryTs = 0L;
        }
        catch (IndegoException ex) {
            this.safeCloseClient();
            throw ex;
        }
        catch (Exception ex) {
            this.safeCloseClient();
            throw new IndegoException(ex);
        }
    }

    public void disconnect() {
        this.safeCloseClient();
    }

    public String getDeviceSerialNumber() throws IndegoException {
        return this.session.getAlmSn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceStateInformation getState() throws IndegoException {
        IndegoController indegoController = this;
        synchronized (indegoController) {
            DeviceStateInformation state;
            if (this.deviceStateCache != null && System.currentTimeMillis() - 60000L < this.lastStateQueryTs) {
                return this.deviceStateCache;
            }
            this.deviceStateCache = state = this.doGetRequest("alms/" + this.session.getAlmSn() + "/state", DeviceStateInformation.class);
            this.lastStateQueryTs = System.currentTimeMillis();
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceCalendar getCalendar() throws IndegoException {
        IndegoController indegoController = this;
        synchronized (indegoController) {
            DeviceCalendar calendar = this.doGetRequest("alms/" + this.session.getAlmSn() + "/calendar", DeviceCalendar.class);
            return calendar;
        }
    }

    public void sendCommand(DeviceCommand command_) throws IndegoInvalidCommandException, IndegoException {
        this.lastStateQueryTs = 0L;
        SetStateRequest request = new SetStateRequest();
        request.setState(command_.getActionCode());
        this.doPutRequest("alms/" + this.session.getAlmSn() + "/state", request, null);
    }

    private void safeCloseClient() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.httpClient = null;
    }

    private AuthenticationResponse doAuthenticate() throws IndegoAuthenticationException, IndegoException {
        try {
            HttpPost httpPost = new HttpPost(this.baseUrl + "authenticate");
            httpPost.addHeader("Authorization", "Basic " + this.authentication);
            AuthenticationRequest authRequest = new AuthenticationRequest();
            authRequest.setDevice("");
            authRequest.setOsType("Android");
            authRequest.setOsVersion("4.0");
            authRequest.setDeviceManufacturer("unknown");
            authRequest.setDeviceType("unknown");
            String json = this.mapper.writeValueAsString((Object)authRequest);
            httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            int status = response.getStatusLine().getStatusCode();
            if (status == 401) {
                throw new IndegoAuthenticationException("Was not able to authenticate");
            }
            if (status != 200 && status != 201) {
                throw new IndegoAuthenticationException("The request failed with error: " + response.getStatusLine().toString());
            }
            String responseContents = EntityUtils.toString((HttpEntity)response.getEntity());
            AuthenticationResponse authResponse = (AuthenticationResponse)this.mapper.readValue(responseContents, AuthenticationResponse.class);
            return authResponse;
        }
        catch (IOException ex) {
            throw new IndegoException(ex);
        }
    }

    private <T> T doGetRequest(String urlSuffix, Class<? extends T> returnType) throws IndegoException {
        try {
            HttpGet httpRequest = new HttpGet(this.baseUrl + urlSuffix);
            httpRequest.setHeader("x-im-context-id", this.session.getContextId());
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IndegoAuthenticationException("The request failed with error: " + response.getStatusLine().toString());
            }
            String responseContents = EntityUtils.toString((HttpEntity)response.getEntity());
            if (returnType == null) {
                return null;
            }
            Object result = this.mapper.readValue(responseContents, returnType);
            return (T)result;
        }
        catch (IOException ex) {
            throw new IndegoException(ex);
        }
    }

    private <T> T doPutRequest(String urlSuffix, Object request, Class<? extends T> returnType) throws IndegoException {
        try {
            HttpPut httpRequest = new HttpPut(this.baseUrl + urlSuffix);
            httpRequest.setHeader("x-im-context-id", this.session.getContextId());
            String json = this.mapper.writeValueAsString(request);
            httpRequest.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequest);
            if (response.getStatusLine().getStatusCode() == 500) {
                throw new IndegoInvalidCommandException("The request failed with error: " + response.getStatusLine().toString());
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IndegoAuthenticationException("The request failed with error: " + response.getStatusLine().toString());
            }
            String responseContents = EntityUtils.toString((HttpEntity)response.getEntity());
            if (returnType == null) {
                return null;
            }
            Object result = this.mapper.readValue(responseContents, returnType);
            return (T)result;
        }
        catch (IOException ex) {
            throw new IndegoException(ex);
        }
    }
}

