/*
 * Decompiled with CFR 0.152.
 */
package dev.adamko.dokkatoo.tasks;

import dev.adamko.dokkatoo.internal.DokkatooInternalApi;
import dev.adamko.dokkatoo.internal.UriUtilsKt;
import dev.adamko.dokkatoo.tasks.DokkatooTask;
import dev.adamko.dokkatoo.tasks.LogHtmlPublicationLinkTask;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.api.provider.ValueSourceSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisableCachingByDefault(because="logging-only task")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0010"}, d2={"Ldev/adamko/dokkatoo/tasks/LogHtmlPublicationLinkTask;", "Ldev/adamko/dokkatoo/tasks/DokkatooTask;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)V", "indexHtmlPath", "Lorg/gradle/api/provider/Property;", "", "getIndexHtmlPath", "()Lorg/gradle/api/provider/Property;", "serverUri", "getServerUri", "exec", "", "Companion", "ServerActiveCheck", "dokkatoo-plugin"})
@SourceDebugExtension(value={"SMAP\nLogHtmlPublicationLinkTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogHtmlPublicationLinkTask.kt\ndev/adamko/dokkatoo/tasks/LogHtmlPublicationLinkTask\n+ 2 GradleApiKotlinDslExtensions_4eu6i08rw85sthowmqs31rom6.kt\norg/gradle/kotlin/dsl/GradleApiKotlinDslExtensions_4eu6i08rw85sthowmqs31rom6Kt\n*L\n1#1,185:1\n42#2:186\n*S KotlinDebug\n*F\n+ 1 LogHtmlPublicationLinkTask.kt\ndev/adamko/dokkatoo/tasks/LogHtmlPublicationLinkTask\n*L\n83#1:186\n*E\n"})
public abstract class LogHtmlPublicationLinkTask
extends DokkatooTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ENABLE_TASK_PROPERTY_NAME = "dev.adamko.dokkatoo.tasks.logHtmlPublicationLinkEnabled";

    /*
     * WARNING - void declaration
     */
    @Inject
    @DokkatooInternalApi
    public LogHtmlPublicationLinkTask(@NotNull ProviderFactory providers) {
        void valueSourceType$iv;
        void $this$of$iv;
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        this.setGroup("other");
        ProviderFactory providerFactory = providers;
        Class<ServerActiveCheck> clazz = ServerActiveCheck.class;
        Action configuration$iv = new Action(this){
            final /* synthetic */ LogHtmlPublicationLinkTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull ValueSourceSpec<ServerActiveCheck.Parameters> $this$of) {
                Intrinsics.checkNotNullParameter($this$of, (String)"$this$of");
                ((ServerActiveCheck.Parameters)$this$of.getParameters()).getUri().convention((Provider)this.this$0.getServerUri());
            }
        };
        boolean $i$f$of = false;
        Provider provider = $this$of$iv.of((Class)valueSourceType$iv, configuration$iv);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"`of`(`valueSourceType`.java, `configuration`)");
        Provider serverActive2 = provider;
        super.onlyIf("server URL is reachable", new Spec((Provider<Boolean>)serverActive2){
            final /* synthetic */ Provider<Boolean> $serverActive;
            {
                this.$serverActive = $serverActive;
            }

            public final boolean isSatisfiedBy(Task it) {
                Object object = this.$serverActive.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"serverActive.get()");
                return (Boolean)object;
            }
        });
        Provider provider2 = providers.gradleProperty(ENABLE_TASK_PROPERTY_NAME).map((Transformer)logHtmlPublicationLinkTaskEnabled.1.INSTANCE).orElse((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providers\n      .gradleP\u2026lean)\n      .orElse(true)");
        Provider logHtmlPublicationLinkTaskEnabled2 = provider2;
        super.onlyIf("task is enabled via property", new Spec((Provider<Boolean>)logHtmlPublicationLinkTaskEnabled2){
            final /* synthetic */ Provider<Boolean> $logHtmlPublicationLinkTaskEnabled;
            {
                this.$logHtmlPublicationLinkTaskEnabled = $logHtmlPublicationLinkTaskEnabled;
            }

            public final boolean isSatisfiedBy(Task it) {
                Object object = this.$logHtmlPublicationLinkTaskEnabled.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"logHtmlPublicationLinkTaskEnabled.get()");
                return (Boolean)object;
            }
        });
        super.onlyIf("serverUri is present", new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                CharSequence charSequence = (CharSequence)this.getServerUri().getOrNull();
                return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
            }
        });
        super.onlyIf("indexHtmlPath is present", new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                CharSequence charSequence = (CharSequence)this.getIndexHtmlPath().getOrNull();
                return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
            }
        });
    }

    @Console
    @NotNull
    public abstract Property<String> getServerUri();

    @Console
    @NotNull
    public abstract Property<String> getIndexHtmlPath();

    @TaskAction
    public final void exec() {
        Object object = this.getServerUri().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"serverUri.get()");
        String serverUri = (String)object;
        Object object2 = this.getIndexHtmlPath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"indexHtmlPath.get()");
        String indexHtmlPath2 = (String)object2;
        this.getLogger().info("LogHtmlPublicationLinkTask received variables serverUri:" + serverUri + ", indexHtmlPath:" + indexHtmlPath2);
        URI link = UriUtilsKt.appendPath(new URI(serverUri), indexHtmlPath2);
        this.getLogger().lifecycle("Generated Dokka HTML publication: " + link);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldev/adamko/dokkatoo/tasks/LogHtmlPublicationLinkTask$Companion;", "", "()V", "ENABLE_TASK_PROPERTY_NAME", "", "dokkatoo-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J\r\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\tR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/adamko/dokkatoo/tasks/LogHtmlPublicationLinkTask$ServerActiveCheck;", "Lorg/gradle/api/provider/ValueSource;", "", "Ldev/adamko/dokkatoo/tasks/LogHtmlPublicationLinkTask$ServerActiveCheck$Parameters;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "obtain", "()Ljava/lang/Boolean;", "Parameters", "dokkatoo-plugin"})
    public static abstract class ServerActiveCheck
    implements ValueSource<Boolean, Parameters> {
        private final Logger logger = LoggerFactory.getLogger(ServerActiveCheck.class);

        @NotNull
        public Boolean obtain() {
            try {
                URI uri = URI.create((String)((Parameters)this.getParameters()).getUri().get());
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofSeconds(1L)).GET().build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                this.logger.info("got " + response.statusCode() + " from " + uri);
                return response.statusCode() > 0;
            }
            catch (Exception ex) {
                this.logger.info("could not reach URI " + ((Parameters)this.getParameters()).getUri().get() + ": " + ex);
                return false;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Ldev/adamko/dokkatoo/tasks/LogHtmlPublicationLinkTask$ServerActiveCheck$Parameters;", "Lorg/gradle/api/provider/ValueSourceParameters;", "uri", "Lorg/gradle/api/provider/Property;", "", "getUri", "()Lorg/gradle/api/provider/Property;", "dokkatoo-plugin"})
        public static interface Parameters
        extends ValueSourceParameters {
            @NotNull
            public Property<String> getUri();
        }
    }
}

