/*
 * Decompiled with CFR 0.152.
 */
package dev.aemvite.aem.utilities;

import com.adobe.cq.sightly.WCMUsePojo;
import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientLibUseObject
extends WCMUsePojo {
    private static final Logger log = LoggerFactory.getLogger(ClientLibUseObject.class);
    protected String[] categories;
    protected String mode;
    protected Boolean esModule;
    protected HtmlLibraryManager htmlLibraryManager = null;
    protected SlingHttpServletRequest request;
    protected Resource resource;
    protected SlingScriptHelper sling;
    public static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "aemViteClientLibsService");

    public void activate() {
        Object categoriesObject = this.get("categories", Object.class);
        this.resource = (Resource)this.get("resource", Resource.class);
        this.request = (SlingHttpServletRequest)this.get("request", SlingHttpServletRequest.class);
        if (categoriesObject != null) {
            this.getCategoriesFromBinding(categoriesObject);
            if (this.categories != null && this.categories.length > 0) {
                this.mode = (String)this.get("mode", String.class);
                this.esModule = (Boolean)this.get("esModule", Boolean.class);
                this.sling = (SlingScriptHelper)this.get("sling", SlingScriptHelper.class);
                if (this.sling != null) {
                    this.htmlLibraryManager = (HtmlLibraryManager)this.sling.getService(HtmlLibraryManager.class);
                } else {
                    throw new IllegalStateException("Unable to get an instance of SlingScriptHelper. This is required to get an instance of HtmlLibraryManager.");
                }
            }
        }
    }

    public final String include() {
        StringWriter sw = new StringWriter();
        if (this.categories == null || this.categories.length == 0) {
            log.error("'categories' option might be missing from the invocation of the /apps/granite/sightly/templates/clientlib.html client libraries template library. Please provide a CSV list or an array of categories to include.");
        } else {
            PrintWriter out = new PrintWriter(sw);
            if ("js".equalsIgnoreCase(this.mode)) {
                this.includeLibraries(out, LibraryType.JS);
            } else if ("css".equalsIgnoreCase(this.mode)) {
                this.includeLibraries(out, LibraryType.CSS);
            } else {
                this.includeLibraries(out, LibraryType.CSS);
                this.includeLibraries(out, LibraryType.JS);
            }
        }
        return sw.toString();
    }

    private void getCategoriesFromBinding(Object categoriesObject) {
        block3: {
            block2: {
                if (!(categoriesObject instanceof Object[])) break block2;
                Object[] categoriesArray = (Object[])categoriesObject;
                this.categories = new String[categoriesArray.length];
                int i = 0;
                for (Object o : categoriesArray) {
                    if (!(o instanceof String)) continue;
                    this.categories[i++] = ((String)o).trim();
                }
                break block3;
            }
            if (!(categoriesObject instanceof String)) break block3;
            this.categories = ((String)categoriesObject).split(",");
            int i = 0;
            for (String c : this.categories) {
                this.categories[i++] = c.trim();
            }
        }
    }

    public String[] getCategories() {
        return this.categories;
    }

    private void includeLibraries(PrintWriter out, LibraryType libraryType) {
        if (this.htmlLibraryManager != null && libraryType != null) {
            Collection libs = this.htmlLibraryManager.getLibraries(this.categories, libraryType, false, true);
            for (ClientLibrary lib : libs) {
                String path = this.getIncludePath(this.request, lib, libraryType, this.htmlLibraryManager.isMinifyEnabled());
                if (path == null) continue;
                this.generateOutputForClientLib(lib, path, libraryType, out);
            }
        }
    }

    protected final String getIncludePath(SlingHttpServletRequest request, ClientLibrary lib, LibraryType libraryType, boolean minify) {
        String path = lib.getIncludePath(libraryType, minify);
        if (this.needsProxy(lib, path)) {
            path = this.getClientLibProxyPath(path);
        } else if (request.getResourceResolver().getResource(lib.getPath()) == null) {
            path = null;
        }
        return path;
    }

    protected final boolean needsProxy(ClientLibrary lib, String path) {
        return lib.allowProxy() && (path.startsWith("/libs/") || path.startsWith("/apps/"));
    }

    protected final String getClientLibProxyPath(String path) {
        return "/etc.clientlibs" + path.substring(5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean clientlibHasProperty(ClientLibrary lib, String property) {
        ResourceResolverFactory factory = (ResourceResolverFactory)this.sling.getService(ResourceResolverFactory.class);
        if (factory == null) {
            log.warn("No valid ResourceResolverFactory service could be retrieved");
            return false;
        }
        try (ResourceResolver resourceResolver = factory.getServiceResourceResolver(AUTH_INFO);){
            Resource libResource = resourceResolver.resolve(lib.getPath());
            if (ResourceUtil.isNonExistingResource((Resource)libResource)) return false;
            ValueMap libProps = libResource.getValueMap();
            boolean bl = Boolean.TRUE.equals(libProps.get(property, Boolean.class));
            return bl;
        }
        catch (LoginException ex) {
            log.error("Unable to retrieve resource resolver for 'aem-vite-clientlibs'.");
            log.error(String.valueOf((Object)ex));
        }
        return false;
    }

    protected void generateOutputForClientLib(ClientLibrary lib, String path, LibraryType libraryType, PrintWriter out) {
        String attributes = this.getLibraryTypeAttributes(lib, libraryType).toString();
        String tag = libraryType.equals((Object)LibraryType.CSS) ? "<link rel=\"stylesheet\" href=\"%s\"%s>\n" : "<script src=\"%s\"%s></script>\n";
        out.format(tag, path, attributes);
    }

    protected StringBuilder getLibraryTypeAttributes(ClientLibrary lib, LibraryType libraryType) {
        StringBuilder attributes = new StringBuilder();
        if (libraryType.equals((Object)LibraryType.JS)) {
            if (this.clientlibHasProperty(lib, "esModule")) {
                attributes.append(" type=\"module\"");
            }
            if (this.clientlibHasProperty(lib, "noModule")) {
                attributes.append(" nomodule");
            }
        }
        return attributes;
    }
}

