/*
 * Decompiled with CFR 0.152.
 */
package dev.akif.crud;

import dev.akif.crud.common.InstantProvider;
import java.time.Instant;
import java.time.temporal.ChronoField;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nJ\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0006\u0010\f\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/akif/crud/AdjustableInstantProvider;", "Ldev/akif/crud/common/InstantProvider;", "instant", "Ljava/time/Instant;", "adjustmentMillis", "", "(Ljava/time/Instant;J)V", "adjust", "", "f", "Lkotlin/Function1;", "now", "reset", "Companion", "test"})
public final class AdjustableInstantProvider
implements InstantProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Instant instant;
    private long adjustmentMillis;
    @NotNull
    private static final Logger log;

    public AdjustableInstantProvider(@NotNull Instant instant, long adjustmentMillis) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        this.instant = instant;
        this.adjustmentMillis = adjustmentMillis;
    }

    public /* synthetic */ AdjustableInstantProvider(Instant instant, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Instant instant2 = Instant.now().with(ChronoField.NANO_OF_SECOND, 0L);
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now().with(ChronoField.NANO_OF_SECOND, 0)");
            instant = instant2;
        }
        if ((n & 2) != 0) {
            l = 0L;
        }
        this(instant, l);
    }

    @NotNull
    public Instant now() {
        Instant instant = this.instant.plusMillis(this.adjustmentMillis);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant.plusMillis(adjustmentMillis)");
        return instant;
    }

    public final void adjust(@NotNull Function1<? super Instant, Instant> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Instant before = this.now();
        Instant after = (Instant)f.invoke((Object)this.now());
        this.adjustmentMillis = after.toEpochMilli() - before.toEpochMilli();
        log.debug("Adjusted instant provider by " + this.adjustmentMillis + "ms, it was " + before + " and it is now " + after);
    }

    public final void reset() {
        this.adjustmentMillis = 0L;
        log.debug("Reset instant provider, it is now " + this.now());
    }

    public AdjustableInstantProvider() {
        this(null, 0L, 3, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(AdjustableInstantProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(AdjustableInstantProvider::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldev/akif/crud/AdjustableInstantProvider$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

