/*
 * Decompiled with CFR 0.152.
 */
package dev.akif.crud;

import dev.akif.crud.CRUDCreateModel;
import dev.akif.crud.CRUDEntity;
import dev.akif.crud.CRUDMapper;
import dev.akif.crud.CRUDModel;
import dev.akif.crud.CRUDRepository;
import dev.akif.crud.CRUDService;
import dev.akif.crud.CRUDServiceTest;
import dev.akif.crud.CRUDTestData;
import dev.akif.crud.CRUDUpdateModel;
import dev.akif.crud.InMemoryCRUDRepository;
import dev.akif.crud.common.Paged;
import dev.akif.crud.error.CRUDError;
import dev.akif.crud.error.CRUDErrorException;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u0004*\u000e\b\u0002\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00010\u0006*\b\b\u0003\u0010\u0007*\u00020\b*\b\b\u0004\u0010\t*\u00020\n*&\b\u0005\u0010\u000b* \u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\t0\f*\u0014\b\u0006\u0010\r*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u000e*2\b\u0007\u0010\u000f*,\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000b0\u0010*,\b\b\u0010\u0011*&\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u00110\u00122\u00020\u0013:\u0005*+,-.B/\u0012\u0006\u0010\u0014\u001a\u00028\u0005\u0012\u0006\u0010\u0015\u001a\u00028\b\u0012\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\b\u0012\u0004\u0012\u00028\u00070\u0017\u00a2\u0006\u0002\u0010\u0018J\b\u0010'\u001a\u00020(H$J\b\u0010)\u001a\u00020(H\u0007R&\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\b\u0012\u0004\u0012\u00028\u00070\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u0014\u001a\u00028\u0005X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001e\u001a\u00028\u0007X\u0084.\u00a2\u0006\u0010\n\u0002\u0010#\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0016\u0010\u0015\u001a\u00028\bX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b$\u0010%\u00a8\u0006/"}, d2={"Ldev/akif/crud/CRUDServiceTest;", "I", "Ljava/io/Serializable;", "E", "Ldev/akif/crud/CRUDEntity;", "M", "Ldev/akif/crud/CRUDModel;", "CM", "Ldev/akif/crud/CRUDCreateModel;", "UM", "Ldev/akif/crud/CRUDUpdateModel;", "Mapper", "Ldev/akif/crud/CRUDMapper;", "R", "Ldev/akif/crud/CRUDRepository;", "S", "Ldev/akif/crud/CRUDService;", "TestData", "Ldev/akif/crud/CRUDTestData;", "", "mapper", "testData", "buildService", "Lkotlin/Function2;", "(Ldev/akif/crud/CRUDMapper;Ldev/akif/crud/CRUDTestData;Lkotlin/jvm/functions/Function2;)V", "getBuildService", "()Lkotlin/jvm/functions/Function2;", "getMapper", "()Ldev/akif/crud/CRUDMapper;", "Ldev/akif/crud/CRUDMapper;", "service", "getService", "()Ldev/akif/crud/CRUDService;", "setService", "(Ldev/akif/crud/CRUDService;)V", "Ldev/akif/crud/CRUDService;", "getTestData", "()Ldev/akif/crud/CRUDTestData;", "Ldev/akif/crud/CRUDTestData;", "resetData", "", "setUp", "Creating", "Deleting", "Getting", "Listing", "Updating", "test"})
public abstract class CRUDServiceTest<I extends Serializable, E extends CRUDEntity<I>, M extends CRUDModel<? extends I>, CM extends CRUDCreateModel, UM extends CRUDUpdateModel, Mapper extends CRUDMapper<I, E, ? extends M, ? super CM, ? super UM>, R extends CRUDRepository<I, E>, S extends CRUDService<I, E, ? extends M, ? super CM, ? super UM, ? extends R, ? extends Mapper>, TestData extends CRUDTestData<I, E, M, CM, UM, TestData>> {
    @NotNull
    private final Mapper mapper;
    @NotNull
    private final TestData testData;
    @NotNull
    private final Function2<Mapper, TestData, S> buildService;
    protected S service;

    public CRUDServiceTest(@NotNull Mapper mapper, @NotNull TestData testData, @NotNull Function2<? super Mapper, ? super TestData, ? extends S> buildService) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter(testData, (String)"testData");
        Intrinsics.checkNotNullParameter(buildService, (String)"buildService");
        this.mapper = mapper;
        this.testData = testData;
        this.buildService = buildService;
    }

    @NotNull
    protected final Mapper getMapper() {
        return this.mapper;
    }

    @NotNull
    protected final TestData getTestData() {
        return this.testData;
    }

    @NotNull
    protected final Function2<Mapper, TestData, S> getBuildService() {
        return this.buildService;
    }

    @NotNull
    protected final S getService() {
        S s = this.service;
        if (s != null) {
            return s;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"service");
        return null;
    }

    protected final void setService(@NotNull S s) {
        Intrinsics.checkNotNullParameter(s, (String)"<set-?>");
        this.service = s;
    }

    protected abstract void resetData();

    @BeforeEach
    public final void setUp() {
        this.resetData();
        ((CRUDTestData)this.testData).getInstantProvider().reset();
        this.setService((CRUDService)this.buildService.invoke(this.mapper, this.testData));
    }

    @DisplayName(value="creating new entities")
    @Nested
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Ldev/akif/crud/CRUDServiceTest$Creating;", "", "(Ldev/akif/crud/CRUDServiceTest;)V", "testCreate", "", "testCreateAgain", "testCreateAlreadyExists", "test"})
    @SourceDebugExtension(value={"SMAP\nCRUDServiceTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CRUDServiceTest.kt\ndev/akif/crud/CRUDServiceTest$Creating\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1#2:334\n*E\n"})
    public final class Creating {
        @DisplayName(value="should fail with already exists error when trying to create an entity that already exists")
        @Test
        public final void testCreateAlreadyExists() {
            Object createModel = ((CRUDTestData)CRUDServiceTest.this.getTestData()).entityToCreateModel(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            CRUDErrorException exception = (CRUDErrorException)Assertions.assertThrows(CRUDErrorException.class, () -> Creating.testCreateAlreadyExists$lambda$0(CRUDServiceTest.this, createModel));
            CRUDError actual = exception.getError();
            CRUDError expected2 = new CRUDError(HttpStatus.CONFLICT, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTypeName() + " with " + createModel + " already exists.");
            Assertions.assertEquals((Object)expected2, (Object)actual);
        }

        /*
         * WARNING - void declaration
         */
        @DisplayName(value="should create a new entity and return it")
        @Test
        public final void testCreate() {
            void $this$testCreate_u24lambda_u241;
            Object e;
            ((CRUDTestData)CRUDServiceTest.this.getTestData()).getRepository().clear();
            Object createModel = ((CRUDTestData)CRUDServiceTest.this.getTestData()).entityToCreateModel(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            CRUDModel actual = CRUDServiceTest.this.getService().create(createModel, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters());
            Object e2 = e = ((CRUDTestData)CRUDServiceTest.this.getTestData()).copy(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            Object Mapper = CRUDServiceTest.this.getMapper();
            boolean bl = false;
            $this$testCreate_u24lambda_u241.setId(actual.id());
            CRUDModel expected2 = Mapper.entityToModel(e);
            Assertions.assertEquals((Object)expected2, (Object)actual);
            CRUDModel found = CRUDServiceTest.this.getService().get(actual.id(), ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters());
            Assertions.assertEquals((Object)expected2, (Object)found);
        }

        /*
         * WARNING - void declaration
         */
        @DisplayName(value="should create a new entity with the same data of a deleted entity and return it")
        @Test
        public final void testCreateAgain() {
            void $this$testCreateAgain_u24lambda_u243;
            void $this$testCreateAgain_u24lambda_u242;
            Object e = ((CRUDTestData)CRUDServiceTest.this.getTestData()).copy(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            CRUDServiceTest cRUDServiceTest = CRUDServiceTest.this;
            Object e2 = e;
            InMemoryCRUDRepository inMemoryCRUDRepository = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getRepository();
            boolean bl = false;
            $this$testCreateAgain_u24lambda_u242.setDeletedAt(((CRUDTestData)cRUDServiceTest.getTestData()).now());
            inMemoryCRUDRepository.update(e);
            Object createModel = ((CRUDTestData)CRUDServiceTest.this.getTestData()).entityToCreateModel(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            CRUDModel actual = CRUDServiceTest.this.getService().create(createModel, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters());
            Object e3 = bl = ((CRUDTestData)CRUDServiceTest.this.getTestData()).copy(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            inMemoryCRUDRepository = CRUDServiceTest.this.getMapper();
            boolean bl2 = false;
            $this$testCreateAgain_u24lambda_u243.setId(actual.id());
            CRUDModel expected2 = inMemoryCRUDRepository.entityToModel((CRUDEntity)bl);
            Assertions.assertEquals((Object)expected2, (Object)actual);
            CRUDModel found = CRUDServiceTest.this.getService().get(actual.id(), ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters());
            Assertions.assertEquals((Object)expected2, (Object)found);
            Assertions.assertNotEquals(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1(), (Object)found);
        }

        private static final void testCreateAlreadyExists$lambda$0(CRUDServiceTest this$0, CRUDCreateModel $createModel) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$createModel, (String)"$createModel");
            this$0.getService().create($createModel, ((CRUDTestData)this$0.getTestData()).getTestParameters());
        }
    }

    @DisplayName(value="deleting an entity")
    @Nested
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Ldev/akif/crud/CRUDServiceTest$Deleting;", "", "(Ldev/akif/crud/CRUDServiceTest;)V", "testDelete", "", "testDeleteNotFound", "test"})
    @SourceDebugExtension(value={"SMAP\nCRUDServiceTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CRUDServiceTest.kt\ndev/akif/crud/CRUDServiceTest$Deleting\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1#2:334\n*E\n"})
    public final class Deleting {
        @DisplayName(value="should fail with not found error when trying to delete an entity that doesn't exist")
        @Test
        public final void testDeleteNotFound() {
            Object id = ((CRUDTestData)CRUDServiceTest.this.getTestData()).randomId();
            CRUDErrorException exception = (CRUDErrorException)Assertions.assertThrows(CRUDErrorException.class, () -> Deleting.testDeleteNotFound$lambda$0(CRUDServiceTest.this, id));
            CRUDError actual = exception.getError();
            CRUDError expected2 = new CRUDError(HttpStatus.NOT_FOUND, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTypeName() + " with id " + id + " is not found.");
            Assertions.assertEquals((Object)expected2, (Object)actual);
        }

        /*
         * WARNING - void declaration
         */
        @DisplayName(value="should delete")
        @Test
        public final void testDelete() {
            void $this$testDelete_u24lambda_u241;
            CRUDModel cRUDModel;
            Object object;
            Object object2;
            Instant oneSecondLater = ((CRUDTestData)CRUDServiceTest.this.getTestData()).now().plusSeconds(1L);
            ((CRUDTestData)CRUDServiceTest.this.getTestData()).getInstantProvider().adjust((Function1<? super Instant, Instant>)((Function1)testDelete.1.INSTANCE));
            Object s = CRUDServiceTest.this.getService();
            Serializable serializable = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1().getId();
            Intrinsics.checkNotNull((Object)serializable);
            s.delete(serializable, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters());
            Object s2 = CRUDServiceTest.this.getService();
            Serializable serializable2 = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1().getId();
            Intrinsics.checkNotNull((Object)serializable2);
            Assertions.assertNull((Object)s2.get(serializable2, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters()));
            Map map = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getRepository().getEntities();
            Serializable serializable3 = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1().getId();
            Intrinsics.checkNotNull((Object)serializable3);
            CRUDEntity cRUDEntity = (CRUDEntity)map.get(serializable3);
            if (cRUDEntity != null) {
                object2 = cRUDEntity;
                object = CRUDServiceTest.this.getMapper();
                CRUDEntity p0 = object2;
                boolean bl = false;
                cRUDModel = object.entityToModel(p0);
            } else {
                cRUDModel = null;
            }
            CRUDModel actual = cRUDModel;
            object2 = ((CRUDTestData)CRUDServiceTest.this.getTestData()).copy(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            object = object2;
            Object Mapper = CRUDServiceTest.this.getMapper();
            boolean bl = false;
            Integer n = $this$testDelete_u24lambda_u241.getVersion();
            $this$testDelete_u24lambda_u241.setVersion(n != null ? Integer.valueOf(n + 1) : null);
            $this$testDelete_u24lambda_u241.setUpdatedAt(oneSecondLater);
            $this$testDelete_u24lambda_u241.setDeletedAt(oneSecondLater);
            CRUDModel expected2 = Mapper.entityToModel(object2);
            Assertions.assertEquals((Object)expected2, (Object)actual);
        }

        private static final void testDeleteNotFound$lambda$0(CRUDServiceTest this$0, Serializable $id) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
            this$0.getService().delete($id, ((CRUDTestData)this$0.getTestData()).getTestParameters());
        }
    }

    @DisplayName(value="getting an entity")
    @Nested
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Ldev/akif/crud/CRUDServiceTest$Getting;", "", "(Ldev/akif/crud/CRUDServiceTest;)V", "testGet", "", "testGetDeletedNotFound", "testGetNotFound", "test"})
    @SourceDebugExtension(value={"SMAP\nCRUDServiceTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CRUDServiceTest.kt\ndev/akif/crud/CRUDServiceTest$Getting\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1#2:334\n*E\n"})
    public final class Getting {
        @DisplayName(value="should return null when trying to get an entity that doesn't exist")
        @Test
        public final void testGetNotFound() {
            Assertions.assertNull((Object)CRUDServiceTest.this.getService().get(((CRUDTestData)CRUDServiceTest.this.getTestData()).randomId(), ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters()));
        }

        @DisplayName(value="should return correct entity")
        @Test
        public final void testGet() {
            Object s = CRUDServiceTest.this.getService();
            Serializable serializable = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1().getId();
            Intrinsics.checkNotNull((Object)serializable);
            CRUDModel actual = s.get(serializable, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters());
            CRUDModel expected2 = CRUDServiceTest.this.getMapper().entityToModel(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            Assertions.assertEquals((Object)expected2, (Object)actual);
        }

        /*
         * WARNING - void declaration
         */
        @DisplayName(value="should return null when trying to get a deleted entity")
        @Test
        public final void testGetDeletedNotFound() {
            void $this$testGetDeletedNotFound_u24lambda_u240;
            Object e = ((CRUDTestData)CRUDServiceTest.this.getTestData()).copy(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            CRUDServiceTest cRUDServiceTest = CRUDServiceTest.this;
            Object e2 = e;
            InMemoryCRUDRepository inMemoryCRUDRepository = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getRepository();
            boolean bl = false;
            $this$testGetDeletedNotFound_u24lambda_u240.setDeletedAt(((CRUDTestData)cRUDServiceTest.getTestData()).now());
            inMemoryCRUDRepository.update(e);
            Object s = CRUDServiceTest.this.getService();
            Serializable serializable = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1().getId();
            Intrinsics.checkNotNull((Object)serializable);
            Assertions.assertNull((Object)s.get(serializable, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters()));
        }
    }

    @DisplayName(value="listing entities")
    @Nested
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Ldev/akif/crud/CRUDServiceTest$Listing;", "", "(Ldev/akif/crud/CRUDServiceTest;)V", "testListWithDefaultPagination", "", "testListWithNoDeletedEntities", "testListWithNoEntities", "testListWithPagination", "test"})
    @SourceDebugExtension(value={"SMAP\nCRUDServiceTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CRUDServiceTest.kt\ndev/akif/crud/CRUDServiceTest$Listing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1549#2:334\n1620#2,3:335\n1855#2,2:338\n1#3:340\n*S KotlinDebug\n*F\n+ 1 CRUDServiceTest.kt\ndev/akif/crud/CRUDServiceTest$Listing\n*L\n126#1:334\n126#1:335,3\n138#1:338,2\n*E\n"})
    public final class Listing {
        /*
         * WARNING - void declaration
         */
        @DisplayName(value="should return some entities with default pagination")
        @Test
        public final void testListWithDefaultPagination() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object s = CRUDServiceTest.this.getService();
            PageRequest pageRequest = PageRequest.of((int)0, (int)20);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(0, 20)");
            Paged actual = s.list((Pageable)pageRequest, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters());
            Iterable iterable = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getDefaultFirstPageEntities();
            Object Mapper = CRUDServiceTest.this.getMapper();
            boolean $i$f$map = false;
            void var6_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                CRUDEntity cRUDEntity = (CRUDEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Mapper.entityToModel((CRUDEntity)p0));
            }
            int n = 1;
            int n2 = 20;
            int n3 = 0;
            List list = (List)destination$iv$iv;
            Paged expected2 = new Paged(list, n3, n2, n);
            Assertions.assertEquals((Object)expected2, (Object)actual);
        }

        /*
         * WARNING - void declaration
         */
        @DisplayName(value="should return correct entities with pagination")
        @Test
        public final void testListWithPagination() {
            void $this$forEach$iv;
            Iterable iterable = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getPaginationTestCases();
            CRUDServiceTest cRUDServiceTest = CRUDServiceTest.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                PageRequest pageRequest = (PageRequest)pair.component1();
                Paged pagedEntities = (Paged)pair.component2();
                Paged expected2 = pagedEntities.map(new Function1<E, M>(cRUDServiceTest.getMapper()){

                    @NotNull
                    public final M invoke(@NotNull E p0) {
                        Intrinsics.checkNotNullParameter(p0, (String)"p0");
                        return (M)((CRUDMapper)this.receiver).entityToModel(p0);
                    }
                });
                Paged actual = cRUDServiceTest.getService().list((Pageable)pageRequest, ((CRUDTestData)cRUDServiceTest.getTestData()).getTestParameters());
                Assertions.assertEquals((Object)expected2, (Object)actual);
            }
        }

        @DisplayName(value="should return empty page when no entities exist")
        @Test
        public final void testListWithNoEntities() {
            ((CRUDTestData)CRUDServiceTest.this.getTestData()).getRepository().clear();
            Object s = CRUDServiceTest.this.getService();
            PageRequest pageRequest = PageRequest.of((int)0, (int)20);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(0, 20)");
            Paged actual = s.list((Pageable)pageRequest, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters());
            Paged expected2 = Paged.Companion.empty(0, 20, 0);
            Assertions.assertEquals((Object)expected2, (Object)actual);
        }

        /*
         * WARNING - void declaration
         */
        @DisplayName(value="should not return deleted entities")
        @Test
        public final void testListWithNoDeletedEntities() {
            void $this$testListWithNoDeletedEntities_u24lambda_u241;
            Object e = ((CRUDTestData)CRUDServiceTest.this.getTestData()).copy(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity3());
            Object object = CRUDServiceTest.this;
            Object object22 = e;
            InMemoryCRUDRepository inMemoryCRUDRepository = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getRepository();
            boolean bl = false;
            $this$testListWithNoDeletedEntities_u24lambda_u241.setDeletedAt(((CRUDTestData)((CRUDServiceTest)object).getTestData()).now());
            inMemoryCRUDRepository.update(e);
            object = new Pair[]{TuplesKt.to((Object)PageRequest.of((int)0, (int)1), (Object)new Paged(CollectionsKt.listOf((Object)CRUDServiceTest.this.getMapper().entityToModel(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1())), 0, 1, 2)), TuplesKt.to((Object)PageRequest.of((int)1, (int)1), (Object)new Paged(CollectionsKt.listOf((Object)CRUDServiceTest.this.getMapper().entityToModel(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity2())), 1, 1, 2))};
            List testCases = CollectionsKt.listOf((Object[])object);
            for (Object object22 : testCases) {
                PageRequest pageable = (PageRequest)object22.component1();
                Paged expected2 = (Paged)object22.component2();
                Paged actual = CRUDServiceTest.this.getService().list((Pageable)pageable, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters());
                Assertions.assertEquals((Object)expected2, (Object)actual);
            }
        }
    }

    @DisplayName(value="updating an entity")
    @Nested
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Ldev/akif/crud/CRUDServiceTest$Updating;", "", "(Ldev/akif/crud/CRUDServiceTest;)V", "testUpdate", "", "testUpdateAlreadyExists", "testUpdateDeleted", "testUpdateNotFound", "test"})
    @SourceDebugExtension(value={"SMAP\nCRUDServiceTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CRUDServiceTest.kt\ndev/akif/crud/CRUDServiceTest$Updating\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1#2:334\n*E\n"})
    public final class Updating {
        @DisplayName(value="should fail with not found error when trying to update an entity that doesn't exist")
        @Test
        public final void testUpdateNotFound() {
            Object id = ((CRUDTestData)CRUDServiceTest.this.getTestData()).randomId();
            Object updateModel = ((CRUDTestData)CRUDServiceTest.this.getTestData()).entityToUpdateModelWithModifications(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            CRUDErrorException exception = (CRUDErrorException)Assertions.assertThrows(CRUDErrorException.class, () -> Updating.testUpdateNotFound$lambda$0(CRUDServiceTest.this, id, updateModel));
            CRUDError actual = exception.getError();
            CRUDError expected2 = new CRUDError(HttpStatus.NOT_FOUND, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTypeName() + " with id " + id + " is not found.");
            Assertions.assertEquals((Object)expected2, (Object)actual);
        }

        @DisplayName(value="should fail with already exists error when trying to update an entity as duplicate of another entity")
        @Test
        public final void testUpdateAlreadyExists() {
            Map map = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getRepository().getEntities();
            Serializable serializable = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity2().getId();
            Intrinsics.checkNotNull((Object)serializable);
            Serializable serializable2 = serializable;
            Object e = ((CRUDTestData)CRUDServiceTest.this.getTestData()).copy(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            CRUDServiceTest cRUDServiceTest = CRUDServiceTest.this;
            Object $this$testUpdateAlreadyExists_u24lambda_u241 = e;
            boolean bl = false;
            $this$testUpdateAlreadyExists_u24lambda_u241.setId(((CRUDTestData)cRUDServiceTest.getTestData()).getTestEntity2().getId());
            map.put(serializable2, e);
            Object updateModel = ((CRUDTestData)CRUDServiceTest.this.getTestData()).entityToUpdateModelWithNoModifications(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            CRUDErrorException exception = (CRUDErrorException)Assertions.assertThrows(CRUDErrorException.class, () -> Updating.testUpdateAlreadyExists$lambda$2(CRUDServiceTest.this, updateModel));
            CRUDError actual = exception.getError();
            CRUDError expected2 = new CRUDError(HttpStatus.CONFLICT, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTypeName() + " with " + updateModel + " already exists.");
            Assertions.assertEquals((Object)expected2, (Object)actual);
        }

        /*
         * WARNING - void declaration
         */
        @DisplayName(value="should update return updated entity")
        @Test
        public final void testUpdate() {
            void $this$testUpdate_u24lambda_u243;
            Object updateModel = ((CRUDTestData)CRUDServiceTest.this.getTestData()).entityToUpdateModelWithModifications(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            Instant oneSecondLater = ((CRUDTestData)CRUDServiceTest.this.getTestData()).now().plusSeconds(1L);
            ((CRUDTestData)CRUDServiceTest.this.getTestData()).getInstantProvider().adjust((Function1<? super Instant, Instant>)((Function1)testUpdate.1.INSTANCE));
            Object s = CRUDServiceTest.this.getService();
            Serializable serializable = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1().getId();
            Intrinsics.checkNotNull((Object)serializable);
            CRUDModel actual = s.update(serializable, updateModel, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters());
            Object e = ((CRUDTestData)CRUDServiceTest.this.getTestData()).copy(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            CRUDServiceTest cRUDServiceTest = CRUDServiceTest.this;
            Object e2 = e;
            Object Mapper = CRUDServiceTest.this.getMapper();
            boolean bl = false;
            cRUDServiceTest.getMapper().updateEntityWith((CRUDEntity)$this$testUpdate_u24lambda_u243, updateModel);
            Integer n = $this$testUpdate_u24lambda_u243.getVersion();
            $this$testUpdate_u24lambda_u243.setVersion(n != null ? Integer.valueOf(n + 1) : null);
            $this$testUpdate_u24lambda_u243.setUpdatedAt(oneSecondLater);
            CRUDModel expected2 = Mapper.entityToModel(e);
            Assertions.assertEquals((Object)expected2, (Object)actual);
            CRUDModel found = CRUDServiceTest.this.getService().get(actual.id(), ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters());
            Assertions.assertEquals((Object)expected2, (Object)found);
        }

        /*
         * WARNING - void declaration
         */
        @DisplayName(value="should update with the same data of a deleted entity return updated entity")
        @Test
        public final void testUpdateDeleted() {
            void $this$testUpdateDeleted_u24lambda_u245;
            void $this$testUpdateDeleted_u24lambda_u244;
            Object e = ((CRUDTestData)CRUDServiceTest.this.getTestData()).copy(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity2());
            CRUDServiceTest cRUDServiceTest = CRUDServiceTest.this;
            Object e2 = e;
            InMemoryCRUDRepository inMemoryCRUDRepository = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getRepository();
            boolean bl = false;
            $this$testUpdateDeleted_u24lambda_u244.setDeletedAt(((CRUDTestData)cRUDServiceTest.getTestData()).now());
            inMemoryCRUDRepository.update(e);
            Object updateModel = ((CRUDTestData)CRUDServiceTest.this.getTestData()).entityToUpdateModelWithNoModifications(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity2());
            Instant oneSecondLater = ((CRUDTestData)CRUDServiceTest.this.getTestData()).now().plusSeconds(1L);
            ((CRUDTestData)CRUDServiceTest.this.getTestData()).getInstantProvider().adjust((Function1<? super Instant, Instant>)((Function1)testUpdateDeleted.2.INSTANCE));
            Object s = CRUDServiceTest.this.getService();
            Serializable serializable = ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1().getId();
            Intrinsics.checkNotNull((Object)serializable);
            CRUDModel actual = s.update(serializable, updateModel, ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters());
            Object e3 = ((CRUDTestData)CRUDServiceTest.this.getTestData()).copy(((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestEntity1());
            CRUDServiceTest cRUDServiceTest2 = CRUDServiceTest.this;
            Object e4 = e3;
            inMemoryCRUDRepository = CRUDServiceTest.this.getMapper();
            boolean bl2 = false;
            cRUDServiceTest2.getMapper().updateEntityWith((CRUDEntity)$this$testUpdateDeleted_u24lambda_u245, updateModel);
            Integer n = $this$testUpdateDeleted_u24lambda_u245.getVersion();
            $this$testUpdateDeleted_u24lambda_u245.setVersion(n != null ? Integer.valueOf(n + 1) : null);
            $this$testUpdateDeleted_u24lambda_u245.setUpdatedAt(oneSecondLater);
            CRUDModel expected2 = inMemoryCRUDRepository.entityToModel((CRUDEntity)e3);
            Assertions.assertEquals((Object)expected2, (Object)actual);
            CRUDModel found = CRUDServiceTest.this.getService().get(actual.id(), ((CRUDTestData)CRUDServiceTest.this.getTestData()).getTestParameters());
            Assertions.assertEquals((Object)expected2, (Object)found);
        }

        private static final void testUpdateNotFound$lambda$0(CRUDServiceTest this$0, Serializable $id, CRUDUpdateModel $updateModel) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
            Intrinsics.checkNotNullParameter((Object)$updateModel, (String)"$updateModel");
            this$0.getService().update($id, $updateModel, ((CRUDTestData)this$0.getTestData()).getTestParameters());
        }

        private static final void testUpdateAlreadyExists$lambda$2(CRUDServiceTest this$0, CRUDUpdateModel $updateModel) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$updateModel, (String)"$updateModel");
            Object s = this$0.getService();
            Serializable serializable = ((CRUDTestData)this$0.getTestData()).getTestEntity2().getId();
            Intrinsics.checkNotNull((Object)serializable);
            s.update(serializable, $updateModel, ((CRUDTestData)this$0.getTestData()).getTestParameters());
        }
    }
}

