/*
 * Decompiled with CFR 0.152.
 */
package dev.akif.crud;

import dev.akif.crud.CRUDCreateModel;
import dev.akif.crud.CRUDEntity;
import dev.akif.crud.CRUDRepository;
import dev.akif.crud.CRUDTestData;
import dev.akif.crud.InMemoryCRUDRepository;
import dev.akif.crud.error.CRUDErrorException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*(\b\u0003\u0010\u0007*\"\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00070\b2\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\tB\r\u0012\u0006\u0010\n\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0017\u0010\u001f\u001a\u0004\u0018\u00018\u00012\u0006\u0010 \u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u001aH\u0016J\u001d\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00028\u00012\u0006\u0010%\u001a\u00020&H\u0002\u00a2\u0006\u0002\u0010'J\u0006\u0010(\u001a\u00020\u001aJ\u0015\u0010)\u001a\u00028\u00012\u0006\u0010$\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010*J\u0015\u0010+\u001a\u00020,2\u0006\u0010$\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010-R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\n\u001a\u00028\u0003X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006."}, d2={"Ldev/akif/crud/InMemoryCRUDRepository;", "I", "Ljava/io/Serializable;", "E", "Ldev/akif/crud/CRUDEntity;", "CM", "Ldev/akif/crud/CRUDCreateModel;", "TestData", "Ldev/akif/crud/CRUDTestData;", "Ldev/akif/crud/CRUDRepository;", "testData", "(Ldev/akif/crud/CRUDTestData;)V", "entities", "", "getEntities", "()Ljava/util/Map;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "getTestData", "()Ldev/akif/crud/CRUDTestData;", "Ldev/akif/crud/CRUDTestData;", "clear", "", "findAllByDeletedAtIsNull", "Lorg/springframework/data/domain/Page;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findByIdAndDeletedAtIsNull", "id", "(Ljava/io/Serializable;)Ldev/akif/crud/CRUDEntity;", "flush", "handleDuplicates", "entity", "data", "", "(Ldev/akif/crud/CRUDEntity;Ljava/lang/Object;)V", "reset", "save", "(Ldev/akif/crud/CRUDEntity;)Ldev/akif/crud/CRUDEntity;", "update", "", "(Ldev/akif/crud/CRUDEntity;)I", "test"})
@SourceDebugExtension(value={"SMAP\nInMemoryCRUDRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryCRUDRepository.kt\ndev/akif/crud/InMemoryCRUDRepository\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n204#2,4:115\n1#3:119\n13579#4,2:120\n1747#5,3:122\n*S KotlinDebug\n*F\n+ 1 InMemoryCRUDRepository.kt\ndev/akif/crud/InMemoryCRUDRepository\n*L\n52#1:115,4\n97#1:120,2\n104#1:122,3\n*E\n"})
public class InMemoryCRUDRepository<I extends Serializable, E extends CRUDEntity<I>, CM extends CRUDCreateModel, TestData extends CRUDTestData<I, E, ?, CM, ?, TestData>>
implements CRUDRepository<I, E> {
    @NotNull
    private final TestData testData;
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private final Map<I, E> entities;

    public InMemoryCRUDRepository(@NotNull TestData testData) {
        Intrinsics.checkNotNullParameter(testData, (String)"testData");
        this.testData = testData;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ InMemoryCRUDRepository<I, E, CM, TestData> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        this.entities = new LinkedHashMap();
        this.reset();
    }

    @NotNull
    protected final TestData getTestData() {
        return this.testData;
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-log>(...)");
        return (Logger)object;
    }

    @NotNull
    public final Map<I, E> getEntities() {
        return this.entities;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<E> findAllByDeletedAtIsNull(@NotNull Pageable pageable) {
        int n;
        void $this$count$iv;
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Map<I, E> map = this.entities;
        Pageable pageable2 = pageable;
        List<CRUDEntity> list = this.entities.values().stream().filter(arg_0 -> InMemoryCRUDRepository.findAllByDeletedAtIsNull$lambda$0(findAllByDeletedAtIsNull.1.INSTANCE, arg_0)).skip(pageable.getOffset()).limit(pageable.getPageSize()).map(arg_0 -> InMemoryCRUDRepository.findAllByDeletedAtIsNull$lambda$1((Function1)new Function1<E, E>(this.testData){

            @NotNull
            public final E invoke(@NotNull E p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((CRUDTestData)this.receiver).copy(p0);
            }
        }, arg_0)).toList();
        boolean $i$f$count = false;
        if ($this$count$iv.isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            Iterator iterator = $this$count$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                CRUDEntity e = (CRUDEntity)entry.getValue();
                if (!(e.getDeletedAt() == null)) continue;
                ++count$iv;
            }
            n = count$iv;
        }
        int n2 = n;
        long l = n2;
        Pageable pageable3 = pageable2;
        List<CRUDEntity> list2 = list;
        return (Page)new PageImpl(list2, pageable3, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public E findByIdAndDeletedAtIsNull(@NotNull I id) {
        CRUDEntity cRUDEntity;
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Object object = (CRUDEntity)this.entities.get(id);
        if (object != null) {
            CRUDEntity cRUDEntity2;
            CRUDEntity it = cRUDEntity2 = object;
            boolean bl = false;
            object = it.getDeletedAt() == null ? cRUDEntity2 : null;
            if (object != null) {
                cRUDEntity2 = object;
                TestData TestData = this.testData;
                CRUDEntity p0 = cRUDEntity2;
                boolean bl2 = false;
                cRUDEntity = ((CRUDTestData)TestData).copy((CRUDEntity)p0);
                return (E)cRUDEntity;
            }
        }
        cRUDEntity = null;
        return (E)cRUDEntity;
    }

    @NotNull
    public E save(@NotNull E entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        this.handleDuplicates(entity, ((CRUDTestData)this.testData).entityToCreateModel(entity));
        if (entity.getId() == null) {
            entity.setId(((CRUDTestData)this.testData).getIdGenerator().next());
        }
        E copied = ((CRUDTestData)this.testData).copy(entity);
        Serializable serializable = entity.getId();
        Intrinsics.checkNotNull((Object)serializable);
        this.entities.put(serializable, copied);
        return copied;
    }

    /*
     * Unable to fully structure code
     */
    public int update(@NotNull E entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        this.handleDuplicates(entity, this.testData.entityToUpdateModelWithNoModifications(entity));
        v0 = entity.getId();
        if (v0 == null) ** GOTO lbl-1000
        it = v0;
        $i$a$-let-InMemoryCRUDRepository$update$existing$1 = false;
        v1 = (CRUDEntity)this.entities.get(it);
        v0 = v1;
        if (v1 != null) {
            it = var5_7 = v0;
            $i$a$-takeIf-InMemoryCRUDRepository$update$existing$2 = false;
            v2 = Intrinsics.areEqual((Object)it.getVersion(), (Object)entity.getVersion()) ? var5_7 : null;
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        existing = v2;
        $this$update_u24lambda_u246 = var4_9 = this.testData.copy(entity);
        $i$a$-apply-InMemoryCRUDRepository$update$copied$1 = false;
        v3 = $this$update_u24lambda_u246.getVersion();
        $this$update_u24lambda_u246.setVersion(v3 != null ? Integer.valueOf(v3 + 1) : null);
        copied = var4_9;
        if (existing == null) ** GOTO lbl-1000
        it = existing;
        $i$a$-let-InMemoryCRUDRepository$update$1 = false;
        v4 = entity.getId();
        if (v4 != null) {
            id = v4;
            $i$a$-let-InMemoryCRUDRepository$update$1$1 = false;
            v5 = (CRUDEntity)this.entities.replace(id, copied);
        } else {
            v5 = null;
        }
        if ((var4_9 = v5) != null) {
            it = var4_9;
            $i$a$-let-InMemoryCRUDRepository$update$2 = false;
            v6 = 1;
        } else lbl-1000:
        // 2 sources

        {
            v6 = 0;
        }
        return v6;
    }

    public void flush() {
        this.getLog().debug("Flushed repository: " + this.entities);
    }

    public final void clear() {
        this.entities.clear();
    }

    public final void reset() {
        this.entities.clear();
        Serializable serializable = ((CRUDTestData)this.testData).getTestEntity1().getId();
        Intrinsics.checkNotNull((Object)serializable);
        this.entities.put(serializable, ((CRUDTestData)this.testData).getTestEntity1());
        Serializable serializable2 = ((CRUDTestData)this.testData).getTestEntity2().getId();
        Intrinsics.checkNotNull((Object)serializable2);
        this.entities.put(serializable2, ((CRUDTestData)this.testData).getTestEntity2());
        Serializable serializable3 = ((CRUDTestData)this.testData).getTestEntity3().getId();
        Intrinsics.checkNotNull((Object)serializable3);
        this.entities.put(serializable3, ((CRUDTestData)this.testData).getTestEntity3());
        CRUDEntity[] $this$forEach$iv = this.testData.getMoreTestEntities();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            CRUDEntity element$iv;
            CRUDEntity testEntity = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Serializable serializable4 = testEntity.getId();
            Intrinsics.checkNotNull((Object)serializable4);
            this.entities.put(serializable4, testEntity);
        }
        this.getLog().debug("Reset repository: " + this.entities);
    }

    private final void handleDuplicates(E entity, Object data) {
        boolean found;
        block4: {
            Iterable $this$any$iv = this.entities.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CRUDEntity e = (CRUDEntity)element$iv;
                    boolean bl = false;
                    boolean bl2 = entity.getDeletedAt() == null && e.getDeletedAt() == null && ((CRUDTestData)this.testData).areDuplicates(entity, (CRUDEntity)e);
                    if (!bl2) continue;
                    v0 = true;
                    break block4;
                }
                v0 = found = false;
            }
        }
        if (found) {
            throw CRUDErrorException.Companion.alreadyExists(((CRUDTestData)this.testData).getTypeName(), data);
        }
    }

    private static final boolean findAllByDeletedAtIsNull$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CRUDEntity findAllByDeletedAtIsNull$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CRUDEntity)$tmp0.invoke(p0);
    }
}

