/*
 * Decompiled with CFR 0.152.
 */
package dev.akkinoc.spring.boot.logback.access;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import dev.akkinoc.spring.boot.logback.access.LogbackAccessEventSource;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0016J\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010 J\u001a\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001f0\u001bH\u0016J\b\u0010\"\u001a\u00020\u0007H\u0016J\b\u0010#\u001a\u00020\u0007H\u0016J\n\u0010$\u001a\u0004\u0018\u00010%H\u0016J\b\u0010&\u001a\u00020\u0007H\u0016J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0014\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001bH\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070*H\u0016J\n\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u0010-\u001a\u00020\u0007H\u0016J\b\u0010.\u001a\u00020\u0007H\u0016J\b\u0010/\u001a\u00020\u000fH\u0016J\b\u00100\u001a\u00020\u0007H\u0016J\b\u00101\u001a\u00020\nH\u0016J\b\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002032\u0006\u00105\u001a\u00020\u0007H\u0016J\b\u00106\u001a\u00020\u0007H\u0016J\u0010\u00107\u001a\u0002032\u0006\u00108\u001a\u000209H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Ldev/akkinoc/spring/boot/logback/access/LogbackAccessEvent;", "Lch/qos/logback/access/spi/IAccessEvent;", "Ljava/io/Serializable;", "source", "Ldev/akkinoc/spring/boot/logback/access/LogbackAccessEventSource;", "(Ldev/akkinoc/spring/boot/logback/access/LogbackAccessEventSource;)V", "getAttribute", "", "key", "getContentLength", "", "getCookie", "getElapsedSeconds", "getElapsedTime", "getLocalPort", "", "getMethod", "getProtocol", "getQueryString", "getRemoteAddr", "getRemoteHost", "getRemoteUser", "getRequest", "Ljavax/servlet/http/HttpServletRequest;", "getRequestContent", "getRequestHeader", "getRequestHeaderMap", "", "getRequestHeaderNames", "Ljava/util/Enumeration;", "getRequestParameter", "", "(Ljava/lang/String;)[Ljava/lang/String;", "getRequestParameterMap", "getRequestURI", "getRequestURL", "getResponse", "Ljavax/servlet/http/HttpServletResponse;", "getResponseContent", "getResponseHeader", "getResponseHeaderMap", "getResponseHeaderNameList", "", "getServerAdapter", "Lch/qos/logback/access/spi/ServerAdapter;", "getServerName", "getSessionID", "getStatusCode", "getThreadName", "getTimeStamp", "prepareForDeferredProcessing", "", "setThreadName", "value", "toString", "writeObject", "out", "Ljava/io/ObjectOutputStream;", "logback-access-spring-boot-starter"})
public final class LogbackAccessEvent
implements IAccessEvent,
Serializable {
    @NotNull
    private LogbackAccessEventSource source;

    public LogbackAccessEvent(@NotNull LogbackAccessEventSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
    }

    @Nullable
    public HttpServletRequest getRequest() {
        return this.source.getRequest();
    }

    @Nullable
    public HttpServletResponse getResponse() {
        return this.source.getResponse();
    }

    @Nullable
    public ServerAdapter getServerAdapter() {
        return this.source.getServerAdapter();
    }

    public long getTimeStamp() {
        return this.source.getTimeStamp();
    }

    public long getElapsedTime() {
        Long l = this.source.getElapsedTime();
        return l == null ? -1L : l;
    }

    public long getElapsedSeconds() {
        Long l = this.source.getElapsedTime();
        if (l == null) {
            return -1L;
        }
        long millis = l;
        return TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    @NotNull
    public String getThreadName() {
        return this.source.getThreadName();
    }

    public void setThreadName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Cannot change: ", (Object)this));
    }

    @NotNull
    public String getServerName() {
        return this.source.getServerName();
    }

    public int getLocalPort() {
        return this.source.getLocalPort();
    }

    @NotNull
    public String getRemoteAddr() {
        return this.source.getRemoteAddr();
    }

    @NotNull
    public String getRemoteHost() {
        return this.source.getRemoteHost();
    }

    @NotNull
    public String getRemoteUser() {
        String string = this.source.getRemoteUser();
        return string == null ? "-" : string;
    }

    @NotNull
    public String getProtocol() {
        return this.source.getProtocol();
    }

    @NotNull
    public String getMethod() {
        return this.source.getMethod();
    }

    @NotNull
    public String getRequestURI() {
        return this.source.getRequestURI();
    }

    @NotNull
    public String getQueryString() {
        return this.source.getQueryString();
    }

    @NotNull
    public String getRequestURL() {
        return this.source.getRequestURL();
    }

    @NotNull
    public Map<String, String> getRequestHeaderMap() {
        return this.source.getRequestHeaderMap();
    }

    @NotNull
    public Enumeration<String> getRequestHeaderNames() {
        Enumeration<String> enumeration = Collections.enumeration((Collection)this.source.getRequestHeaderMap().keySet());
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"enumeration(source.requestHeaderMap.keys)");
        return enumeration;
    }

    @NotNull
    public String getRequestHeader(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.source.getRequestHeaderMap().get(key);
        return string == null ? "-" : string;
    }

    @NotNull
    public String getCookie(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.source.getCookieMap().get(key);
        return string == null ? "-" : string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, String[]> getRequestParameterMap() {
        void $this$mapValuesTo$iv$iv;
        Map<String, List<String>> $this$mapValues$iv = this.source.getRequestParameterMap();
        boolean $i$f$mapValues = false;
        Map<String, List<String>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            String[] stringArray;
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            Collection $this$toTypedArray$iv = (Collection)it.getValue();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            map3.put(k2, stringArray);
        }
        return destination$iv$iv;
    }

    @NotNull
    public String[] getRequestParameter(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List<String> list = this.source.getRequestParameterMap().get(key);
        if (list == null) {
            String[] stringArray = new String[]{"-"};
            return stringArray;
        }
        List<String> values = list;
        Collection $this$toTypedArray$iv = values;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    @NotNull
    public String getAttribute(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.source.getAttributeMap().get(key);
        return string == null ? "-" : string;
    }

    @NotNull
    public String getSessionID() {
        String string = this.source.getSessionID();
        return string == null ? "-" : string;
    }

    @NotNull
    public String getRequestContent() {
        String string = this.source.getRequestContent();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public int getStatusCode() {
        return this.source.getStatusCode();
    }

    @NotNull
    public Map<String, String> getResponseHeaderMap() {
        return this.source.getResponseHeaderMap();
    }

    @NotNull
    public List<String> getResponseHeaderNameList() {
        return CollectionsKt.toList((Iterable)this.source.getResponseHeaderMap().keySet());
    }

    @NotNull
    public String getResponseHeader(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.source.getResponseHeaderMap().get(key);
        return string == null ? "-" : string;
    }

    public long getContentLength() {
        return this.source.getContentLength();
    }

    @NotNull
    public String getResponseContent() {
        String string = this.source.getResponseContent();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public void prepareForDeferredProcessing() {
        this.source = this.source.fix();
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + '(' + this.getRequestURL() + ' ' + this.getStatusCode() + ')';
    }

    private final void writeObject(ObjectOutputStream out) throws IOException {
        this.prepareForDeferredProcessing();
        out.defaultWriteObject();
    }
}

