/*
 * Decompiled with CFR 0.152.
 */
package dev.alt236.easycursor.internal.conversion;

import dev.alt236.easycursor.exceptions.ConversionErrorException;
import dev.alt236.easycursor.internal.conversion.ObjectType;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class ObjectConverter {
    private static final int INT_BYTE_SIZE = 4;
    private static final int LONG_BYTE_SIZE = 8;
    private static final int FLOAT_BYTE_SIZE = 4;
    private static final int DOUBLE_BYTE_SIZE = 8;
    private static final int SHORT_BYTE_SIZE = 2;
    private static final String UTF_8 = "UTF-8";
    private final String mEncoding;
    private final ByteOrder mByteOrder;

    public ObjectConverter() {
        this(UTF_8, ByteOrder.BIG_ENDIAN);
    }

    public ObjectConverter(String encoding, ByteOrder byteOrder) {
        this.mEncoding = encoding;
        this.mByteOrder = byteOrder;
    }

    private ByteBuffer getByteBuffer(int size) {
        return ByteBuffer.allocate(size).order(this.mByteOrder);
    }

    private byte[] getBytes(String string) {
        try {
            return string.getBytes(this.mEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConversionErrorException(e);
        }
    }

    private String getString(byte[] array) {
        try {
            return new String(array, this.mEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConversionErrorException(e);
        }
    }

    private boolean toBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.valueOf(String.valueOf(obj));
        }
        throw new ConversionErrorException("Unable to convert '" + ObjectConverter.getClassName(obj) + "' to boolean");
    }

    private byte[] toByteArray(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            return this.getBytes((String)obj);
        }
        if (obj instanceof Integer) {
            return this.getByteBuffer(4).putInt((Integer)obj).array();
        }
        if (obj instanceof Long) {
            return this.getByteBuffer(8).putLong((Long)obj).array();
        }
        if (obj instanceof Float) {
            return this.getByteBuffer(4).putFloat(((Float)obj).floatValue()).array();
        }
        if (obj instanceof Double) {
            return this.getByteBuffer(8).putDouble((Double)obj).array();
        }
        if (obj instanceof Short) {
            return this.getByteBuffer(2).putShort((Short)obj).array();
        }
        throw new ConversionErrorException("Unable to convert '" + ObjectConverter.getClassName(obj) + "' to byte[]");
    }

    private double toDouble(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof String) {
            try {
                return Double.valueOf(String.valueOf(obj));
            }
            catch (NumberFormatException e) {
                throw new ConversionErrorException(e);
            }
        }
        if (obj instanceof byte[] && ((byte[])obj).length == 8) {
            ByteBuffer buffer = this.getByteBuffer(8).put((byte[])obj);
            buffer.flip();
            return buffer.getDouble();
        }
        throw new ConversionErrorException("Unable to convert '" + ObjectConverter.getClassName(obj) + "' to double");
    }

    private float toFloat(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        if (obj instanceof String) {
            try {
                return Float.valueOf(String.valueOf(obj)).floatValue();
            }
            catch (NumberFormatException e) {
                throw new ConversionErrorException(e);
            }
        }
        if (obj instanceof byte[] && ((byte[])obj).length == 4) {
            ByteBuffer buffer = this.getByteBuffer(4).put((byte[])obj);
            buffer.flip();
            return buffer.getFloat();
        }
        throw new ConversionErrorException("Unable to convert '" + ObjectConverter.getClassName(obj) + "' to float");
    }

    private int toInt(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                return Integer.valueOf(String.valueOf(obj));
            }
            catch (NumberFormatException e) {
                throw new ConversionErrorException(e);
            }
        }
        if (obj instanceof byte[] && ((byte[])obj).length == 4) {
            ByteBuffer buffer = this.getByteBuffer(4).put((byte[])obj);
            buffer.flip();
            return buffer.getInt();
        }
        throw new ConversionErrorException("Unable to convert '" + ObjectConverter.getClassName(obj) + "' to int");
    }

    private long toLong(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            try {
                return Long.valueOf(String.valueOf(obj));
            }
            catch (NumberFormatException e) {
                throw new ConversionErrorException(e);
            }
        }
        if (obj instanceof byte[] && ((byte[])obj).length == 8) {
            ByteBuffer buffer = this.getByteBuffer(8).put((byte[])obj);
            buffer.flip();
            return buffer.getLong();
        }
        throw new ConversionErrorException("Unable to convert '" + ObjectConverter.getClassName(obj) + "' to long");
    }

    private short toShort(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        if (obj instanceof String) {
            try {
                return Short.valueOf(String.valueOf(obj));
            }
            catch (NumberFormatException e) {
                throw new ConversionErrorException(e);
            }
        }
        if (obj instanceof byte[] && ((byte[])obj).length == 2) {
            ByteBuffer buffer = this.getByteBuffer(2).put((byte[])obj);
            buffer.flip();
            return buffer.getShort();
        }
        throw new ConversionErrorException("Unable to convert '" + ObjectConverter.getClassName(obj) + "' to short");
    }

    private String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return this.getString((byte[])obj);
        }
        return String.valueOf(obj);
    }

    public Object toType(ObjectType type, Object candidate) {
        switch (type) {
            case BOOLEAN: {
                return this.toBoolean(candidate);
            }
            case BYTE_ARRAY: {
                return this.toByteArray(candidate);
            }
            case DOUBLE: {
                return this.toDouble(candidate);
            }
            case FLOAT: {
                return Float.valueOf(this.toFloat(candidate));
            }
            case INTEGER: {
                return this.toInt(candidate);
            }
            case LONG: {
                return this.toLong(candidate);
            }
            case SHORT: {
                return this.toShort(candidate);
            }
            case STRING: {
                return this.toString(candidate);
            }
        }
        throw new IllegalStateException("Unknown ObjectType: " + (Object)((Object)type));
    }

    private static String getClassName(Object obj) {
        if (obj == null) {
            return "<null>";
        }
        return obj.getClass().getName();
    }
}

