/*
 * Decompiled with CFR 0.152.
 */
package dev.alt236.easycursor.jsoncursor;

import android.database.AbstractCursor;
import dev.alt236.easycursor.EasyCursor;
import dev.alt236.easycursor.EasyQueryModel;
import dev.alt236.easycursor.exceptions.ConversionErrorException;
import dev.alt236.easycursor.internal.FieldAccessor;
import dev.alt236.easycursor.internal.conversion.ObjectConverter;
import dev.alt236.easycursor.internal.conversion.ObjectType;
import dev.alt236.easycursor.jsoncursor.JsonFieldAccessor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EasyJsonCursor
extends AbstractCursor
implements EasyCursor {
    public static final String DEFAULT_STRING = null;
    public static final boolean DEFAULT_BOOLEAN = false;
    public static final double DEFAULT_DOUBLE = 0.0;
    public static final float DEFAULT_FLOAT = 0.0f;
    public static final int DEFAULT_INT = 0;
    public static final long DEFAULT_LONG = 0L;
    public static final short DEFAULT_SHORT = 0;
    private static final String _ID = "_id";
    private final ObjectConverter mObjectConverter = new ObjectConverter();
    private final EasyQueryModel mQueryModel;
    private final JSONArray mJsonArray;
    private final String m_IdAlias;
    private final FieldAccessor mFieldAccessor;

    public EasyJsonCursor(JSONArray array, String _idAlias) {
        this(array, _idAlias, null);
    }

    public EasyJsonCursor(JSONArray array, String _idAlias, EasyQueryModel model) {
        this.mFieldAccessor = new JsonFieldAccessor(array);
        this.m_IdAlias = _idAlias;
        this.mQueryModel = model;
        this.mJsonArray = array;
    }

    private String applyAlias(String columnName) {
        if (_ID.equals(columnName) && this.m_IdAlias != null) {
            return this.m_IdAlias;
        }
        return columnName;
    }

    @Override
    public byte[] getBlob(String name) {
        throw new UnsupportedOperationException("getBlob is not supported");
    }

    @Override
    public boolean getBoolean(String name) {
        return this.internalGet(ObjectType.BOOLEAN, name, false);
    }

    public int getColumnIndex(String name) {
        String column = this.applyAlias(name);
        return this.mFieldAccessor.getFieldIndexByName(column);
    }

    public int getColumnIndexOrThrow(String name) {
        String column = this.applyAlias(name);
        int index = this.mFieldAccessor.getFieldIndexByName(column);
        if (index == -1) {
            throw new IllegalArgumentException("There is no column named '" + column + "'");
        }
        return index;
    }

    public String getColumnName(int columnIndex) {
        return this.mFieldAccessor.getFieldNameByIndex(columnIndex);
    }

    public String[] getColumnNames() {
        return this.mFieldAccessor.getFieldNames();
    }

    public int getCount() {
        return this.mJsonArray.length();
    }

    public JSONObject getCurrentJsonObject() {
        return this.mJsonArray.optJSONObject(this.getPosition());
    }

    public double getDouble(int column) {
        return this.getDouble(this.mFieldAccessor.getFieldNameByIndex(column));
    }

    @Override
    public double getDouble(String name) {
        return this.internalGet(ObjectType.DOUBLE, name, 0.0);
    }

    public float getFloat(int column) {
        return this.getFloat(this.mFieldAccessor.getFieldNameByIndex(column));
    }

    @Override
    public float getFloat(String name) {
        return this.internalGet(ObjectType.FLOAT, name, Float.valueOf(0.0f)).floatValue();
    }

    public int getInt(int column) {
        return this.getInt(this.mFieldAccessor.getFieldNameByIndex(column));
    }

    @Override
    public int getInt(String name) {
        return this.internalGet(ObjectType.INTEGER, name, 0);
    }

    public JSONArray getJSONArray(int column) {
        return this.getJSONArray(this.mFieldAccessor.getFieldNameByIndex(column));
    }

    public JSONArray getJSONArray(String name) {
        try {
            return this.getCurrentJsonObject().getJSONArray(this.applyAlias(name));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Field '" + this.applyAlias(name) + "' does not exist");
        }
    }

    public JSONObject getJSONObject(int column) {
        return this.getJSONObject(this.mFieldAccessor.getFieldNameByIndex(column));
    }

    public JSONObject getJSONObject(String name) {
        try {
            return this.getCurrentJsonObject().getJSONObject(this.applyAlias(name));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Field '" + this.applyAlias(name) + "' does not exist");
        }
    }

    public long getLong(int column) {
        return this.getLong(this.mFieldAccessor.getFieldNameByIndex(column));
    }

    @Override
    public long getLong(String name) {
        return this.internalGet(ObjectType.LONG, name, 0L);
    }

    @Override
    public EasyQueryModel getQueryModel() {
        return this.mQueryModel;
    }

    public short getShort(int column) {
        return this.getShort(this.mFieldAccessor.getFieldNameByIndex(column));
    }

    @Override
    public short getShort(String name) {
        return this.internalGet(ObjectType.SHORT, name, (short)0);
    }

    public String getString(int column) {
        return this.getString(this.mFieldAccessor.getFieldNameByIndex(column));
    }

    @Override
    public String getString(String name) {
        return this.internalGet(ObjectType.STRING, name, DEFAULT_STRING);
    }

    public String get_IdAlias() {
        return this.m_IdAlias;
    }

    private <R> R internalGet(ObjectType type, String name, R conversionErrorFallback) {
        String alias = this.applyAlias(name);
        if (!this.getCurrentJsonObject().has(alias)) {
            throw new IllegalArgumentException("Field '" + alias + "' does not exist");
        }
        try {
            if (this.getCurrentJsonObject().isNull(alias)) {
                return (R)this.mObjectConverter.toType(type, null);
            }
            Object value = this.getCurrentJsonObject().get(alias);
            return (R)this.mObjectConverter.toType(type, value);
        }
        catch (ConversionErrorException e) {
            return conversionErrorFallback;
        }
        catch (JSONException e) {
            return null;
        }
    }

    private <R> R internalOpt(ObjectType type, String fieldName, R fieldMissingFallback, R conversionErrorFallback) {
        String alias = this.applyAlias(fieldName);
        if (!this.getCurrentJsonObject().has(alias)) {
            return fieldMissingFallback;
        }
        try {
            if (this.getCurrentJsonObject().isNull(alias)) {
                return (R)this.mObjectConverter.toType(type, null);
            }
            Object value = this.getCurrentJsonObject().opt(alias);
            return (R)this.mObjectConverter.toType(type, value);
        }
        catch (ConversionErrorException e) {
            return conversionErrorFallback;
        }
    }

    public boolean isNull(int column) {
        return this.isNull(this.mFieldAccessor.getFieldNameByIndex(column));
    }

    @Override
    public boolean isNull(String name) {
        return this.getCurrentJsonObject().isNull(this.applyAlias(name));
    }

    @Override
    public boolean optBoolean(String name) {
        return this.internalOpt(ObjectType.BOOLEAN, name, false, false);
    }

    @Override
    public boolean optBoolean(String name, boolean fallback) {
        return this.internalOpt(ObjectType.BOOLEAN, name, fallback, false);
    }

    @Override
    public Boolean optBooleanAsWrapperType(String name) {
        return this.internalOpt(ObjectType.BOOLEAN, name, null, false);
    }

    @Override
    public double optDouble(String name) {
        return this.internalOpt(ObjectType.DOUBLE, name, 0.0, 0.0);
    }

    @Override
    public double optDouble(String name, double fallback) {
        return this.internalOpt(ObjectType.DOUBLE, name, fallback, 0.0);
    }

    @Override
    public Double optDoubleAsWrapperType(String name) {
        return this.internalOpt(ObjectType.DOUBLE, name, null, 0.0);
    }

    @Override
    public float optFloat(String name) {
        return this.internalOpt(ObjectType.FLOAT, name, Float.valueOf(0.0f), Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public float optFloat(String name, float fallback) {
        return this.internalOpt(ObjectType.FLOAT, name, Float.valueOf(fallback), Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Float optFloatAsWrapperType(String name) {
        return this.internalOpt(ObjectType.FLOAT, name, null, Float.valueOf(0.0f));
    }

    @Override
    public int optInt(String name) {
        return this.internalOpt(ObjectType.INTEGER, name, 0, 0);
    }

    @Override
    public int optInt(String name, int fallback) {
        return this.internalOpt(ObjectType.INTEGER, name, fallback, 0);
    }

    @Override
    public Integer optIntAsWrapperType(String name) {
        return this.internalOpt(ObjectType.INTEGER, name, null, 0);
    }

    public JSONArray optJSONArray(int column) {
        return this.optJSONArray(this.mFieldAccessor.getFieldNameByIndex(column));
    }

    public JSONArray optJSONArray(String name) {
        return this.getCurrentJsonObject().optJSONArray(this.applyAlias(name));
    }

    public JSONObject optJSONObject(int column) {
        return this.optJSONObject(this.mFieldAccessor.getFieldNameByIndex(column));
    }

    public JSONObject optJSONObject(String name) {
        return this.getCurrentJsonObject().optJSONObject(this.applyAlias(name));
    }

    @Override
    public long optLong(String name) {
        return this.internalOpt(ObjectType.LONG, name, 0L, 0L);
    }

    @Override
    public long optLong(String name, long fallback) {
        return this.internalOpt(ObjectType.LONG, name, fallback, 0L);
    }

    @Override
    public Long optLongAsWrapperType(String name) {
        return this.internalOpt(ObjectType.LONG, name, null, 0L);
    }

    @Override
    public short optShort(String name) {
        return this.internalOpt(ObjectType.SHORT, name, (short)0, (short)0);
    }

    @Override
    public short optShort(String name, short fallback) {
        return this.internalOpt(ObjectType.SHORT, name, fallback, (short)0);
    }

    @Override
    public Short optShortAsWrapperType(String name) {
        return this.internalOpt(ObjectType.SHORT, name, null, (short)0);
    }

    @Override
    public String optString(String name) {
        return this.internalOpt(ObjectType.STRING, name, DEFAULT_STRING, DEFAULT_STRING);
    }

    @Override
    public String optString(String name, String fallback) {
        return this.internalOpt(ObjectType.STRING, name, fallback, DEFAULT_STRING);
    }
}

