/*
 * Decompiled with CFR 0.152.
 */
package dev.alt236.easycursor.jsoncursor;

import dev.alt236.easycursor.internal.FieldAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

class JsonFieldAccessor
implements FieldAccessor {
    private final List<String> mPropertyList = new ArrayList<String>();
    private final Map<String, Integer> mPropertyToIndexMap = new HashMap<String, Integer>();

    public JsonFieldAccessor(JSONArray array) {
        this.populateMethodList(array);
    }

    @Override
    public int getFieldIndexByName(String name) {
        if (this.mPropertyToIndexMap.containsKey(name)) {
            return this.mPropertyToIndexMap.get(name);
        }
        return -1;
    }

    @Override
    public String getFieldNameByIndex(int index) {
        return this.mPropertyList.get(index);
    }

    @Override
    public String[] getFieldNames() {
        return this.mPropertyList.toArray(new String[this.mPropertyList.size()]);
    }

    private void populateMethodList(JSONArray array) {
        int count = 0;
        JSONObject obj = array.optJSONObject(0);
        Iterator keyIterator = obj.keys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            this.mPropertyList.add(key);
            this.mPropertyToIndexMap.put(key, count);
            ++count;
        }
    }
}

