/*
 * Decompiled with CFR 0.152.
 */
package dev.alt236.easycursor.objectcursor;

import android.database.AbstractCursor;
import android.util.Log;
import dev.alt236.easycursor.EasyCursor;
import dev.alt236.easycursor.EasyQueryModel;
import dev.alt236.easycursor.exceptions.ConversionErrorException;
import dev.alt236.easycursor.internal.conversion.ObjectConverter;
import dev.alt236.easycursor.internal.conversion.ObjectType;
import dev.alt236.easycursor.objectcursor.ObjectFieldAccessor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EasyObjectCursor<T>
extends AbstractCursor
implements EasyCursor {
    public static final String DEFAULT_STRING = null;
    public static final boolean DEFAULT_BOOLEAN = false;
    public static final double DEFAULT_DOUBLE = 0.0;
    public static final float DEFAULT_FLOAT = 0.0f;
    public static final int DEFAULT_INT = 0;
    public static final long DEFAULT_LONG = 0L;
    public static final short DEFAULT_SHORT = 0;
    private static final String _ID = "_id";
    private final ObjectConverter mObjectConverter;
    private final EasyQueryModel mQueryModel;
    private final List<T> mObjectList;
    private final String TAG = this.getClass().getName();
    private final String m_IdAlias;
    private final ObjectFieldAccessor<T> mFieldAccessor;
    private boolean mDebugEnabled;

    public EasyObjectCursor(Class<T> clazz, List<T> objectList, String _idAlias) {
        this(clazz, objectList, _idAlias, null);
    }

    public EasyObjectCursor(Class<T> clazz, List<T> objectList, String _idAlias, EasyQueryModel model) {
        this.mObjectConverter = new ObjectConverter();
        this.mQueryModel = model;
        this.mObjectList = objectList;
        this.m_IdAlias = _idAlias;
        this.mFieldAccessor = new ObjectFieldAccessor<T>(clazz);
    }

    public EasyObjectCursor(Class<T> clazz, T[] objectArray, String _idAlias) {
        this(clazz, new ArrayList<T>(Arrays.asList(objectArray)), _idAlias, null);
    }

    public EasyObjectCursor(Class<T> clazz, T[] objectArray, String _idAlias, EasyQueryModel model) {
        this(clazz, new ArrayList<T>(Arrays.asList(objectArray)), _idAlias, model);
    }

    private String applyAlias(String columnName) {
        if (_ID.equals(columnName) && this.m_IdAlias != null) {
            return this.m_IdAlias;
        }
        return columnName;
    }

    @Override
    public byte[] getBlob(String fieldName) {
        Method method = this.getGetterForFieldOrThrow(this.applyAlias(fieldName));
        Object result = this.internalGet(ObjectType.BYTE_ARRAY, method);
        if (result == null) {
            return null;
        }
        return (byte[])result;
    }

    @Override
    public boolean getBoolean(String fieldName) {
        Method method = this.getGetterForFieldOrThrow(this.applyAlias(fieldName));
        Object result = this.internalGet(ObjectType.BOOLEAN, method);
        if (result == null) {
            return false;
        }
        return (Boolean)result;
    }

    public int getColumnIndex(String columnName) {
        String column = this.applyAlias(columnName);
        return this.mFieldAccessor.getFieldIndexByName(column);
    }

    public int getColumnIndexOrThrow(String columnName) {
        String column = this.applyAlias(columnName);
        int index = this.mFieldAccessor.getFieldIndexByName(column);
        if (index == -1) {
            throw new IllegalArgumentException("There is no column named '" + column + "'");
        }
        return index;
    }

    public String getColumnName(int columnIndex) {
        return this.mFieldAccessor.getFieldNameByIndex(columnIndex);
    }

    public String[] getColumnNames() {
        return this.mFieldAccessor.getFieldNames();
    }

    public int getCount() {
        return this.mObjectList.size();
    }

    public double getDouble(int column) {
        return this.getDoubleIntenal(this.mFieldAccessor.getMethod(column));
    }

    @Override
    public double getDouble(String fieldName) {
        return this.getDoubleIntenal(this.getGetterForFieldOrThrow(this.applyAlias(fieldName)));
    }

    private double getDoubleIntenal(Method method) {
        Object result = this.internalGet(ObjectType.DOUBLE, method);
        if (result == null) {
            return 0.0;
        }
        return (Double)result;
    }

    public float getFloat(int column) {
        return this.getFloatInternal(this.mFieldAccessor.getMethod(column));
    }

    @Override
    public float getFloat(String fieldName) {
        return this.getFloatInternal(this.getGetterForFieldOrThrow(this.applyAlias(fieldName)));
    }

    private float getFloatInternal(Method method) {
        Object result = this.internalGet(ObjectType.FLOAT, method);
        if (result == null) {
            return 0.0f;
        }
        return ((Float)result).floatValue();
    }

    private Method getGetterForFieldOrThrow(String fieldName) {
        Method method = this.mFieldAccessor.getGetterForField(this.applyAlias(fieldName));
        if (method == null) {
            throw new IllegalArgumentException("Could not find getter for field '" + this.applyAlias(fieldName) + "'");
        }
        return method;
    }

    public int getInt(int column) {
        return this.getIntInternal(this.mFieldAccessor.getMethod(column));
    }

    @Override
    public int getInt(String fieldName) {
        return this.getIntInternal(this.getGetterForFieldOrThrow(this.applyAlias(fieldName)));
    }

    private int getIntInternal(Method method) {
        Object result = this.internalGet(ObjectType.INTEGER, method);
        if (result == null) {
            return 0;
        }
        return (Integer)result;
    }

    public T getItem(int position) {
        return this.mObjectList.get(position);
    }

    public long getLong(int column) {
        return this.getLongInternal(this.mFieldAccessor.getMethod(column));
    }

    @Override
    public long getLong(String fieldName) {
        return this.getLongInternal(this.getGetterForFieldOrThrow(this.applyAlias(fieldName)));
    }

    private long getLongInternal(Method method) {
        Object result = this.internalGet(ObjectType.LONG, method);
        if (result == null) {
            return 0L;
        }
        return (Long)result;
    }

    List<Method> getMethods() {
        return this.mFieldAccessor.getMethodList();
    }

    public Object getObject(int column) {
        return this.getObjectInternal(this.mFieldAccessor.getMethod(column));
    }

    public Object getObject(String fieldName) {
        return this.getObjectInternal(this.getGetterForFieldOrThrow(this.applyAlias(fieldName)));
    }

    private Object getObjectInternal(Method method) {
        return this.runGetter(method, this.getItem(this.getPosition()));
    }

    @Override
    public EasyQueryModel getQueryModel() {
        return this.mQueryModel;
    }

    public short getShort(int column) {
        return this.getShortInternal(this.mFieldAccessor.getMethod(column));
    }

    @Override
    public short getShort(String fieldName) {
        return this.getShortInternal(this.getGetterForFieldOrThrow(this.applyAlias(fieldName)));
    }

    private short getShortInternal(Method method) {
        Object result = this.internalGet(ObjectType.SHORT, method);
        if (result == null) {
            return 0;
        }
        return (Short)result;
    }

    public String getString(int column) {
        return this.getStringInternal(this.mFieldAccessor.getMethod(column));
    }

    @Override
    public String getString(String fieldName) {
        return this.getStringInternal(this.getGetterForFieldOrThrow(this.applyAlias(fieldName)));
    }

    private String getStringInternal(Method method) {
        return (String)this.internalGet(ObjectType.STRING, method);
    }

    private Object internalGet(ObjectType type, Method method) {
        try {
            return this.mObjectConverter.toType(type, this.runGetter(method, this.getItem(this.getPosition())));
        }
        catch (ConversionErrorException e) {
            return null;
        }
    }

    private <R> R internalOpt(ObjectType type, String fieldName, R getterMissingFallback, R conversionErrorFallback) {
        Method method = this.mFieldAccessor.getGetterForField(this.applyAlias(fieldName));
        if (method == null) {
            String message = String.format("No getter for '%s'. Type Requested: %s", new Object[]{fieldName, type});
            Log.w((String)this.TAG, (String)(message + (Object)((Object)type)));
            return getterMissingFallback;
        }
        try {
            return (R)this.mObjectConverter.toType(type, this.runGetter(method, this.getItem(this.getPosition())));
        }
        catch (ConversionErrorException e) {
            if (this.mDebugEnabled) {
                String message = String.format("Failed to convert field '%s' at %d/%d. Type Requested: %s", new Object[]{fieldName, this.getPosition(), this.getCount(), type});
                Log.w((String)this.TAG, (String)message, (Throwable)e);
                e.printStackTrace();
            }
            return conversionErrorFallback;
        }
    }

    public boolean isDebugEnabled() {
        return this.mDebugEnabled;
    }

    public void setDebugEnabled(boolean enabled) {
        this.mDebugEnabled = enabled;
    }

    public boolean isNull(int column) {
        return this.isNullInternal(this.mFieldAccessor.getMethod(column));
    }

    @Override
    public boolean isNull(String fieldName) {
        return this.isNullInternal(this.getGetterForFieldOrThrow(this.applyAlias(fieldName)));
    }

    private boolean isNullInternal(Method method) {
        return this.runGetter(method, this.getItem(this.getPosition())) == null;
    }

    @Override
    public boolean optBoolean(String fieldName) {
        return this.internalOpt(ObjectType.BOOLEAN, fieldName, false, false);
    }

    @Override
    public boolean optBoolean(String fieldName, boolean fallback) {
        return this.internalOpt(ObjectType.BOOLEAN, fieldName, fallback, false);
    }

    @Override
    public Boolean optBooleanAsWrapperType(String fieldName) {
        return this.internalOpt(ObjectType.BOOLEAN, fieldName, null, false);
    }

    @Override
    public double optDouble(String fieldName) {
        return this.internalOpt(ObjectType.DOUBLE, fieldName, 0.0, 0.0);
    }

    @Override
    public double optDouble(String fieldName, double fallback) {
        return this.internalOpt(ObjectType.DOUBLE, fieldName, fallback, 0.0);
    }

    @Override
    public Double optDoubleAsWrapperType(String fieldName) {
        return this.internalOpt(ObjectType.DOUBLE, fieldName, null, 0.0);
    }

    @Override
    public float optFloat(String fieldName) {
        return this.internalOpt(ObjectType.FLOAT, fieldName, Float.valueOf(0.0f), Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public float optFloat(String fieldName, float fallback) {
        return this.internalOpt(ObjectType.FLOAT, fieldName, Float.valueOf(fallback), Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Float optFloatAsWrapperType(String fieldName) {
        return this.internalOpt(ObjectType.FLOAT, fieldName, null, Float.valueOf(0.0f));
    }

    @Override
    public int optInt(String fieldName) {
        return this.internalOpt(ObjectType.INTEGER, fieldName, 0, 0);
    }

    @Override
    public int optInt(String fieldName, int fallback) {
        return this.internalOpt(ObjectType.INTEGER, fieldName, fallback, 0);
    }

    @Override
    public Integer optIntAsWrapperType(String fieldName) {
        return this.internalOpt(ObjectType.INTEGER, fieldName, null, 0);
    }

    @Override
    public long optLong(String fieldName) {
        return this.internalOpt(ObjectType.LONG, fieldName, 0L, 0L);
    }

    @Override
    public long optLong(String fieldName, long fallback) {
        return this.internalOpt(ObjectType.LONG, fieldName, fallback, 0L);
    }

    @Override
    public Long optLongAsWrapperType(String fieldName) {
        return this.internalOpt(ObjectType.LONG, fieldName, null, 0L);
    }

    @Override
    public short optShort(String fieldName) {
        return this.internalOpt(ObjectType.SHORT, fieldName, (short)0, (short)0);
    }

    @Override
    public short optShort(String fieldName, short fallback) {
        return this.internalOpt(ObjectType.SHORT, fieldName, fallback, (short)0);
    }

    @Override
    public Short optShortAsWrapperType(String fieldName) {
        return this.internalOpt(ObjectType.SHORT, fieldName, null, (short)0);
    }

    @Override
    public String optString(String fieldName) {
        return this.internalOpt(ObjectType.STRING, fieldName, DEFAULT_STRING, DEFAULT_STRING);
    }

    @Override
    public String optString(String fieldName, String fallback) {
        return this.internalOpt(ObjectType.STRING, fieldName, fallback, DEFAULT_STRING);
    }

    private Object runGetter(Method method, T object) {
        if (method != null) {
            try {
                return method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Log.w((String)this.TAG, (String)("Could not determine method: " + method.getName()));
            }
            catch (InvocationTargetException e) {
                Log.w((String)this.TAG, (String)("Could not determine method: " + method.getName()));
            }
        }
        return null;
    }
}

