/*
 * Decompiled with CFR 0.152.
 */
package dev.alt236.easycursor.objectcursor;

import dev.alt236.easycursor.internal.FieldAccessor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class ObjectFieldAccessor<T>
implements FieldAccessor {
    private static final String IS = "is";
    private static final String GET = "get";
    private final Map<String, Integer> mFieldToIndexMap;
    private final Map<String, Method> mFieldToMethodMap = Collections.synchronizedMap(new HashMap());
    private final List<Method> mMethodList = new ArrayList<Method>();
    private final List<String> mFieldNameList;

    public ObjectFieldAccessor(Class<T> clazz) {
        this.mFieldToIndexMap = new HashMap<String, Integer>();
        this.mFieldNameList = new ArrayList<String>();
        this.populateMethodList(clazz);
    }

    @Override
    public int getFieldIndexByName(String name) {
        if (this.mFieldToIndexMap.containsKey(name)) {
            return this.mFieldToIndexMap.get(name);
        }
        return -1;
    }

    @Override
    public String getFieldNameByIndex(int index) {
        return this.mFieldNameList.get(index);
    }

    @Override
    public String[] getFieldNames() {
        return this.mFieldNameList.toArray(new String[this.mFieldNameList.size()]);
    }

    public synchronized Method getGetterForField(String field) {
        if (this.mFieldToMethodMap.containsKey(field)) {
            return this.mFieldToMethodMap.get(field);
        }
        String booleanField = IS + field.toLowerCase(Locale.US);
        String otherField = GET + field.toLowerCase(Locale.US);
        Method methodResult = null;
        for (Method method : this.mMethodList) {
            if (method.getName().toLowerCase(Locale.US).equals(booleanField)) {
                methodResult = method;
                break;
            }
            if (!method.getName().toLowerCase(Locale.US).equals(otherField)) continue;
            methodResult = method;
            break;
        }
        this.mFieldToMethodMap.put(field, methodResult);
        return methodResult;
    }

    public Method getMethod(int index) {
        return this.mMethodList.get(index);
    }

    public List<Method> getMethodList() {
        return this.mMethodList;
    }

    private void populateMethodList(Class<T> clazz) {
        int count = 0;
        for (Method method : clazz.getMethods()) {
            Method candidate = null;
            String canditateCleanName = null;
            if (!Modifier.isPublic(method.getModifiers()) || method.getName().length() <= 3 || method.getParameterTypes().length != 0 || method.getReturnType().equals(Void.TYPE)) continue;
            if (method.getName().startsWith(GET)) {
                candidate = method;
                canditateCleanName = method.getName().substring(GET.length()).toLowerCase(Locale.US);
            } else if (method.getName().startsWith(IS)) {
                candidate = method;
                canditateCleanName = method.getName().substring(IS.length()).toLowerCase(Locale.US);
            }
            if (candidate == null) continue;
            this.mMethodList.add(candidate);
            this.mFieldToIndexMap.put(canditateCleanName, count);
            this.mFieldNameList.add(canditateCleanName);
            ++count;
        }
    }
}

