/*
 * Decompiled with CFR 0.152.
 */
package dev.alt236.easycursor.sqlcursor;

import android.annotation.TargetApi;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.os.Build;
import android.util.Log;
import dev.alt236.easycursor.EasyCursor;
import dev.alt236.easycursor.sqlcursor.BooleanLogic;
import dev.alt236.easycursor.sqlcursor.DefaultBooleanLogic;
import dev.alt236.easycursor.sqlcursor.querymodels.SqlQueryModel;
import java.util.Arrays;

public class EasySqlCursor
extends CursorWrapper
implements EasyCursor {
    public static final String DEFAULT_STRING = null;
    public static final int DEFAULT_INT = 0;
    public static final long DEFAULT_LONG = 0L;
    public static final float DEFAULT_FLOAT = 0.0f;
    public static final double DEFAULT_DOUBLE = 0.0;
    public static final short DEFAULT_SHORT = 0;
    public static final boolean DEFAULT_BOOLEAN = false;
    private static final BooleanLogic DEFAULT_BOOLEAN_LOGIC = new DefaultBooleanLogic();
    private static final String TAG = EasySqlCursor.class.getSimpleName();
    private static final int COLUMN_NOT_PRESENT = -1;
    private final BooleanLogic mBooleanLogic;
    private final SqlQueryModel mModel;
    private boolean mDebugEnabled;

    public EasySqlCursor(Cursor cursor) {
        this(cursor, null, null);
    }

    public EasySqlCursor(Cursor cursor, BooleanLogic booleanLogic) {
        this(cursor, null, booleanLogic);
    }

    public EasySqlCursor(Cursor cursor, SqlQueryModel model, BooleanLogic booleanLogic) {
        super(cursor);
        this.mModel = model;
        this.mBooleanLogic = booleanLogic == null ? DEFAULT_BOOLEAN_LOGIC : booleanLogic;
    }

    private boolean calcBoolean(int columnNumber) {
        return this.mBooleanLogic.isTrue(this, columnNumber);
    }

    @Override
    public byte[] getBlob(String columnName) {
        return this.getBlob(this.getColumnIndexOrThrow(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) {
        int columnNumber = this.getColumnIndexOrThrow(columnName);
        return this.calcBoolean(columnNumber);
    }

    @Override
    public double getDouble(String columnName) {
        return this.getDouble(this.getColumnIndexOrThrow(columnName));
    }

    @Override
    public float getFloat(String columnName) {
        return this.getFloat(this.getColumnIndexOrThrow(columnName));
    }

    @Override
    public int getInt(String columnName) {
        return this.getInt(this.getColumnIndexOrThrow(columnName));
    }

    @Override
    public long getLong(String columnName) {
        return this.getLong(this.getColumnIndexOrThrow(columnName));
    }

    @Override
    public SqlQueryModel getQueryModel() {
        return this.mModel;
    }

    @Override
    public short getShort(String columnName) {
        return this.getShort(this.getColumnIndexOrThrow(columnName));
    }

    @Override
    public String getString(String columnName) {
        return this.getString(this.getColumnIndexOrThrow(columnName));
    }

    protected boolean isColumnPresent(String columnName, int columnNo) {
        if (columnNo == -1) {
            if (this.mDebugEnabled) {
                Log.w((String)TAG, (String)("Column '" + columnName + "' is not present in Cursor - " + this.getPosition() + "/" + this.getCount()));
            }
            return false;
        }
        return true;
    }

    public boolean isDebugEnabled() {
        return this.mDebugEnabled;
    }

    public void setDebugEnabled(boolean enabled) {
        this.mDebugEnabled = enabled;
    }

    @Override
    public boolean isNull(String columnName) {
        return this.isNull(this.getColumnIndex(columnName));
    }

    @Override
    public boolean optBoolean(String columnName) {
        return this.optBoolean(columnName, false);
    }

    @Override
    public boolean optBoolean(String columnName, boolean fallback) {
        int columnNo = this.getColumnIndex(columnName);
        if (this.isColumnPresent(columnName, columnNo)) {
            return this.calcBoolean(columnNo);
        }
        return fallback;
    }

    @Override
    public Boolean optBooleanAsWrapperType(String columnName) {
        int columnNo = this.getColumnIndex(columnName);
        if (this.isColumnPresent(columnName, columnNo)) {
            return this.calcBoolean(columnNo) ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public double optDouble(String columnName) {
        return this.optDouble(columnName, 0.0);
    }

    @Override
    public double optDouble(String columnName, double fallback) {
        int columnNo = this.getColumnIndex(columnName);
        if (this.isColumnPresent(columnName, columnNo)) {
            return this.getDouble(columnNo);
        }
        return fallback;
    }

    @Override
    public Double optDoubleAsWrapperType(String columnName) {
        int columnNo = this.getColumnIndex(columnName);
        if (this.isColumnPresent(columnName, columnNo)) {
            return this.getDouble(columnNo);
        }
        return null;
    }

    @Override
    public float optFloat(String columnName) {
        return this.optFloat(columnName, 0.0f);
    }

    @Override
    public float optFloat(String columnName, float fallback) {
        int columnNo = this.getColumnIndex(columnName);
        if (this.isColumnPresent(columnName, columnNo)) {
            return this.getFloat(columnNo);
        }
        return fallback;
    }

    @Override
    public Float optFloatAsWrapperType(String columnName) {
        int columnNo = this.getColumnIndex(columnName);
        if (this.isColumnPresent(columnName, columnNo)) {
            return Float.valueOf(this.getFloat(columnNo));
        }
        return null;
    }

    @Override
    public int optInt(String columnName) {
        return this.optInt(columnName, 0);
    }

    @Override
    public int optInt(String columnName, int fallback) {
        int columnNo = this.getColumnIndex(columnName);
        if (this.isColumnPresent(columnName, columnNo)) {
            return this.getInt(columnNo);
        }
        return fallback;
    }

    @Override
    public Integer optIntAsWrapperType(String columnName) {
        int columnNo = this.getColumnIndex(columnName);
        if (this.isColumnPresent(columnName, columnNo)) {
            return this.getInt(columnNo);
        }
        return null;
    }

    @Override
    public long optLong(String columnName) {
        return this.optLong(columnName, 0L);
    }

    @Override
    public long optLong(String columnName, long fallback) {
        int columnNo = this.getColumnIndex(columnName);
        if (this.isColumnPresent(columnName, columnNo)) {
            return this.getLong(columnNo);
        }
        return fallback;
    }

    @Override
    public Long optLongAsWrapperType(String columnName) {
        int columnNo = this.getColumnIndex(columnName);
        if (this.isColumnPresent(columnName, columnNo)) {
            return this.getLong(columnNo);
        }
        return null;
    }

    @Override
    public short optShort(String columnName) {
        return this.optShort(columnName, (short)0);
    }

    @Override
    public short optShort(String columnName, short fallback) {
        int columnNo = this.getColumnIndex(columnName);
        if (this.isColumnPresent(columnName, columnNo)) {
            return this.getShort(columnNo);
        }
        return fallback;
    }

    @Override
    public Short optShortAsWrapperType(String columnName) {
        int columnNo = this.getColumnIndex(columnName);
        if (this.isColumnPresent(columnName, columnNo)) {
            return this.getShort(columnNo);
        }
        return null;
    }

    @Override
    public String optString(String columnName) {
        return this.optString(columnName, DEFAULT_STRING);
    }

    @Override
    public String optString(String columnName, String fallback) {
        int columnNo = this.getColumnIndex(columnName);
        if (this.isColumnPresent(columnName, columnNo)) {
            return this.getString(columnNo);
        }
        return fallback;
    }

    public String toString() {
        return "EasyCursor [mModel=" + this.mModel + ", mDebugEnabled=" + this.mDebugEnabled + ", isClosed()=" + this.isClosed() + ", getCount()=" + this.getCount() + ", getColumnCount()=" + this.getColumnCount() + ", getColumnNames()=" + Arrays.toString(this.getColumnNames()) + ", getPosition()=" + this.getPosition() + "]";
    }

    @TargetApi(value=11)
    private static Cursor getAppropriateCursor(EasySqlCursor cursor) {
        int currentApi = Build.VERSION.SDK_INT;
        if (currentApi >= 11) {
            return cursor.getWrappedCursor();
        }
        return cursor;
    }
}

