/*
 * Decompiled with CFR 0.152.
 */
package dev.alt236.easycursor.sqlcursor.querybuilders;

import dev.alt236.easycursor.sqlcursor.querybuilders.interfaces.QueryModelInfo;
import dev.alt236.easycursor.sqlcursor.querybuilders.interfaces.SqlRawQueryBuilder;
import dev.alt236.easycursor.sqlcursor.querybuilders.interfaces.SqlSelectBuilder;
import dev.alt236.easycursor.sqlcursor.querymodels.RawQueryModel;
import dev.alt236.easycursor.sqlcursor.querymodels.SelectQueryModel;
import dev.alt236.easycursor.sqlcursor.querymodels.SqlQueryModel;

public class CompatSqlModelBuilder
implements SqlRawQueryBuilder,
SqlSelectBuilder,
QueryModelInfo {
    protected int mModelVersion;
    protected String mModelTag;
    protected String mModelComment;
    private int mQueryType = 0;
    private String mRawSql;
    private boolean mDistinct;
    private boolean mStrict;
    private String mTables;
    private String[] mProjectionIn;
    private String[] mSelectionArgs;
    private String mSelection;
    private String mGroupBy;
    private String mHaving;
    private String mSortOrder;
    private String mLimit;

    @Override
    public SqlQueryModel build() {
        if (this.mQueryType == 2) {
            return new RawQueryModel(this);
        }
        if (this.mQueryType == 1) {
            return new SelectQueryModel(this);
        }
        if (this.mQueryType == 0) {
            throw new IllegalStateException("You need to set some query parameters before calling build()!");
        }
        throw new IllegalStateException("Unknown query type: " + this.mQueryType);
    }

    @Override
    public String getGroupBy() {
        return this.mGroupBy;
    }

    @Override
    public String getHaving() {
        return this.mHaving;
    }

    @Override
    public String getLimit() {
        return this.mLimit;
    }

    @Override
    public String getModelComment() {
        return this.mModelComment;
    }

    public void setModelComment(String comment) {
        this.mModelComment = comment;
    }

    @Override
    public String getModelTag() {
        return this.mModelTag;
    }

    public void setModelTag(String tag) {
        this.mModelTag = tag;
    }

    @Override
    public int getModelVersion() {
        return this.mModelVersion;
    }

    public void setModelVersion(int modelVersion) {
        this.mModelVersion = modelVersion;
    }

    @Override
    public String[] getProjectionIn() {
        return this.mProjectionIn;
    }

    @Override
    public String getRawSql() {
        return this.mRawSql;
    }

    @Override
    public String getSelection() {
        return this.mSelection;
    }

    @Override
    public String[] getSelectionArgs() {
        return this.mSelectionArgs;
    }

    @Override
    public String getSortOrder() {
        return this.mSortOrder;
    }

    @Override
    public String getTables() {
        return this.mTables;
    }

    public void setTables(String inTables) {
        this.mTables = inTables;
    }

    @Override
    public boolean isDistinct() {
        return this.mDistinct;
    }

    public void setDistinct(boolean distinct) {
        this.mDistinct = distinct;
    }

    @Override
    public boolean isStrict() {
        return this.mStrict;
    }

    public void setStrict(boolean value) {
        this.mStrict = value;
    }

    public void setQueryParams(String rawSql, String[] selectionArgs) {
        if (this.mQueryType != 0) {
            throw new IllegalStateException("A Model file's query parameters can only be set once!");
        }
        this.mQueryType = 2;
        this.mSelectionArgs = selectionArgs;
        this.mRawSql = rawSql;
    }

    public void setQueryParams(String[] projectionIn, String selection, String[] selectionArgs, String sortOrder) {
        this.setQueryParams(projectionIn, selection, selectionArgs, null, null, sortOrder, null);
    }

    public void setQueryParams(String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder) {
        this.setQueryParams(projectionIn, selection, selectionArgs, groupBy, having, sortOrder, null);
    }

    public void setQueryParams(String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder, String limit) {
        if (this.mQueryType != 0) {
            throw new IllegalStateException("A Model file's query parameters can only be set once!");
        }
        this.mQueryType = 1;
        this.mProjectionIn = projectionIn;
        this.mSelection = selection;
        this.mSelectionArgs = selectionArgs;
        this.mGroupBy = groupBy;
        this.mHaving = having;
        this.mSortOrder = sortOrder;
        this.mLimit = limit;
    }
}

