/*
 * Decompiled with CFR 0.152.
 */
package dev.alt236.easycursor.sqlcursor.querymodels;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import dev.alt236.easycursor.sqlcursor.querybuilders.interfaces.QueryModelInfo;
import dev.alt236.easycursor.sqlcursor.querybuilders.interfaces.SqlRawQueryBuilder;
import dev.alt236.easycursor.sqlcursor.querymodels.JsonWrapper;
import dev.alt236.easycursor.sqlcursor.querymodels.SqlQueryModel;
import dev.alt236.easycursor.util.JsonPayloadHelper;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class RawQueryModel
extends SqlQueryModel {
    private static final int QUERY_TYPE = 2;
    private static final String FIELD_RAW_SQL = "rawSql";
    private static final String FIELD_SELECTION_ARGS = "selectionArgs";
    private final String mRawSql;
    private final String[] mSelectionArgs;

    public RawQueryModel(SqlRawQueryBuilder builder) {
        super(builder instanceof QueryModelInfo ? (QueryModelInfo)((Object)builder) : null, 2);
        this.mRawSql = builder.getRawSql();
        this.mSelectionArgs = builder.getSelectionArgs();
    }

    public RawQueryModel(JsonWrapper wrapper) {
        super(wrapper, 2);
        this.mRawSql = wrapper.getString(FIELD_RAW_SQL);
        this.mSelectionArgs = wrapper.getStringArray(FIELD_SELECTION_ARGS);
    }

    @Override
    protected Cursor executeQueryInternal(SQLiteDatabase db) {
        return db.rawQuery(this.mRawSql, this.mSelectionArgs);
    }

    public String getRawSql() {
        return this.mRawSql;
    }

    public String[] getSelectionArgs() {
        return this.mSelectionArgs;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject payload = new JSONObject();
        this.addCommonFields(payload);
        JsonPayloadHelper.add(payload, FIELD_RAW_SQL, this.getRawSql());
        JsonPayloadHelper.add(payload, FIELD_SELECTION_ARGS, this.getSelectionArgs());
        return payload.toString();
    }

    @Override
    public String toString() {
        return "RawQueryModel{mRawSql='" + this.mRawSql + '\'' + ", mSelectionArgs=" + Arrays.toString(this.mSelectionArgs) + '}';
    }
}

