/*
 * Decompiled with CFR 0.152.
 */
package dev.alt236.easycursor.sqlcursor.querymodels;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.os.Build;
import dev.alt236.easycursor.sqlcursor.querybuilders.interfaces.QueryModelInfo;
import dev.alt236.easycursor.sqlcursor.querybuilders.interfaces.SqlSelectBuilder;
import dev.alt236.easycursor.sqlcursor.querymodels.JsonWrapper;
import dev.alt236.easycursor.sqlcursor.querymodels.SqlQueryModel;
import dev.alt236.easycursor.util.JsonPayloadHelper;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class SelectQueryModel
extends SqlQueryModel {
    private static final int QUERY_TYPE = 1;
    private static final String FIELD_DISTINCT = "distinct";
    private static final String FIELD_GROUP_BY = "groupBy";
    private static final String FIELD_HAVING = "having";
    private static final String FIELD_LIMIT = "limit";
    private static final String FIELD_PROJECTION_IN = "projectionIn";
    private static final String FIELD_SELECTION = "selection";
    private static final String FIELD_SORT_ORDER = "sortOrder";
    private static final String FIELD_STRICT = "strict";
    private static final String FIELD_TABLES = "tables";
    private static final String FIELD_SELECTION_ARGS = "selectionArgs";
    private final boolean mDistinct;
    private final boolean mStrict;
    private final String mTables;
    private final String[] mProjectionIn;
    private final String[] mSelectionArgs;
    private final String mSelection;
    private final String mGroupBy;
    private final String mHaving;
    private final String mSortOrder;
    private final String mLimit;

    public SelectQueryModel(SqlSelectBuilder builder) {
        super(builder instanceof QueryModelInfo ? (QueryModelInfo)((Object)builder) : null, 1);
        this.mDistinct = builder.isDistinct();
        this.mGroupBy = builder.getGroupBy();
        this.mHaving = builder.getHaving();
        this.mLimit = builder.getLimit();
        this.mProjectionIn = builder.getProjectionIn();
        this.mSelection = builder.getSelection();
        this.mSelectionArgs = builder.getSelectionArgs();
        this.mSortOrder = builder.getSortOrder();
        this.mStrict = builder.isStrict();
        this.mTables = builder.getTables();
    }

    public SelectQueryModel(JsonWrapper wrapper) {
        super(wrapper, 1);
        this.mDistinct = wrapper.getBoolean(FIELD_DISTINCT);
        this.mGroupBy = wrapper.getString(FIELD_GROUP_BY);
        this.mHaving = wrapper.getString(FIELD_HAVING);
        this.mLimit = wrapper.getString(FIELD_LIMIT);
        this.mModelComment = wrapper.getString("modelComment");
        this.mModelTag = wrapper.getString("modelTag");
        this.mModelVersion = wrapper.getInt("modelVersion");
        this.mProjectionIn = wrapper.getStringArray(FIELD_PROJECTION_IN);
        this.mSelection = wrapper.getString(FIELD_SELECTION);
        this.mSortOrder = wrapper.getString(FIELD_SORT_ORDER);
        this.mStrict = wrapper.getBoolean(FIELD_STRICT);
        this.mTables = wrapper.getString(FIELD_TABLES);
        this.mSelectionArgs = wrapper.getStringArray(FIELD_SELECTION_ARGS);
    }

    @Override
    protected Cursor executeQueryInternal(SQLiteDatabase db) {
        SQLiteQueryBuilder builder = new SQLiteQueryBuilder();
        builder.setTables(this.getTables());
        builder.setDistinct(this.isDistinct());
        if (Build.VERSION.SDK_INT >= 14) {
            builder.setStrict(this.isStrict());
        }
        return builder.query(db, this.getProjectionIn(), this.getSelection(), this.getSelectionArgs(), this.getGroupBy(), this.getHaving(), this.getSortOrder(), this.getLimit());
    }

    public String getGroupBy() {
        return this.mGroupBy;
    }

    public String getHaving() {
        return this.mHaving;
    }

    public String getLimit() {
        return this.mLimit;
    }

    public String[] getProjectionIn() {
        return this.mProjectionIn;
    }

    public String getSelection() {
        return this.mSelection;
    }

    public String[] getSelectionArgs() {
        return this.mSelectionArgs;
    }

    public String getSortOrder() {
        return this.mSortOrder;
    }

    public String getTables() {
        return this.mTables;
    }

    public boolean isDistinct() {
        return this.mDistinct;
    }

    public boolean isStrict() {
        return this.mStrict;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject payload = new JSONObject();
        this.addCommonFields(payload);
        JsonPayloadHelper.add(payload, FIELD_DISTINCT, this.mDistinct);
        JsonPayloadHelper.add(payload, FIELD_GROUP_BY, this.mGroupBy);
        JsonPayloadHelper.add(payload, FIELD_HAVING, this.mHaving);
        JsonPayloadHelper.add(payload, FIELD_LIMIT, this.mLimit);
        JsonPayloadHelper.add(payload, FIELD_PROJECTION_IN, this.mProjectionIn);
        JsonPayloadHelper.add(payload, FIELD_SELECTION, this.mSelection);
        JsonPayloadHelper.add(payload, FIELD_SELECTION_ARGS, this.mSelectionArgs);
        JsonPayloadHelper.add(payload, FIELD_SORT_ORDER, this.mSortOrder);
        JsonPayloadHelper.add(payload, FIELD_STRICT, this.mStrict);
        JsonPayloadHelper.add(payload, FIELD_TABLES, this.mTables);
        return payload.toString();
    }

    @Override
    public String toString() {
        return "SelectQueryModel{mDistinct=" + this.mDistinct + ", mStrict=" + this.mStrict + ", mTables='" + this.mTables + '\'' + ", mProjectionIn=" + Arrays.toString(this.mProjectionIn) + ", mSelectionArgs=" + Arrays.toString(this.mSelectionArgs) + ", mSelection='" + this.mSelection + '\'' + ", mGroupBy='" + this.mGroupBy + '\'' + ", mHaving='" + this.mHaving + '\'' + ", mSortOrder='" + this.mSortOrder + '\'' + ", mLimit='" + this.mLimit + '\'' + '}';
    }
}

