/*
 * Decompiled with CFR 0.152.
 */
package dev.alt236.easycursor.sqlcursor.querymodels;

import android.annotation.SuppressLint;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import dev.alt236.easycursor.EasyCursor;
import dev.alt236.easycursor.EasyQueryModel;
import dev.alt236.easycursor.sqlcursor.BooleanLogic;
import dev.alt236.easycursor.sqlcursor.EasySqlCursor;
import dev.alt236.easycursor.sqlcursor.querybuilders.interfaces.QueryModelInfo;
import dev.alt236.easycursor.sqlcursor.querybuilders.interfaces.SqlRawQueryBuilder;
import dev.alt236.easycursor.sqlcursor.querybuilders.interfaces.SqlSelectBuilder;
import dev.alt236.easycursor.sqlcursor.querymodels.RawQueryModel;
import dev.alt236.easycursor.sqlcursor.querymodels.SelectQueryModel;
import dev.alt236.easycursor.util.JsonPayloadHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class SqlQueryModel
implements EasyQueryModel {
    public static final int QUERY_TYPE_UNINITIALISED = 0;
    public static final int QUERY_TYPE_MANAGED = 1;
    public static final int QUERY_TYPE_RAW = 2;
    protected static final String FIELD_MODEL_COMMENT = "modelComment";
    protected static final String FIELD_MODEL_TAG = "modelTag";
    protected static final String FIELD_MODEL_VERSION = "modelVersion";
    protected static final String FIELD_QUERY_TYPE = "queryType";
    private final int mQueryType;
    protected int mModelVersion;
    protected String mModelTag;
    protected String mModelComment;

    public SqlQueryModel(QueryModelInfo info, int queryType) {
        this.mQueryType = queryType;
        if (info != null) {
            this.mModelVersion = info.getModelVersion();
            this.mModelTag = info.getModelTag();
            this.mModelComment = info.getModelComment();
        }
    }

    protected void addCommonFields(JSONObject payload) throws JSONException {
        JsonPayloadHelper.add(payload, FIELD_MODEL_COMMENT, this.mModelComment);
        JsonPayloadHelper.add(payload, FIELD_MODEL_TAG, this.mModelTag);
        JsonPayloadHelper.add(payload, FIELD_MODEL_VERSION, this.mModelVersion);
        JsonPayloadHelper.add(payload, FIELD_QUERY_TYPE, this.mQueryType);
    }

    public EasyCursor execute(SQLiteDatabase db) {
        return this.execute(db, null);
    }

    public EasyCursor execute(SQLiteDatabase db, BooleanLogic booleanLogic) {
        try {
            return this.execute(db, null, booleanLogic);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("We should never get here...", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("We should never get here...", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("We should never get here...", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("We should never get here...", e);
        }
    }

    public EasyCursor execute(SQLiteDatabase db, Class<? extends EasySqlCursor> easyCursorClass, BooleanLogic booleanLogic) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Cursor c = this.executeQuery(db);
        if (easyCursorClass == null) {
            return new EasySqlCursor(c, this, booleanLogic);
        }
        Constructor<? extends EasySqlCursor> constructor = easyCursorClass.getDeclaredConstructor(Cursor.class, SqlQueryModel.class, BooleanLogic.class);
        return constructor.newInstance(c, this, booleanLogic);
    }

    @SuppressLint(value={"NewApi"})
    private Cursor executeQuery(SQLiteDatabase db) {
        Cursor cursor = this.executeQueryInternal(db);
        cursor.moveToFirst();
        return cursor;
    }

    protected abstract Cursor executeQueryInternal(SQLiteDatabase var1);

    @Override
    public String getModelComment() {
        return this.mModelComment;
    }

    @Override
    public void setModelComment(String modelComment) {
        this.mModelComment = modelComment;
    }

    @Override
    public String getModelTag() {
        return this.mModelTag;
    }

    @Override
    public void setModelTag(String modelTag) {
        this.mModelTag = modelTag;
    }

    @Override
    public int getModelVersion() {
        return this.mModelVersion;
    }

    @Override
    public void setModelVersion(int modelVersion) {
        this.mModelVersion = modelVersion;
    }

    public int getQueryType() {
        return this.mQueryType;
    }

    @Override
    public abstract String toJson() throws JSONException;

    public String toString() {
        return "EasySqlQueryModel{mQueryType=" + this.mQueryType + ", mModelVersion=" + this.mModelVersion + ", mModelTag='" + this.mModelTag + '\'' + ", mModelComment='" + this.mModelComment + '\'' + '}';
    }

    public static class SelectQueryBuilder
    implements SqlSelectBuilder,
    QueryModelInfo {
        private int modelVersion;
        private String modelTag;
        private String modelComment;
        private boolean distinct;
        private boolean strict;
        private String tables;
        private String[] projectionIn;
        private String[] selectionArgs;
        private String selection;
        private String groupBy;
        private String having;
        private String sortOrder;
        private String limit;

        @Override
        public SqlQueryModel build() {
            return new SelectQueryModel(this);
        }

        @Override
        public String getGroupBy() {
            return this.groupBy;
        }

        public SelectQueryBuilder setGroupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        @Override
        public String getHaving() {
            return this.having;
        }

        public SelectQueryBuilder setHaving(String having) {
            this.having = having;
            return this;
        }

        @Override
        public String getLimit() {
            return this.limit;
        }

        public SelectQueryBuilder setLimit(String limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public String getModelComment() {
            return this.modelComment;
        }

        public SelectQueryBuilder setModelComment(String comment) {
            this.modelComment = comment;
            return this;
        }

        @Override
        public String getModelTag() {
            return this.modelTag;
        }

        public SelectQueryBuilder setModelTag(String tag) {
            this.modelTag = tag;
            return this;
        }

        @Override
        public int getModelVersion() {
            return this.modelVersion;
        }

        public SelectQueryBuilder setModelVersion(int version) {
            this.modelVersion = version;
            return this;
        }

        @Override
        public String[] getProjectionIn() {
            return this.projectionIn;
        }

        public SelectQueryBuilder setProjectionIn(String[] projectionIn) {
            this.projectionIn = projectionIn;
            return this;
        }

        @Override
        public String getSelection() {
            return this.selection;
        }

        public SelectQueryBuilder setSelection(String selection) {
            this.selection = selection;
            return this;
        }

        @Override
        public String[] getSelectionArgs() {
            return this.selectionArgs;
        }

        public SelectQueryBuilder setSelectionArgs(String[] args) {
            this.selectionArgs = args;
            return this;
        }

        @Override
        public String getSortOrder() {
            return this.sortOrder;
        }

        public SelectQueryBuilder setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public String getTables() {
            return this.tables;
        }

        public SelectQueryBuilder setTables(String tables) {
            this.tables = tables;
            return this;
        }

        @Override
        public boolean isDistinct() {
            return this.distinct;
        }

        public SelectQueryBuilder setDistinct(boolean distinct) {
            this.distinct = distinct;
            return this;
        }

        @Override
        public boolean isStrict() {
            return this.strict;
        }

        public SelectQueryBuilder setStrict(boolean strict) {
            this.strict = strict;
            return this;
        }
    }

    public static class RawQueryBuilder
    implements SqlRawQueryBuilder,
    QueryModelInfo {
        private int modelVersion;
        private String modelTag;
        private String modelComment;
        private String rawSql;
        private String[] selectionArgs;

        @Override
        public SqlQueryModel build() {
            return new RawQueryModel(this);
        }

        @Override
        public String getModelComment() {
            return this.modelComment;
        }

        public RawQueryBuilder setModelComment(String comment) {
            this.modelComment = comment;
            return this;
        }

        @Override
        public String getModelTag() {
            return this.modelTag;
        }

        public RawQueryBuilder setModelTag(String tag) {
            this.modelTag = tag;
            return this;
        }

        @Override
        public int getModelVersion() {
            return this.modelVersion;
        }

        public RawQueryBuilder setModelVersion(int version) {
            this.modelVersion = version;
            return this;
        }

        @Override
        public String getRawSql() {
            return this.rawSql;
        }

        public RawQueryBuilder setRawSql(String sql) {
            this.rawSql = sql;
            return this;
        }

        @Override
        public String[] getSelectionArgs() {
            return this.selectionArgs;
        }

        public RawQueryBuilder setSelectionArgs(String[] args) {
            this.selectionArgs = args;
            return this;
        }
    }
}

