/*
 * Decompiled with CFR 0.152.
 */
package dev.alt236.easycursor.util;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonPayloadHelper {
    private static final String NULL = "null";

    private JsonPayloadHelper() {
    }

    public static void add(JSONObject object, String key, Boolean value) throws JSONException {
        object.put(key, (Object)value);
    }

    public static void add(JSONObject object, String key, Double value) throws JSONException {
        object.put(key, (Object)value);
    }

    public static void add(JSONObject object, String key, Integer value) throws JSONException {
        object.put(key, (Object)value);
    }

    public static void add(JSONObject object, String key, Long value) throws JSONException {
        object.put(key, (Object)value);
    }

    public static void add(JSONObject object, String key, Object value) throws JSONException {
        object.put(key, value);
    }

    public static void add(JSONObject object, String key, String value) throws JSONException {
        object.put(key, (Object)value);
    }

    public static void add(JSONObject object, String key, String[] value) throws JSONException {
        JSONArray arr = new JSONArray();
        if (value != null && value.length > 0) {
            for (String str : value) {
                arr.put((Object)str);
            }
        }
        object.put(key, (Object)arr);
    }

    public static boolean getBoolean(JSONObject object, String key) {
        return object.optBoolean(key, false);
    }

    public static int getInt(JSONObject object, String key) {
        return object.optInt(key, 0);
    }

    public static String getString(JSONObject object, String key) {
        String res = object.optString(key, null);
        if (key != null && key.equalsIgnoreCase(NULL)) {
            return null;
        }
        return res;
    }

    public static String[] getStringArray(JSONObject payload, String key) {
        String[] res;
        JSONArray arr = payload.optJSONArray(key);
        if (arr != null && arr.length() > 0) {
            int count = arr.length();
            res = new String[count];
            for (int i = 0; i < count; ++i) {
                res[i] = arr.optString(i);
            }
        } else {
            res = null;
        }
        return res;
    }
}

