/*
 * Decompiled with CFR 0.152.
 */
package dev.angerm.ag_server.grpc;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.linecorp.armeria.server.HttpServiceWithRoutes;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.grpc.GrpcService;
import com.linecorp.armeria.server.grpc.GrpcServiceBuilder;
import com.uchuhimo.konf.Config;
import com.uchuhimo.konf.Item;
import dev.angerm.ag_server.ArmeriaAddon;
import dev.angerm.ag_server.Metrics;
import dev.angerm.ag_server.grpc.GrpcSpec;
import dev.angerm.ag_server.grpc.services.HealthService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.prometheus.client.CollectorRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.MonitoringServerInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0002 !B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\f\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00118\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00150\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00178\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/angerm/ag_server/grpc/GrpcBuilder;", "Ldev/angerm/ag_server/ArmeriaAddon;", "config", "Lcom/uchuhimo/konf/Config;", "collectorRegistry", "Lio/prometheus/client/CollectorRegistry;", "(Lcom/uchuhimo/konf/Config;Lio/prometheus/client/CollectorRegistry;)V", "bindableServices", "", "Lio/grpc/ServerServiceDefinition;", "builder", "Lcom/linecorp/armeria/server/grpc/GrpcServiceBuilder;", "kotlin.jvm.PlatformType", "defaultInterceptors", "", "Lio/grpc/ServerInterceptor;", "healthService", "Ldev/angerm/ag_server/grpc/services/HealthService;", "injectedHealthService", "injectedInterceptors", "injectedOrderedInterceptors", "", "modifyGrpcBuilder", "Ldev/angerm/ag_server/grpc/GrpcBuilder$Modifier;", "apply", "", "Lcom/linecorp/armeria/server/ServerBuilder;", "build", "Lcom/linecorp/armeria/server/grpc/GrpcService;", "start", "stop", "Ljava/util/concurrent/CompletableFuture;", "Companion", "Modifier", "grpc"})
public final class GrpcBuilder
implements ArmeriaAddon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    private final GrpcServiceBuilder builder;
    @Inject(optional=true)
    @NotNull
    private final Set<ServerServiceDefinition> bindableServices;
    @Inject(optional=true)
    @Named(value="Global")
    @NotNull
    private final Set<ServerInterceptor> injectedInterceptors;
    @Inject(optional=true)
    @Named(value="Global")
    @NotNull
    private final Set<List<ServerInterceptor>> injectedOrderedInterceptors;
    @Inject(optional=true)
    @Nullable
    private final Modifier modifyGrpcBuilder;
    @Inject(optional=true)
    @Nullable
    private final HealthService injectedHealthService;
    @NotNull
    private final HealthService healthService;
    @NotNull
    private final List<ServerInterceptor> defaultInterceptors;
    @NotNull
    public static final String GLOBAL_INTERCEPTORS = "Global";

    @Inject
    public GrpcBuilder(@NotNull Config config, @NotNull CollectorRegistry collectorRegistry) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)collectorRegistry, (String)"collectorRegistry");
        this.config = config;
        this.builder = GrpcService.builder();
        this.bindableServices = SetsKt.emptySet();
        this.injectedInterceptors = SetsKt.emptySet();
        this.injectedOrderedInterceptors = SetsKt.emptySet();
        HealthService healthService = this.injectedHealthService;
        if (healthService == null) {
            healthService = new HealthService();
        }
        this.healthService = healthService;
        this.defaultInterceptors = new ArrayList();
        this.builder.addService(ProtoReflectionService.newInstance());
        this.builder.addService(this.healthService.bindService());
        this.builder.maxRequestMessageLength(((Number)this.config.get((Item)GrpcSpec.INSTANCE.getMaxInboundMessageSizeBytes())).intValue());
        this.builder.maxResponseMessageLength(((Number)this.config.get((Item)GrpcSpec.INSTANCE.getMaxOutboundMessageSizeBytes())).intValue());
        this.builder.enableHttpJsonTranscoding(((Boolean)this.config.get((Item)GrpcSpec.INSTANCE.getEnableHttpJsonEncoding())).booleanValue());
        this.defaultInterceptors.addAll((Collection<ServerInterceptor>)this.injectedInterceptors);
        Iterable $this$forEach$iv = this.injectedOrderedInterceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List orderedList = (List)element$iv;
            boolean bl = false;
            this.defaultInterceptors.addAll(CollectionsKt.reversed((Iterable)orderedList));
        }
        MonitoringServerInterceptor monitoringServerInterceptor = MonitoringServerInterceptor.create((Configuration)Configuration.allMetrics().withCollectorRegistry(collectorRegistry).withLabelHeaders((List)this.config.get((Item)GrpcSpec.INSTANCE.getHeadersToLog())).withLatencyBuckets(Metrics.Companion.getBuckets()));
        Intrinsics.checkNotNullExpressionValue((Object)monitoringServerInterceptor, (String)"create(\n                \u2026cs.buckets)\n            )");
        this.defaultInterceptors.add((ServerInterceptor)monitoringServerInterceptor);
    }

    private final GrpcService build() {
        Iterable $this$forEach$iv = this.bindableServices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerServiceDefinition it = (ServerServiceDefinition)element$iv;
            boolean bl = false;
            this.builder.addService(ServerInterceptors.intercept((ServerServiceDefinition)it, (List)CollectionsKt.toList((Iterable)this.defaultInterceptors)));
        }
        Modifier modifier = this.modifyGrpcBuilder;
        if (modifier != null) {
            GrpcServiceBuilder grpcServiceBuilder = this.builder;
            Intrinsics.checkNotNullExpressionValue((Object)grpcServiceBuilder, (String)"builder");
            modifier.modify(grpcServiceBuilder, this.config);
        }
        GrpcService grpcService = this.builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)grpcService, (String)"builder.build()");
        return grpcService;
    }

    public void apply(@NotNull ServerBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.service((HttpServiceWithRoutes)this.build(), new Function[0]);
    }

    public void start() {
        this.healthService.setServing(true);
    }

    @NotNull
    public CompletableFuture<?> stop() {
        this.healthService.setServing(false);
        CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(true);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(true)");
        return completableFuture;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Ldev/angerm/ag_server/grpc/GrpcBuilder$Modifier;", "", "modify", "", "builder", "Lcom/linecorp/armeria/server/grpc/GrpcServiceBuilder;", "config", "Lcom/uchuhimo/konf/Config;", "grpc"})
    public static interface Modifier {
        public void modify(@NotNull GrpcServiceBuilder var1, @NotNull Config var2);

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void modify(@NotNull Modifier $this, @NotNull GrpcServiceBuilder builder, @NotNull Config config) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldev/angerm/ag_server/grpc/GrpcBuilder$Companion;", "", "()V", "GLOBAL_INTERCEPTORS", "", "grpc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

