/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.lava.extensions.youtuberotator.tools.ip;

import com.sedmelluq.lava.extensions.youtuberotator.tools.Tuple;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;

public final class IpAddressTools {
    private static final Random RANDOM = new Random();

    public static Tuple<Inet4Address, Inet6Address> getRandomAddressesFromHost(HttpHost host) throws HttpException {
        List<InetAddress> ipList;
        try {
            ipList = Arrays.asList(InetAddress.getAllByName(host.getHostName()));
        }
        catch (UnknownHostException e) {
            throw new HttpException("Could not resolve " + host.getHostName(), (Throwable)e);
        }
        ArrayList<Inet6Address> ip6 = new ArrayList<Inet6Address>();
        ArrayList<Inet4Address> ip4 = new ArrayList<Inet4Address>();
        Collections.reverse(ipList);
        for (InetAddress ip : ipList) {
            if (ip instanceof Inet6Address) {
                ip6.add((Inet6Address)ip);
                continue;
            }
            if (!(ip instanceof Inet4Address)) continue;
            ip4.add((Inet4Address)ip);
        }
        return new Tuple<Inet4Address, Inet6Address>((Inet4Address)IpAddressTools.getRandomFromList(ip4), (Inet6Address)IpAddressTools.getRandomFromList(ip6));
    }

    public static <T> T getRandomFromList(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.get(RANDOM.nextInt(list.size()));
    }
}

