/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.lava.extensions.youtuberotator.tools.ip;

import com.sedmelluq.lava.extensions.youtuberotator.tools.ip.IpBlock;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;

public final class CombinedIpBlock
extends IpBlock {
    private static final Random random = new Random();
    private final Class type;
    private final List<IpBlock> ipBlocks;
    private final BigInteger size;
    private final int[] hitProbability;
    private final ReentrantLock lock;

    public CombinedIpBlock(List<IpBlock> ipBlocks) {
        if (ipBlocks.size() == 0) {
            throw new IllegalArgumentException("Ip Blocks list size must be greater than zero");
        }
        this.type = ipBlocks.get(0).getType();
        if (ipBlocks.stream().anyMatch(block -> !block.getType().equals(this.type))) {
            throw new IllegalArgumentException("All Ip Blocks must have the same type for a combined block");
        }
        this.ipBlocks = ipBlocks;
        this.hitProbability = new int[this.ipBlocks.size()];
        BigInteger count = BigInteger.ZERO;
        for (IpBlock ipBlock : ipBlocks) {
            count = count.add(ipBlock.getSize());
        }
        this.size = count;
        this.lock = new ReentrantLock();
        this.calculateHitProbabilities();
    }

    private void calculateHitProbabilities() {
        BigDecimal size = new BigDecimal(this.size);
        BigInteger sizeMultiplicator = BigInteger.valueOf(Integer.MAX_VALUE);
        for (int i = 0; i < this.ipBlocks.size(); ++i) {
            IpBlock ipBlock = this.ipBlocks.get(i);
            BigInteger calcSize = ipBlock.getSize().multiply(sizeMultiplicator);
            BigDecimal probability = new BigDecimal(calcSize).divide(size, 4);
            this.hitProbability[i] = probability.intValue();
        }
    }

    public InetAddress getRandomAddress() {
        if (this.ipBlocks.size() == 1) {
            return this.ipBlocks.get(0).getRandomAddress();
        }
        int probability = random.nextInt(Integer.MAX_VALUE);
        int probabilitySum = 0;
        int matchIndex = 0;
        for (int i = 0; i < this.hitProbability.length; ++i) {
            if (this.hitProbability[i] > probability - probabilitySum) {
                matchIndex = i;
                break;
            }
            probabilitySum += this.hitProbability[i];
        }
        return this.ipBlocks.get(matchIndex).getRandomAddress();
    }

    public InetAddress getAddressAtIndex(BigInteger index) {
        for (int blockIndex = 0; index.compareTo(BigInteger.ZERO) > 0 && this.ipBlocks.size() > blockIndex; ++blockIndex) {
            IpBlock ipBlock = this.ipBlocks.get(blockIndex);
            if (ipBlock.getSize().compareTo(index) > 0) {
                return ipBlock.getAddressAtIndex(index);
            }
            index = index.subtract(ipBlock.getSize());
        }
        throw new IllegalArgumentException("Index out of bounds for the CombinedBlock");
    }

    public Class getType() {
        return this.type;
    }

    @Override
    public BigInteger getSize() {
        return this.size;
    }

    @Override
    public int getMaskBits() {
        int[] bits = new int[this.getType().equals(Inet6Address.class) ? 128 : 32];
        int maskBits = bits.length;
        try {
            this.lock.lockInterruptibly();
            for (IpBlock ipBlock : this.ipBlocks) {
                int blockMaskBits = ipBlock.getMaskBits();
                int bitsAtIndex = bits[blockMaskBits - 1];
                bits[blockMaskBits - 1] = bitsAtIndex + 1;
            }
            this.lock.unlock();
            for (int i = bits.length - 1; i > 0; --i) {
                int bitsAtIndex = bits[i];
                int nextSize = bitsAtIndex / 2;
                bits[i] = bitsAtIndex - nextSize * 2;
                bits[i - 1] = bits[i - 1] + nextSize;
                if (bits[i - 1] <= 0) continue;
                maskBits = i;
            }
            return maskBits;
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Could not acquire lock", ex);
        }
    }
}

