/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools.io;

import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.http.ExtendedHttpClientBuilder;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.tools.io.ThreadLocalHttpInterfaceManager;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientTools {
    private static final Logger log = LoggerFactory.getLogger(HttpClientTools.class);
    public static final RequestConfig DEFAULT_REQUEST_CONFIG = RequestConfig.custom().setConnectTimeout(3000).setCookieSpec("standard").build();
    private static final RequestConfig NO_COOKIES_REQUEST_CONFIG = RequestConfig.custom().setConnectTimeout(3000).setCookieSpec("ignoreCookies").build();

    public static HttpClientBuilder createSharedCookiesHttpBuilder() {
        return HttpClientTools.createHttpBuilder(DEFAULT_REQUEST_CONFIG);
    }

    public static HttpInterfaceManager createDefaultThreadLocalManager() {
        return new ThreadLocalHttpInterfaceManager(HttpClientTools.createSharedCookiesHttpBuilder(), DEFAULT_REQUEST_CONFIG);
    }

    public static HttpInterfaceManager createCookielessThreadLocalManager() {
        return new ThreadLocalHttpInterfaceManager(HttpClientTools.createHttpBuilder(NO_COOKIES_REQUEST_CONFIG), NO_COOKIES_REQUEST_CONFIG);
    }

    private static HttpClientBuilder createHttpBuilder(RequestConfig requestConfig) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        return new ExtendedHttpClientBuilder().setDefaultCookieStore((CookieStore)cookieStore).setRetryHandler((HttpRequestRetryHandler)NoResponseRetryHandler.RETRY_INSTANCE).setDefaultRequestConfig(requestConfig);
    }

    public static String getRedirectLocation(String requestUrl, HttpResponse response) {
        if (!HttpClientTools.isRedirectStatus(response.getStatusLine().getStatusCode())) {
            return null;
        }
        Header header = response.getFirstHeader("Location");
        if (header == null) {
            return null;
        }
        String location = header.getValue();
        try {
            return new URI(requestUrl).resolve(location).toString();
        }
        catch (URISyntaxException e) {
            log.debug("Failed to parse URI.", (Throwable)e);
            return location;
        }
    }

    private static boolean isRedirectStatus(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSuccessWithContent(int statusCode) {
        return statusCode == 200 || statusCode == 206 || statusCode == 203;
    }

    public static void assertSuccessWithContent(HttpResponse response, String context) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (!HttpClientTools.isSuccessWithContent(statusCode)) {
            throw new IOException("Invalid status code for " + context + ": " + statusCode);
        }
    }

    public static void assertSuccessWithRedirectContent(HttpResponse response, String context) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (!HttpClientTools.isRedirectStatus(statusCode)) {
            throw new IOException("Invalid status code for " + context + ": " + statusCode);
        }
    }

    public static String getRawContentType(HttpResponse response) {
        Header header = response.getFirstHeader("Content-Type");
        return header != null ? header.getValue() : null;
    }

    public static boolean hasJsonContentType(HttpResponse response) {
        String contentType = HttpClientTools.getRawContentType(response);
        return contentType != null && contentType.startsWith(ContentType.APPLICATION_JSON.getMimeType());
    }

    public static void assertJsonContentType(HttpResponse response) throws IOException {
        if (!HttpClientTools.hasJsonContentType(response)) {
            throw ExceptionTools.throwWithDebugInfo(log, null, "Expected JSON content type, got " + HttpClientTools.getRawContentType(response), "responseContent", EntityUtils.toString((HttpEntity)response.getEntity()));
        }
    }

    public static boolean isRetriableNetworkException(Throwable exception) {
        return HttpClientTools.isConnectionResetException(exception) || HttpClientTools.isSocketTimeoutException(exception) || HttpClientTools.isIncorrectSslShutdownException(exception) || HttpClientTools.isPrematureEndException(exception) || HttpClientTools.isRetriableConscryptException(exception) || HttpClientTools.isRetriableNestedSslException(exception);
    }

    public static boolean isConnectionResetException(Throwable exception) {
        return (exception instanceof SocketException || exception instanceof SSLException) && "Connection reset".equals(exception.getMessage());
    }

    private static boolean isSocketTimeoutException(Throwable exception) {
        return (exception instanceof SocketTimeoutException || exception instanceof SSLException) && "Read timed out".equals(exception.getMessage());
    }

    private static boolean isIncorrectSslShutdownException(Throwable exception) {
        return exception instanceof SSLException && "SSL peer shut down incorrectly".equals(exception.getMessage());
    }

    private static boolean isPrematureEndException(Throwable exception) {
        return exception instanceof ConnectionClosedException && exception.getMessage() != null && exception.getMessage().startsWith("Premature end of Content-Length");
    }

    private static boolean isRetriableConscryptException(Throwable exception) {
        String message;
        if (exception instanceof SSLException && (message = exception.getMessage()) != null && message.contains("I/O error during system call")) {
            return message.contains("No error") || message.contains("Connection reset by peer") || message.contains("Connection timed out");
        }
        return false;
    }

    private static boolean isRetriableNestedSslException(Throwable exception) {
        return exception instanceof SSLException && HttpClientTools.isRetriableNetworkException(exception.getCause());
    }

    public static JsonBrowser fetchResponseAsJson(HttpInterface httpInterface, HttpUriRequest request) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                JsonBrowser jsonBrowser = null;
                return jsonBrowser;
            }
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new FriendlyException("Server responded with an error.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Response code from channel info is " + statusCode));
            }
            JsonBrowser jsonBrowser = JsonBrowser.parse(response.getEntity().getContent());
            return jsonBrowser;
        }
    }

    public static String[] fetchResponseLines(HttpInterface httpInterface, HttpUriRequest request, String name) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new IOException("Unexpected response code " + statusCode + " from " + name);
            }
            String[] stringArray = DataFormatTools.streamToLines(response.getEntity().getContent(), StandardCharsets.UTF_8);
            return stringArray;
        }
    }

    public static String getHeaderValue(HttpResponse response, String name) {
        Header header = response.getFirstHeader(name);
        return header != null ? header.getValue() : null;
    }

    private static class NoResponseRetryHandler
    extends DefaultHttpRequestRetryHandler {
        private static final NoResponseRetryHandler RETRY_INSTANCE = new NoResponseRetryHandler();

        private NoResponseRetryHandler() {
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            boolean retry = super.retryRequest(exception, executionCount, context);
            if (!retry && exception instanceof NoHttpResponseException && executionCount < 5) {
                return true;
            }
            return retry;
        }
    }

    public static class NoRedirectsStrategy
    implements RedirectStrategy {
        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) {
            return false;
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) {
            return null;
        }
    }
}

