/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.mpeg.reader.standard;

import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegFileTrackProvider;
import com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegReader;
import com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegVersionedSectionInfo;
import com.sedmelluq.discord.lavaplayer.tools.io.DetachedByteChannel;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MpegStandardFileTrackProvider
implements MpegFileTrackProvider {
    private final MpegReader reader;
    private final List<TrackSeekInfoBuilder> builders = new ArrayList<TrackSeekInfoBuilder>();
    private final Map<Integer, Integer> trackTimescales = new HashMap<Integer, Integer>();
    private int timescale;
    private int currentChunk;
    private MpegTrackConsumer consumer;
    private TrackSeekInfo seekInfo;

    public MpegStandardFileTrackProvider(MpegReader reader) {
        this.reader = reader;
        this.currentChunk = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initialise(MpegTrackConsumer consumer) {
        this.consumer = consumer;
        int trackId = consumer.getTrack().trackId;
        if (!this.trackTimescales.containsKey(trackId)) {
            return false;
        }
        try {
            for (TrackSeekInfoBuilder builder : this.builders) {
                if (builder.trackId != trackId) continue;
                this.seekInfo = builder.build();
                this.timescale = this.trackTimescales.get(trackId);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.builders.clear();
        }
        return false;
    }

    @Override
    public long getDuration() {
        return this.seekInfo.totalDuration * 1000L / (long)this.timescale;
    }

    @Override
    public void provideFrames() throws InterruptedException {
        try (DetachedByteChannel channel = new DetachedByteChannel(Channels.newChannel(this.reader.seek));){
            while (this.currentChunk < this.seekInfo.chunkOffsets.length) {
                this.reader.seek.seek(this.seekInfo.chunkOffsets[this.currentChunk]);
                int[] samples = this.seekInfo.chunkSamples[this.currentChunk];
                for (int i = 0; i < samples.length; ++i) {
                    this.consumer.consume(channel, samples[i]);
                }
                ++this.currentChunk;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void seekToTimecode(long timecode) {
        long scaledTimecode = timecode * (long)this.timescale / 1000L;
        int length = this.seekInfo.chunkOffsets.length;
        if (scaledTimecode >= this.seekInfo.totalDuration) {
            this.currentChunk = length;
            this.consumer.seekPerformed(timecode, this.seekInfo.totalDuration * 1000L / (long)this.timescale);
        } else {
            for (int i = 0; i < length; ++i) {
                long nextTimecode;
                long l = nextTimecode = i < length - 1 ? this.seekInfo.chunkTimecodes[i + 1] : this.seekInfo.totalDuration;
                if (scaledTimecode >= nextTimecode) continue;
                this.consumer.seekPerformed(timecode, this.seekInfo.chunkTimecodes[i] * 1000L / (long)this.timescale);
                this.currentChunk = i;
                break;
            }
        }
    }

    public void readMediaHeaders(MpegVersionedSectionInfo mdhd, int trackId) throws IOException {
        int trackTimescale;
        if (mdhd.version == 1) {
            this.reader.data.readLong();
            this.reader.data.readLong();
            trackTimescale = this.reader.data.readInt();
            this.reader.data.readLong();
        } else {
            this.reader.data.readInt();
            this.reader.data.readInt();
            trackTimescale = this.reader.data.readInt();
            this.reader.data.readInt();
        }
        this.trackTimescales.put(trackId, trackTimescale);
    }

    public void attachSampleTableParsers(MpegReader.Chain sampleTableChain, int trackId) {
        TrackSeekInfoBuilder seekInfoBuilder = new TrackSeekInfoBuilder(trackId);
        sampleTableChain.handleVersioned("stts", stts -> this.parseTimeToSample(seekInfoBuilder)).handleVersioned("stsc", stsc -> this.parseSampleToChunk(seekInfoBuilder)).handleVersioned("stsz", stsz -> this.parseSampleSizes(seekInfoBuilder)).handleVersioned("stco", stco -> this.parseChunkOffsets32(seekInfoBuilder)).handleVersioned("co64", co64 -> this.parseChunkOffsets64(seekInfoBuilder));
        this.builders.add(seekInfoBuilder);
    }

    private void parseTimeToSample(TrackSeekInfoBuilder seekInfoBuilder) throws IOException {
        int entries = this.reader.data.readInt();
        TrackSeekInfoBuilder.access$702(seekInfoBuilder, new int[entries]);
        TrackSeekInfoBuilder.access$802(seekInfoBuilder, new int[entries]);
        seekInfoBuilder.presence |= 1;
        for (int i = 0; i < entries; ++i) {
            ((TrackSeekInfoBuilder)seekInfoBuilder).sampleTimeCounts[i] = this.reader.data.readInt();
            ((TrackSeekInfoBuilder)seekInfoBuilder).sampleTimeDeltas[i] = this.reader.data.readInt();
        }
    }

    private void parseSampleToChunk(TrackSeekInfoBuilder seekInfoBuilder) throws IOException {
        int entries = this.reader.data.readInt();
        TrackSeekInfoBuilder.access$1002(seekInfoBuilder, new int[entries]);
        TrackSeekInfoBuilder.access$1102(seekInfoBuilder, new int[entries]);
        seekInfoBuilder.presence |= 2;
        for (int i = 0; i < entries; ++i) {
            ((TrackSeekInfoBuilder)seekInfoBuilder).sampleChunkingFirst[i] = this.reader.data.readInt();
            ((TrackSeekInfoBuilder)seekInfoBuilder).sampleChunkingCount[i] = this.reader.data.readInt();
            this.reader.data.readInt();
        }
    }

    private void parseSampleSizes(TrackSeekInfoBuilder seekInfoBuilder) throws IOException {
        seekInfoBuilder.sampleSize = this.reader.data.readInt();
        seekInfoBuilder.sampleCount = this.reader.data.readInt();
        seekInfoBuilder.presence |= 4;
        if (seekInfoBuilder.sampleSize == 0) {
            TrackSeekInfoBuilder.access$1402(seekInfoBuilder, new int[seekInfoBuilder.sampleCount]);
            for (int i = 0; i < seekInfoBuilder.sampleCount; ++i) {
                ((TrackSeekInfoBuilder)seekInfoBuilder).sampleSizes[i] = this.reader.data.readInt();
            }
        }
    }

    private void parseChunkOffsets32(TrackSeekInfoBuilder seekInfoBuilder) throws IOException {
        int chunks = this.reader.data.readInt();
        TrackSeekInfoBuilder.access$1502(seekInfoBuilder, new long[chunks]);
        seekInfoBuilder.presence |= 8;
        for (int i = 0; i < chunks; ++i) {
            ((TrackSeekInfoBuilder)seekInfoBuilder).chunkOffsets[i] = this.reader.data.readInt();
        }
    }

    private void parseChunkOffsets64(TrackSeekInfoBuilder seekInfoBuilder) throws IOException {
        int chunks = this.reader.data.readInt();
        TrackSeekInfoBuilder.access$1502(seekInfoBuilder, new long[chunks]);
        seekInfoBuilder.presence |= 8;
        for (int i = 0; i < chunks; ++i) {
            ((TrackSeekInfoBuilder)seekInfoBuilder).chunkOffsets[i] = this.reader.data.readLong();
        }
    }

    private static class SampleDurationIterator {
        private final int[] sampleTimeCounts;
        private final int[] sampleTimeDeltas;
        private int relativeSampleIndex = 0;
        private int entryIndex = 0;

        private SampleDurationIterator(int[] sampleTimeCounts, int[] sampleTimeDeltas) {
            this.sampleTimeCounts = sampleTimeCounts;
            this.sampleTimeDeltas = sampleTimeDeltas;
        }

        private int nextSampleDuration() {
            int result = this.sampleTimeDeltas[this.entryIndex];
            if (this.entryIndex + 1 < this.sampleTimeCounts.length && ++this.relativeSampleIndex >= this.sampleTimeCounts[this.entryIndex]) {
                ++this.entryIndex;
            }
            return result;
        }
    }

    private static class SampleChunkingIterator {
        private final int[] sampleChunkingFirst;
        private final int[] sampleChunkingCount;
        private int chunkIndex = 1;
        private int entryIndex = 0;

        private SampleChunkingIterator(int[] sampleChunkingFirst, int[] sampleChunkingCount) {
            this.sampleChunkingFirst = sampleChunkingFirst;
            this.sampleChunkingCount = sampleChunkingCount;
        }

        private int nextSampleCount() {
            int result = this.sampleChunkingCount[this.entryIndex];
            ++this.chunkIndex;
            if (this.entryIndex + 1 < this.sampleChunkingFirst.length && this.chunkIndex == this.sampleChunkingFirst[this.entryIndex + 1]) {
                ++this.entryIndex;
            }
            return result;
        }
    }

    private static class TrackSeekInfoBuilder {
        private final int trackId;
        private int presence;
        private int[] sampleTimeCounts;
        private int[] sampleTimeDeltas;
        private int[] sampleChunkingFirst;
        private int[] sampleChunkingCount;
        private long[] chunkOffsets;
        private int sampleSize;
        private int sampleCount;
        private int[] sampleSizes;

        private TrackSeekInfoBuilder(int trackId) {
            this.trackId = trackId;
        }

        private TrackSeekInfo build() {
            if (this.presence != 15) {
                return null;
            }
            long[] chunkTimecodes = new long[this.chunkOffsets.length];
            int[][] chunkSamples = new int[this.chunkOffsets.length][];
            SampleChunkingIterator chunkingIterator = new SampleChunkingIterator(this.sampleChunkingFirst, this.sampleChunkingCount);
            SampleDurationIterator durationIterator = new SampleDurationIterator(this.sampleTimeCounts, this.sampleTimeDeltas);
            int sampleOffset = 0;
            long timeOffset = 0L;
            for (int chunk = 0; chunk < this.chunkOffsets.length; ++chunk) {
                int chunkSampleCount = chunkingIterator.nextSampleCount();
                chunkSamples[chunk] = TrackSeekInfoBuilder.buildChunkSampleSizes(chunkSampleCount, sampleOffset, this.sampleSize, this.sampleSizes);
                chunkTimecodes[chunk] = timeOffset;
                timeOffset += (long)TrackSeekInfoBuilder.calculateChunkDuration(chunkSampleCount, durationIterator);
                sampleOffset += chunkSampleCount;
            }
            return new TrackSeekInfo(timeOffset, this.chunkOffsets, chunkTimecodes, chunkSamples);
        }

        private static int[] buildChunkSampleSizes(int sampleCount, int sampleOffset, int sampleSize, int[] sampleSizes) {
            int[] chunkSampleSizes = new int[sampleCount];
            if (sampleSize != 0) {
                for (int i = 0; i < sampleCount; ++i) {
                    chunkSampleSizes[i] = sampleSize;
                }
            } else {
                System.arraycopy(sampleSizes, sampleOffset, chunkSampleSizes, 0, sampleCount);
            }
            return chunkSampleSizes;
        }

        private static int calculateChunkDuration(int sampleCount, SampleDurationIterator durationIterator) {
            int duration = 0;
            for (int i = 0; i < sampleCount; ++i) {
                duration += durationIterator.nextSampleDuration();
            }
            return duration;
        }

        static /* synthetic */ int[] access$702(TrackSeekInfoBuilder x0, int[] x1) {
            x0.sampleTimeCounts = x1;
            return x1;
        }

        static /* synthetic */ int[] access$802(TrackSeekInfoBuilder x0, int[] x1) {
            x0.sampleTimeDeltas = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1002(TrackSeekInfoBuilder x0, int[] x1) {
            x0.sampleChunkingFirst = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1102(TrackSeekInfoBuilder x0, int[] x1) {
            x0.sampleChunkingCount = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1402(TrackSeekInfoBuilder x0, int[] x1) {
            x0.sampleSizes = x1;
            return x1;
        }

        static /* synthetic */ long[] access$1502(TrackSeekInfoBuilder x0, long[] x1) {
            x0.chunkOffsets = x1;
            return x1;
        }
    }

    private static class TrackSeekInfo {
        private final long totalDuration;
        private final long[] chunkOffsets;
        private final long[] chunkTimecodes;
        private final int[][] chunkSamples;

        private TrackSeekInfo(long totalDuration, long[] chunkOffsets, long[] chunkTimecodes, int[][] chunkSamples) {
            this.totalDuration = totalDuration;
            this.chunkOffsets = chunkOffsets;
            this.chunkTimecodes = chunkTimecodes;
            this.chunkSamples = chunkSamples;
        }
    }
}

