/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.matroska;

import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaBlock;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaCuePoint;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaElement;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaElementType;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaFileReader;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaFileTrack;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MatroskaStreamingFile {
    private final MatroskaFileReader reader;
    private String title;
    private String artist;
    private long timecodeScale = 1000000L;
    private double duration;
    private final ArrayList<MatroskaFileTrack> trackList = new ArrayList();
    private MatroskaElement segmentElement = null;
    private MatroskaElement firstClusterElement = null;
    private long minimumTimecode = 0L;
    private boolean seeking = false;
    private Long cueElementPosition = null;
    private List<MatroskaCuePoint> cuePoints = null;

    public MatroskaStreamingFile(SeekableInputStream inputStream) {
        this.reader = new MatroskaFileReader(inputStream);
    }

    public long getTimecodeScale() {
        return this.timecodeScale;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public double getDuration() {
        return this.duration;
    }

    public MatroskaFileTrack[] getTrackList() {
        if (!this.trackList.isEmpty()) {
            MatroskaFileTrack[] tracks = new MatroskaFileTrack[this.trackList.size()];
            for (int t = 0; t < this.trackList.size(); ++t) {
                tracks[t] = this.trackList.get(t);
            }
            return tracks;
        }
        return new MatroskaFileTrack[0];
    }

    public void readFile() throws IOException {
        MatroskaElement ebmlElement = this.reader.readNextElement(null);
        if (ebmlElement == null) {
            throw new RuntimeException("Unable to scan for EBML elements");
        }
        if (!ebmlElement.is(MatroskaElementType.Ebml)) {
            throw new RuntimeException("EBML Header not the first element in the file");
        }
        this.parseEbmlElement(ebmlElement);
        this.segmentElement = this.reader.readNextElement(null).frozen();
        if (!this.segmentElement.is(MatroskaElementType.Segment)) {
            throw new RuntimeException(String.format("Segment not the second element in the file: was %s (%d) instead", this.segmentElement.getType().name(), this.segmentElement.getId()));
        }
        this.parseSegmentElement(this.segmentElement);
    }

    private void parseEbmlElement(MatroskaElement ebmlElement) throws IOException {
        MatroskaElement child;
        while ((child = this.reader.readNextElement(ebmlElement)) != null) {
            String docType;
            if (child.is(MatroskaElementType.DocType) && (docType = this.reader.asString(child)).compareTo("matroska") != 0 && docType.compareTo("webm") != 0) {
                throw new RuntimeException("Error: DocType is not matroska, \"" + docType + "\"");
            }
            this.reader.skip(child);
        }
    }

    private void parseSegmentElement(MatroskaElement segmentElement) throws IOException {
        MatroskaElement child;
        while ((child = this.reader.readNextElement(segmentElement)) != null) {
            if (child.is(MatroskaElementType.Info)) {
                this.parseSegmentInfo(child);
            } else if (child.is(MatroskaElementType.Tags)) {
                this.parseTags(child);
            } else if (child.is(MatroskaElementType.Tracks)) {
                this.parseTracks(child);
            } else {
                if (child.is(MatroskaElementType.Cluster)) {
                    this.firstClusterElement = child.frozen();
                    break;
                }
                if (child.is(MatroskaElementType.SeekHead)) {
                    this.parseSeekInfoForCuePosition(child);
                } else if (child.is(MatroskaElementType.Cues)) {
                    this.cuePoints = this.parseCues(child);
                }
            }
            this.reader.skip(child);
        }
    }

    private void parseSeekInfoForCuePosition(MatroskaElement seekHeadElement) throws IOException {
        MatroskaElement child;
        while ((child = this.reader.readNextElement(seekHeadElement)) != null) {
            if (child.is(MatroskaElementType.Seek)) {
                this.parseSeekElement(child);
            }
            this.reader.skip(child);
        }
    }

    private void parseSeekElement(MatroskaElement seekElement) throws IOException {
        MatroskaElement child;
        boolean isCueElement = false;
        while ((child = this.reader.readNextElement(seekElement)) != null) {
            if (child.is(MatroskaElementType.SeekId)) {
                isCueElement = ByteBuffer.wrap(this.reader.asBytes(child)).equals(ByteBuffer.wrap(MatroskaElementType.Cues.bytes));
            } else if (child.is(MatroskaElementType.SeekPosition) && isCueElement) {
                this.cueElementPosition = this.reader.asLong(child);
            }
            this.reader.skip(child);
        }
    }

    private List<MatroskaCuePoint> parseCues(MatroskaElement cuesElement) throws IOException {
        MatroskaElement child;
        ArrayList<MatroskaCuePoint> parsedCuePoints = new ArrayList<MatroskaCuePoint>();
        while ((child = this.reader.readNextElement(cuesElement)) != null) {
            MatroskaCuePoint cuePoint;
            if (child.is(MatroskaElementType.CuePoint) && (cuePoint = this.parseCuePoint(child)) != null) {
                parsedCuePoints.add(cuePoint);
            }
            this.reader.skip(child);
        }
        return parsedCuePoints.isEmpty() ? null : parsedCuePoints;
    }

    private MatroskaCuePoint parseCuePoint(MatroskaElement cuePointElement) throws IOException {
        MatroskaElement child;
        Long cueTime = null;
        long[] positions = null;
        while ((child = this.reader.readNextElement(cuePointElement)) != null) {
            if (child.is(MatroskaElementType.CueTime)) {
                cueTime = this.reader.asLong(child);
            } else if (child.is(MatroskaElementType.CueTrackPositions)) {
                positions = this.parseCueTrackPositions(child);
            }
            this.reader.skip(child);
        }
        if (cueTime != null && positions != null) {
            return new MatroskaCuePoint(cueTime, positions);
        }
        return null;
    }

    private long[] parseCueTrackPositions(MatroskaElement positionsElement) throws IOException {
        MatroskaElement child;
        Long currentTrackId = null;
        long[] positions = new long[this.trackList.size() + 1];
        Arrays.fill(positions, -1L);
        while ((child = this.reader.readNextElement(positionsElement)) != null) {
            if (child.is(MatroskaElementType.CueTrack)) {
                currentTrackId = this.reader.asLong(child);
            } else if (child.is(MatroskaElementType.CueClusterPosition) && currentTrackId != null) {
                positions[currentTrackId.intValue()] = this.reader.asLong(child);
            }
            this.reader.skip(child);
        }
        return positions;
    }

    public void seekToTimecode(int trackId, long timecode) {
        try {
            this.seekToTimecodeInternal(trackId, timecode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void seekToTimecodeInternal(int trackId, long timecode) throws IOException {
        MatroskaCuePoint cuePoint;
        this.minimumTimecode = timecode;
        this.seeking = true;
        if (this.cuePoints == null && this.cueElementPosition != null) {
            this.reader.seek(this.segmentElement.getDataPosition() + this.cueElementPosition);
            MatroskaElement cuesElement = this.reader.readNextElement(this.segmentElement);
            if (!cuesElement.is(MatroskaElementType.Cues)) {
                throw new IllegalStateException("The element here should be cue.");
            }
            this.cuePoints = this.parseCues(cuesElement);
        }
        if (this.cuePoints != null && (cuePoint = this.lastCueNotAfterTimecode(timecode)) != null && cuePoint.trackClusterOffsets[trackId] >= 0L) {
            this.reader.seek(this.segmentElement.getDataPosition() + cuePoint.trackClusterOffsets[trackId]);
            return;
        }
        this.reader.seek(this.firstClusterElement.getPosition());
    }

    private MatroskaCuePoint lastCueNotAfterTimecode(long timecode) {
        int largerTimecodeIndex;
        for (largerTimecodeIndex = 0; largerTimecodeIndex < this.cuePoints.size() && this.cuePoints.get((int)largerTimecodeIndex).timecode <= timecode; ++largerTimecodeIndex) {
        }
        if (largerTimecodeIndex > 0) {
            return this.cuePoints.get(largerTimecodeIndex - 1);
        }
        return null;
    }

    public void provideFrames(MatroskaTrackConsumer consumer) throws InterruptedException {
        try {
            MatroskaElement child;
            long position = this.reader.getPosition();
            MatroskaElement matroskaElement = child = position == this.firstClusterElement.getDataPosition() ? this.firstClusterElement : this.reader.readNextElement(this.segmentElement);
            while (child != null) {
                if (child.is(MatroskaElementType.Cluster)) {
                    this.parseNextCluster(child, consumer);
                }
                this.reader.skip(child);
                if (this.segmentElement.getRemaining(this.reader.getPosition()) > 0L) {
                    child = this.reader.readNextElement(this.segmentElement);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void parseNextCluster(MatroskaElement clusterElement, MatroskaTrackConsumer consumer) throws InterruptedException, IOException {
        MatroskaElement child;
        long clusterTimecode = 0L;
        while ((child = this.reader.readNextElement(clusterElement)) != null) {
            if (child.is(MatroskaElementType.Timecode)) {
                clusterTimecode = this.reader.asLong(child);
            } else if (child.is(MatroskaElementType.SimpleBlock)) {
                this.parseClusterSimpleBlock(child, consumer, clusterTimecode);
            } else if (child.is(MatroskaElementType.BlockGroup)) {
                this.parseClusterBlockGroup(child, consumer, clusterTimecode);
            }
            this.reader.skip(child);
        }
    }

    private void parseClusterSimpleBlock(MatroskaElement simpleBlock, MatroskaTrackConsumer consumer, long clusterTimecode) throws InterruptedException, IOException {
        MatroskaBlock block = this.reader.readBlockHeader(simpleBlock, consumer.getTrack().index);
        if (block != null) {
            this.processFrameInBlock(block, consumer, clusterTimecode);
        }
    }

    private void parseClusterBlockGroup(MatroskaElement blockGroup, MatroskaTrackConsumer consumer, long clusterTimecode) throws InterruptedException, IOException {
        MatroskaElement child;
        while ((child = this.reader.readNextElement(blockGroup)) != null) {
            MatroskaBlock block;
            if (child.is(MatroskaElementType.Block) && (block = this.reader.readBlockHeader(child, consumer.getTrack().index)) != null) {
                this.processFrameInBlock(block, consumer, clusterTimecode);
            }
            this.reader.skip(child);
        }
    }

    private void processFrameInBlock(MatroskaBlock block, MatroskaTrackConsumer consumer, long clusterTimecode) throws InterruptedException, IOException {
        long timecode = clusterTimecode + (long)block.getTimecode();
        if (timecode >= this.minimumTimecode) {
            int frameCount = block.getFrameCount();
            if (this.seeking) {
                consumer.seekPerformed(this.minimumTimecode, timecode);
                this.seeking = false;
            }
            for (int i = 0; i < frameCount; ++i) {
                consumer.consume(block.getNextFrameBuffer(this.reader, i));
            }
        }
    }

    private void parseSegmentInfo(MatroskaElement infoElement) throws IOException {
        MatroskaElement child;
        while ((child = this.reader.readNextElement(infoElement)) != null) {
            if (child.is(MatroskaElementType.Duration)) {
                this.duration = this.reader.asDouble(child);
            } else if (child.is(MatroskaElementType.TimecodeScale)) {
                this.timecodeScale = this.reader.asLong(child);
            } else if (child.is(MatroskaElementType.Title)) {
                this.title = this.reader.asString(child);
            }
            this.reader.skip(child);
        }
    }

    private void parseTracks(MatroskaElement tracksElement) throws IOException {
        MatroskaElement child;
        while ((child = this.reader.readNextElement(tracksElement)) != null) {
            if (child.is(MatroskaElementType.TrackEntry)) {
                this.trackList.add(MatroskaFileTrack.parse(child, this.reader));
            }
            this.reader.skip(child);
        }
    }

    private void parseTags(MatroskaElement tagsElement) throws IOException {
        MatroskaElement child;
        while ((child = this.reader.readNextElement(tagsElement)) != null) {
            if (child.is(MatroskaElementType.Tag)) {
                this.parseTag(child);
            }
            this.reader.skip(child);
        }
    }

    private void parseTag(MatroskaElement tagElement) throws IOException {
        MatroskaElement child;
        while ((child = this.reader.readNextElement(tagElement)) != null) {
            if (child.is(MatroskaElementType.SimpleTag)) {
                this.parseSimpleTag(child);
            }
            this.reader.skip(child);
        }
    }

    private void parseSimpleTag(MatroskaElement simpleTagElement) throws IOException {
        MatroskaElement child;
        String tagName = null;
        while ((child = this.reader.readNextElement(simpleTagElement)) != null) {
            if (child.is(MatroskaElementType.TagName)) {
                tagName = this.reader.asString(child);
                continue;
            }
            if (!child.is(MatroskaElementType.TagString) || !"artist".equalsIgnoreCase(tagName)) continue;
            this.artist = this.reader.asString(child);
        }
    }
}

