/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.format.transcoder;

import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class PcmChunkDecoder
implements AudioChunkDecoder {
    private final ByteBuffer encodedAsByte;
    private final ShortBuffer encodedAsShort;

    public PcmChunkDecoder(AudioDataFormat format, boolean bigEndian) {
        this.encodedAsByte = ByteBuffer.allocate(format.maximumChunkSize());
        this.encodedAsByte.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        this.encodedAsShort = this.encodedAsByte.asShortBuffer();
    }

    @Override
    public void decode(byte[] encoded, ShortBuffer buffer) {
        buffer.clear();
        this.encodedAsByte.clear();
        this.encodedAsByte.put(encoded);
        this.encodedAsShort.clear();
        this.encodedAsShort.limit(this.encodedAsByte.position() / 2);
        buffer.put(this.encodedAsShort);
        buffer.rewind();
    }

    @Override
    public void close() {
    }
}

