/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.vimeo;

import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.playlists.ExtendedM3uParser;
import com.sedmelluq.discord.lavaplayer.container.playlists.HlsStreamTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.vimeo.VimeoAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VimeoAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(VimeoAudioTrack.class);
    private final VimeoAudioSourceManager sourceManager;

    public VimeoAudioTrack(AudioTrackInfo trackInfo, VimeoAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        block12: {
            try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
                JsonBrowser videoData = this.sourceManager.getVideoFromApi(httpInterface, this.trackInfo.identifier);
                VimeoAudioSourceManager.PlaybackFormat playbackFormat = this.sourceManager.getPlaybackFormat(httpInterface, videoData.get("config_url").text());
                log.debug("Starting Vimeo track. HLS: {}, URL: {}", (Object)playbackFormat.isHls, (Object)playbackFormat.url);
                if (playbackFormat.isHls) {
                    this.processDelegate(new HlsStreamTrack(this.trackInfo, this.extractHlsAudioPlaylistUrl(httpInterface, playbackFormat.url), this.sourceManager.getHttpInterfaceManager(), true), localExecutor);
                    break block12;
                }
                try (PersistentHttpStream stream = new PersistentHttpStream(httpInterface, new URI(playbackFormat.url), null);){
                    this.processDelegate(new MpegAudioTrack(this.trackInfo, stream), localExecutor);
                }
            }
        }
    }

    protected String resolveRelativeUrl(String baseUrl, String url) {
        while (url.startsWith("../")) {
            url = url.substring(3);
            baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf(47));
        }
        return baseUrl + (String)(url.startsWith("/") ? url : "/" + url);
    }

    private String extractHlsAudioPlaylistUrl(HttpInterface httpInterface, String videoPlaylistUrl) throws IOException {
        String url = null;
        try (CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)new HttpGet(videoPlaylistUrl));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new FriendlyException("Server responded with an error.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Response code for track access info is " + statusCode));
            }
            String bodyString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            for (String rawLine : bodyString.split("\n")) {
                ExtendedM3uParser.Line line = ExtendedM3uParser.parseLine(rawLine);
                if (!Objects.equals(line.directiveName, "EXT-X-MEDIA") || !Objects.equals(line.directiveArguments.get("TYPE"), "AUDIO")) continue;
                url = line.directiveArguments.get("URI");
                break;
            }
        }
        if (url == null) {
            throw new FriendlyException("Failed to find audio playlist URL.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Valid audio directive was not found"));
        }
        return this.resolveRelativeUrl(videoPlaylistUrl.substring(0, videoPlaylistUrl.lastIndexOf(47)), url);
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new VimeoAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

