/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpHost;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.protocol.HttpContext;

public class SimpleHttpClientConnectionManager
implements HttpClientConnectionManager {
    private final HttpClientConnectionOperator connectionOperator;
    private final HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connectionFactory;
    private volatile SocketConfig socketConfig = SocketConfig.DEFAULT;
    private volatile ConnectionConfig connectionConfig = ConnectionConfig.DEFAULT;

    public SimpleHttpClientConnectionManager(HttpClientConnectionOperator connectionOperator, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> factory) {
        this.connectionOperator = connectionOperator;
        this.connectionFactory = factory != null ? factory : ManagedHttpClientConnectionFactory.INSTANCE;
    }

    public void setSocketConfig(SocketConfig config) {
        this.socketConfig = config;
    }

    public void setConnectionConfig(ConnectionConfig config) {
        this.connectionConfig = config;
    }

    public ConnectionRequest requestConnection(final HttpRoute route, Object state) {
        return new ConnectionRequest(){

            public boolean cancel() {
                return false;
            }

            public HttpClientConnection get(long timeout, TimeUnit timeUnit) {
                return (HttpClientConnection)SimpleHttpClientConnectionManager.this.connectionFactory.create((Object)route, SimpleHttpClientConnectionManager.this.connectionConfig);
            }
        };
    }

    public void releaseConnection(HttpClientConnection connection, Object newState, long validDuration, TimeUnit timeUnit) {
        try {
            connection.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void connect(HttpClientConnection connection, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
        HttpHost host = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
        InetSocketAddress localAddress = route.getLocalSocketAddress();
        ManagedHttpClientConnection managed = (ManagedHttpClientConnection)connection;
        this.connectionOperator.connect(managed, host, localAddress, connectTimeout, this.socketConfig, context);
    }

    public void upgrade(HttpClientConnection connection, HttpRoute route, HttpContext context) throws IOException {
        ManagedHttpClientConnection managed = (ManagedHttpClientConnection)connection;
        this.connectionOperator.upgrade(managed, route.getTargetHost(), context);
    }

    public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) {
    }

    public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
    }

    public void closeExpiredConnections() {
    }

    public void shutdown() {
    }
}

