/*
 * Decompiled with CFR 0.152.
 */
package dev.aspectj.maven.agent_embedder;

import dev.aspectj.maven.agent_embedder.JavaAgentInfo;
import dev.aspectj.maven.agent_embedder.JavaAgentLauncher;
import dev.aspectj.maven.tools.ZipFileSystemTool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="embed", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class AgentEmbedderMojo
extends AbstractMojo {
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    public static final String HEADER_AGENT_CLASS = "Agent-Class";
    protected FileSystem hostFS = FileSystems.getDefault();
    @Parameter(required=true)
    protected List<JavaAgentInfo> javaAgents;
    @Parameter(required=true, defaultValue="false")
    protected boolean removeEmbeddedAgents;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Component
    protected MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        if (this.javaAgents == null || this.javaAgents.isEmpty()) {
            this.getLog().warn((CharSequence)"List of java agents to embed is empty, skipping execution");
            return;
        }
        String artifactJarLocation = this.adjustPathSeparatorToHostFS(this.project.getArtifact().getFile().getPath(), this.hostFS);
        Path artifactPath = this.hostFS.getPath(artifactJarLocation, new String[0]);
        try (FileSystem jarFS = ZipFileSystemTool.getZipFS(artifactPath, false);){
            if (jarFS == null) {
                throw new MojoExecutionException("Cannot open artifact JAR file");
            }
            this.embedLauncherAgent(jarFS);
            this.getLog().info((CharSequence)"Embedding java agents");
            for (JavaAgentInfo agent : this.javaAgents) {
                String agentJarLocation = this.project.getArtifacts().stream().filter(agent::matchesArtifact).distinct().map(artifact -> this.adjustPathSeparatorToHostFS(artifact.getFile().getPath(), this.hostFS)).findFirst().orElse(agent.getAgentPath());
                if (agentJarLocation == null) {
                    throw new MojoExecutionException("Java agent JAR for " + agent + " not found");
                }
                this.getLog().info((CharSequence)("Processing java agent " + agentJarLocation));
                this.unpackAgentJar(agent, jarFS, agentJarLocation);
            }
            new ManifestUpdater(jarFS).update();
        }
        catch (NoExecutableJarException | IOException e) {
            throw new MojoExecutionException("Error while embedding java agents", e);
        }
    }

    protected void embedLauncherAgent(FileSystem jarFS) throws IOException, MojoExecutionException {
        String agentLauncherClassName = JavaAgentLauncher.class.getName();
        String resourceName = agentLauncherClassName.replace('.', '/') + ".class";
        Path targetPath = jarFS.getPath(resourceName, new String[0]);
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        try (InputStream input = JavaAgentLauncher.class.getClassLoader().getResourceAsStream(resourceName);
             OutputStream output = Files.newOutputStream(targetPath, StandardOpenOption.CREATE);){
            int bytesRead;
            if (input == null) {
                throw new MojoExecutionException("Cannot find/open launcher agent resource '" + resourceName + "'");
            }
            byte[] buffer = new byte[4096];
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
        }
    }

    protected String adjustPathSeparatorToHostFS(String path, FileSystem targetFS) {
        char toSeparator = targetFS.getSeparator().charAt(0);
        char fromSeparator = toSeparator == '/' ? (char)'\\' : '/';
        return path.replace(fromSeparator, toSeparator);
    }

    protected void unpackAgentJar(JavaAgentInfo agentInfo, FileSystem jarFS, String agentPath) throws IOException, MojoExecutionException {
        Stream<Path> files;
        Path agentJarPath = this.hostFS.getPath(agentPath, new String[0]);
        boolean externalJarFound = Files.exists(agentJarPath, new LinkOption[0]);
        Path embeddedAgentJarPath = null;
        if (!(!this.removeEmbeddedAgents && externalJarFound || Files.exists(embeddedAgentJarPath = jarFS.getPath(agentPath, new String[0]), new LinkOption[0]))) {
            Path agentFileName = embeddedAgentJarPath.getFileName();
            files = Files.find(jarFS.getPath("/", new String[0]), Integer.MAX_VALUE, (path, basicFileAttributes) -> path.getNameCount() > 0 && path.getFileName().equals(agentFileName), new FileVisitOption[0]);
            try {
                embeddedAgentJarPath = files.findFirst().orElse(null);
            }
            finally {
                if (files != null) {
                    files.close();
                }
            }
        }
        if (!externalJarFound) {
            agentJarPath = embeddedAgentJarPath;
        }
        Objects.requireNonNull(agentJarPath, "Java agent JAR not found");
        try (FileSystem javaAgentFS = ZipFileSystemTool.getZipFS(agentJarPath, false);){
            Objects.requireNonNull(javaAgentFS);
            this.configureJavaAgentClass(agentInfo, agentJarPath, javaAgentFS);
            try {
                files = Files.find(javaAgentFS.getPath("/", new String[0]), Integer.MAX_VALUE, (path, basicFileAttributes) -> !Files.exists(jarFS.getPath(path.toString(), new String[0]), new LinkOption[0]), new FileVisitOption[0]);
                try {
                    files.forEach(path -> {
                        this.getLog().debug((CharSequence)("Unpacking: " + path));
                        try {
                            Files.copy(path, jarFS.getPath(path.toString(), new String[0]), new CopyOption[0]);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Problem when unpacking java agent JAR", e);
                        }
                    });
                }
                finally {
                    if (files != null) {
                        files.close();
                    }
                }
            }
            catch (RuntimeException e) {
                if ("Problem when unpacking java agent JAR".equals(e.getMessage()) && e.getCause() instanceof IOException) {
                    throw new MojoExecutionException(e.getMessage(), e.getCause());
                }
                throw e;
            }
        }
        if (this.removeEmbeddedAgents && embeddedAgentJarPath != null && Files.exists(embeddedAgentJarPath, new LinkOption[0])) {
            this.getLog().info((CharSequence)("Removing embedded java agent: " + embeddedAgentJarPath));
            Files.delete(embeddedAgentJarPath);
        }
    }

    protected void configureJavaAgentClass(JavaAgentInfo agentInfo, Path agentJarPath, FileSystem javaAgentFS) throws IOException, MojoExecutionException {
        this.getLog().debug((CharSequence)("Configuring java agent class for " + agentInfo));
        this.getLog().debug((CharSequence)("Reading agent manifest from path " + agentJarPath));
        Manifest javaAgentManifest = new Manifest(Files.newInputStream(javaAgentFS.getPath("/META-INF/MANIFEST.MF", new String[0]), new OpenOption[0]));
        String manifestAgentClass = javaAgentManifest.getMainAttributes().getValue(HEADER_AGENT_CLASS);
        manifestAgentClass = manifestAgentClass == null ? "" : manifestAgentClass.trim();
        this.getLog().debug((CharSequence)("Agent class from manifest: " + manifestAgentClass));
        agentInfo.setAgentClass(agentInfo.getAgentClass() == null ? "" : agentInfo.getAgentClass().trim());
        this.getLog().debug((CharSequence)("Agent class from plugin configuration: " + agentInfo.getAgentClass()));
        if (manifestAgentClass.isEmpty()) {
            if (agentInfo.getAgentClass().isEmpty()) {
                throw new MojoExecutionException("Agent class for " + agentInfo + " neither configured nor found in agent manifest");
            }
            this.getLog().warn((CharSequence)("Agent class name not found in agent manifest, using configured value '" + agentInfo.getAgentClass() + "'. Attention: JAR does not seem to be a regular java agent."));
        } else if (agentInfo.getAgentClass().isEmpty()) {
            this.getLog().debug((CharSequence)("Using agent class '" + manifestAgentClass + "' found in manifest"));
            agentInfo.setAgentClass(manifestAgentClass);
        } else {
            this.getLog().debug((CharSequence)("Using agent class '" + agentInfo.getAgentClass() + "' found in plugin configuration"));
        }
    }

    public class ManifestUpdater {
        public static final String MANIFEST_HEADER_MAIN_CLASS = "Main-Class";
        public static final String MANIFEST_HEADER_LAUNCHER_AGENT = "Launcher-Agent-Class";
        private final Path manifestPath;
        private final Manifest manifest;

        public ManifestUpdater(FileSystem fileSystem) throws IOException, NoExecutableJarException {
            this.manifestPath = fileSystem.getPath(AgentEmbedderMojo.MANIFEST_PATH, new String[0]);
            this.manifest = this.getExecutableJarManifest();
        }

        private Manifest getExecutableJarManifest() throws IOException, NoExecutableJarException {
            if (!Files.exists(this.manifestPath, new LinkOption[0])) {
                throw new NoExecutableJarException("missing manifest file 'META-INF/MANIFEST.MF'");
            }
            Manifest manifest = new Manifest();
            try (InputStream inputStream = Files.newInputStream(this.manifestPath, new OpenOption[0]);){
                manifest.read(inputStream);
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            if (mainAttributes.getValue(MANIFEST_HEADER_MAIN_CLASS) == null) {
                throw new NoExecutableJarException("missing manifest attribute 'Main-Class'");
            }
            return manifest;
        }

        public void update() throws IOException {
            this.addLauncherAgentAttribute();
            this.addEmbeddedAgentAttributes();
            this.writeManifest();
        }

        private void addLauncherAgentAttribute() {
            Attributes mainAttributes = this.manifest.getMainAttributes();
            String existingLauncherAgent = mainAttributes.getValue(MANIFEST_HEADER_LAUNCHER_AGENT);
            if (existingLauncherAgent != null) {
                AgentEmbedderMojo.this.getLog().warn((CharSequence)("Overwriting existing manifest attribute 'Launcher-Agent-Class: " + existingLauncherAgent + "'"));
            }
            AgentEmbedderMojo.this.getLog().debug((CharSequence)("Setting manifest attribute 'Launcher-Agent-Class: " + JavaAgentLauncher.class.getName() + "'"));
            mainAttributes.putValue(MANIFEST_HEADER_LAUNCHER_AGENT, JavaAgentLauncher.class.getName());
        }

        private void addEmbeddedAgentAttributes() {
            Attributes agentAttributes = new Attributes();
            agentAttributes.putValue("Agent-Count", String.valueOf(AgentEmbedderMojo.this.javaAgents.size()));
            int agentIndex = 0;
            for (JavaAgentInfo agent : AgentEmbedderMojo.this.javaAgents) {
                agentAttributes.putValue("Agent-Class-" + ++agentIndex, agent.getAgentClass());
                if (agent.getAgentArgs() == null) continue;
                agentAttributes.putValue("Agent-Args-" + agentIndex, agent.getAgentArgs());
            }
            this.manifest.getEntries().put("dev/aspectj/agent-embedder", agentAttributes);
        }

        private void writeManifest() throws IOException {
            Files.delete(this.manifestPath);
            try (OutputStream manifestOut = Files.newOutputStream(this.manifestPath, new OpenOption[0]);){
                this.manifest.write(manifestOut);
            }
        }
    }

    public static class NoExecutableJarException
    extends Exception {
        private static final String ERROR_MESSAGE = "Target JAR is not executable. Reason: %s. Therefore, it does not make sense to embed any java agents.";

        public NoExecutableJarException(String reason) {
            super(String.format(ERROR_MESSAGE, reason));
        }
    }
}

