/*
 * Decompiled with CFR 0.152.
 */
package dev.aspectj.maven.agent_embedder;

import java.util.Objects;
import org.apache.maven.artifact.Artifact;

public class JavaAgentInfo {
    private String groupId;
    private String artifactId;
    private String classifier;
    private String agentClass;
    private String agentArgs;
    private String agentPath;

    public JavaAgentInfo() {
    }

    public JavaAgentInfo(String groupId, String artifactId, String classifier, String agentClass, String agentArgs, String agentPath) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier;
        this.agentClass = agentClass;
        this.agentArgs = agentArgs;
        this.agentPath = agentPath;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return "jar";
    }

    public String getAgentClass() {
        return this.agentClass;
    }

    public void setAgentClass(String agentClass) {
        this.agentClass = agentClass;
    }

    public String getAgentArgs() {
        return this.agentArgs;
    }

    public String getAgentPath() {
        return this.agentPath;
    }

    public boolean matchesArtifact(Artifact artifact) {
        return Objects.equals(this.getType(), artifact.getType()) && Objects.equals(this.getGroupId(), artifact.getGroupId()) && Objects.equals(this.getArtifactId(), artifact.getArtifactId()) && Objects.equals(this.getClassifier(), artifact.getClassifier());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaAgentInfo)) {
            return false;
        }
        JavaAgentInfo javaAgent = (JavaAgentInfo)o;
        return Objects.equals(this.groupId, javaAgent.groupId) && Objects.equals(this.artifactId, javaAgent.artifactId) && Objects.equals(this.classifier, javaAgent.classifier) && Objects.equals(this.agentClass, javaAgent.agentClass) && Objects.equals(this.agentArgs, javaAgent.agentArgs) && Objects.equals(this.agentPath, javaAgent.agentPath);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.classifier, this.agentClass, this.agentArgs, this.agentPath);
    }

    public String toString() {
        return "JavaAgentInfo(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", classifier=" + this.classifier + ", agentClass=" + this.agentClass + ", agentArgs=" + this.agentArgs + ", agentPath=" + this.agentPath + ')';
    }
}

