/*
 * Decompiled with CFR 0.152.
 */
package dev.aspectj.maven.tools;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.nio.file.CopyOption;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipOutputStream;

public class ZipFileSystemTool {
    public static final int JAVA_VERSION_MAJOR = Integer.parseInt(System.getProperty("java.version").split("[.]")[0]);
    private static final Map<String, String> ZIP_FS_CREATE_MODE = Collections.singletonMap("create", "true");
    private static final MethodHandle newFileSystem_JRE13;

    public static FileSystem getZipFS(Path jarPath, boolean create) throws IOException {
        if (!create && !Files.exists(jarPath, new LinkOption[0])) {
            return null;
        }
        Path jarPathParent = jarPath.getParent();
        if (jarPathParent != null) {
            Files.createDirectories(jarPathParent, new FileAttribute[0]);
        }
        if (JAVA_VERSION_MAJOR >= 13) {
            try {
                return newFileSystem_JRE13.invoke(jarPath, ZIP_FS_CREATE_MODE);
            }
            catch (ClassCastException | WrongMethodTypeException thrownByMethodHandlerInvocation) {
                throw thrownByMethodHandlerInvocation;
            }
            catch (IOException | RuntimeException thrownByInvokedMethod) {
                throw thrownByInvokedMethod;
            }
            catch (Throwable unexpected) {
                throw new RuntimeException(unexpected);
            }
        }
        if (JAVA_VERSION_MAJOR == 12) {
            if (!Files.exists(jarPath, new LinkOption[0])) {
                ZipOutputStream emptyZip = new ZipOutputStream(Files.newOutputStream(jarPath, new OpenOption[0]));
                emptyZip.close();
            }
            return FileSystems.newFileSystem(jarPath, (ClassLoader)null);
        }
        return new VirtualNestedZipFileSystem(jarPath);
    }

    static {
        try {
            if (JAVA_VERSION_MAJOR >= 13) {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodType signature = MethodType.methodType(FileSystem.class, Path.class, Map.class);
                newFileSystem_JRE13 = lookup.findStatic(FileSystems.class, "newFileSystem", signature);
            } else {
                newFileSystem_JRE13 = null;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException unexpectedException) {
            throw new RuntimeException("Cannot find method handle. This should never happen, the method should exist on JDK 13+.", unexpectedException);
        }
    }

    public static class VirtualNestedZipFileSystem
    extends FileSystem {
        private Path zipPath;
        private Path tempDir;
        private Path tempFile;
        private FileSystem delegate;

        public VirtualNestedZipFileSystem(Path zipPath) throws IOException {
            this.zipPath = zipPath;
            this.tempDir = Files.createTempDirectory(null, new FileAttribute[0]);
            this.tempFile = this.tempDir.resolve("temp.zip");
            if (Files.exists(zipPath, new LinkOption[0])) {
                Files.copy(zipPath, this.tempFile, new CopyOption[0]);
            } else {
                ZipOutputStream emptyZip = new ZipOutputStream(Files.newOutputStream(this.tempFile, new OpenOption[0]));
                emptyZip.close();
            }
            this.delegate = FileSystems.newFileSystem(this.tempFile, (ClassLoader)null);
        }

        @Override
        public FileSystemProvider provider() {
            return this.delegate.provider();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            Files.move(this.tempFile, this.zipPath, StandardCopyOption.REPLACE_EXISTING);
            Files.delete(this.tempDir);
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public boolean isReadOnly() {
            return this.delegate.isReadOnly();
        }

        @Override
        public String getSeparator() {
            return this.delegate.getSeparator();
        }

        @Override
        public Iterable<Path> getRootDirectories() {
            return this.delegate.getRootDirectories();
        }

        @Override
        public Iterable<FileStore> getFileStores() {
            return this.delegate.getFileStores();
        }

        @Override
        public Set<String> supportedFileAttributeViews() {
            return this.delegate.supportedFileAttributeViews();
        }

        @Override
        public Path getPath(String first, String ... more) {
            return this.delegate.getPath(first, more);
        }

        @Override
        public PathMatcher getPathMatcher(String syntaxAndPattern) {
            return this.delegate.getPathMatcher(syntaxAndPattern);
        }

        @Override
        public UserPrincipalLookupService getUserPrincipalLookupService() {
            return this.delegate.getUserPrincipalLookupService();
        }

        @Override
        public WatchService newWatchService() throws IOException {
            return this.delegate.newWatchService();
        }
    }
}

