/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.action;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.action.Action;
import dev.aurelium.slate.action.parser.CommandActionParser;
import dev.aurelium.slate.action.parser.MenuActionParser;
import dev.aurelium.slate.util.MapParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.spongepowered.configurate.ConfigurationNode;

public class ActionManager
extends MapParser {
    private final Slate slate;

    public ActionManager(Slate slate) {
        this.slate = slate;
    }

    public List<Action> parseActions(ConfigurationNode config, String menuName, String itemName) {
        ArrayList<Action> actions = new ArrayList<Action>();
        int index = 0;
        for (ConfigurationNode configurationNode : config.childrenList()) {
            block5: {
                try {
                    String type = Objects.requireNonNull(configurationNode.node("type").getString()).toLowerCase(Locale.ROOT);
                    if (type.equals("command")) {
                        actions.add(new CommandActionParser(this.slate).parse(configurationNode));
                        break block5;
                    }
                    if (type.equals("menu")) {
                        actions.add(new MenuActionParser(this.slate).parse(configurationNode));
                        break block5;
                    }
                    throw new IllegalArgumentException("Action with type " + type + " not found");
                }
                catch (RuntimeException e) {
                    this.slate.getPlugin().getLogger().warning("Error parsing action in menu " + menuName + " at path " + itemName + ".[" + index + "], see below for error:");
                    e.printStackTrace();
                }
            }
            ++index;
        }
        return actions;
    }
}

