/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.action;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.action.Action;
import dev.aurelium.slate.builder.BuiltMenu;
import dev.aurelium.slate.info.MenuInfo;
import dev.aurelium.slate.inv.content.InventoryContents;
import dev.aurelium.slate.menu.MenuInventory;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public class MenuAction
extends Action {
    private final ActionType actionType;
    private final String menuName;
    private final Map<String, Object> properties;

    public MenuAction(Slate slate, ActionType actionType, String menuName, Map<String, Object> properties) {
        super(slate);
        this.actionType = actionType;
        this.menuName = menuName;
        this.properties = properties;
    }

    @Override
    public void execute(Player player, MenuInventory menuInventory, InventoryContents contents) {
        switch (this.actionType) {
            case OPEN: {
                this.slate.openMenu(player, this.menuName, this.getProperties(menuInventory));
                break;
            }
            case CLOSE: {
                player.closeInventory();
                break;
            }
            case NEXT_PAGE: {
                int nextPage = menuInventory.getCurrentPage() + 1;
                if (nextPage >= menuInventory.getTotalPages()) break;
                this.slate.openMenu(player, menuInventory.getMenu().name(), this.getProperties(menuInventory), nextPage);
                break;
            }
            case PREVIOUS_PAGE: {
                int previousPage = menuInventory.getCurrentPage() - 1;
                if (previousPage < 0) break;
                this.slate.openMenu(player, menuInventory.getMenu().name(), this.getProperties(menuInventory), previousPage);
            }
        }
    }

    private Map<String, Object> getProperties(MenuInventory inventory) {
        BuiltMenu builtMenu = this.slate.getBuiltMenu(this.menuName);
        MenuInfo info = new MenuInfo(this.slate, inventory.getPlayer(), inventory.getActiveMenu());
        HashMap<String, Object> base = new HashMap<String, Object>(builtMenu.propertyProvider().get(info));
        if (base.isEmpty()) {
            base.putAll(inventory.getProperties());
        }
        base.putAll(this.properties);
        return base;
    }

    public static enum ActionType {
        OPEN,
        CLOSE,
        NEXT_PAGE,
        PREVIOUS_PAGE;

    }
}

