/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.builder;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.builder.BuiltComponent;
import dev.aurelium.slate.builder.BuiltItem;
import dev.aurelium.slate.builder.BuiltTemplate;
import dev.aurelium.slate.function.ItemModifier;
import dev.aurelium.slate.function.ItemReplacer;
import dev.aurelium.slate.function.MenuListener;
import dev.aurelium.slate.function.PageProvider;
import dev.aurelium.slate.function.PropertyProvider;
import dev.aurelium.slate.info.PlaceholderInfo;
import dev.aurelium.slate.item.provider.PlaceholderData;
import dev.aurelium.slate.item.provider.PlaceholderType;
import dev.aurelium.slate.menu.ActiveMenu;
import dev.aurelium.slate.util.LoreUtil;
import dev.aurelium.slate.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public record BuiltMenu(Map<String, BuiltItem> items, Map<String, BuiltTemplate<?>> templates, Map<String, BuiltComponent<?>> components, Map<String, ItemReplacer> titleReplacers, ItemReplacer titleAnyReplacer, PageProvider pageProvider, PropertyProvider propertyProvider, ItemModifier fillItem, MenuListener openListener, MenuListener updateListener, Map<String, Object> defaultOptions) {
    public static BuiltMenu createEmpty() {
        return new BuiltMenu(new HashMap<String, BuiltItem>(), new HashMap(), new HashMap(), new HashMap<String, ItemReplacer>(), p -> null, m -> 1, m -> new HashMap(), i -> null, m -> {}, m -> {}, new HashMap<String, Object>());
    }

    public <T> BuiltTemplate<T> getTemplate(String name, Class<T> contextType) {
        BuiltTemplate<?> template = this.templates.get(name);
        if (template != null && template.contextType().equals(contextType)) {
            return template;
        }
        return BuiltTemplate.createEmpty(contextType);
    }

    public <T> BuiltComponent<T> getComponent(String name, Class<T> contextType) {
        BuiltComponent<?> component = this.components.get(name);
        if (component != null && component.contextType().equals(contextType)) {
            return component;
        }
        return BuiltComponent.createEmpty(contextType);
    }

    public String applyTitleReplacers(String input, Slate slate, Player player, ActiveMenu activeMenu) {
        PlaceholderType type = PlaceholderType.TITLE;
        input = slate.getGlobalOptions().applyGlobalReplacers(input, slate, player, activeMenu, type);
        for (Map.Entry<String, ItemReplacer> entry : this.titleReplacers.entrySet()) {
            String placeholder = entry.getKey();
            PlaceholderData data = new PlaceholderData(type, LoreUtil.getStyle(input), null);
            String replaced = entry.getValue().replace(new PlaceholderInfo(slate, player, placeholder, activeMenu, data));
            if (replaced == null) continue;
            input = TextUtil.replace(input, "{" + placeholder + "}", replaced);
        }
        String[] placeholders = TextUtil.substringsBetween(input, "{", "}");
        if (placeholders != null) {
            PlaceholderData data = new PlaceholderData(type, LoreUtil.getStyle(input), null);
            for (String placeholder : placeholders) {
                String replaced = this.titleAnyReplacer.replace(new PlaceholderInfo(slate, player, placeholder, activeMenu, data));
                if (replaced == null) continue;
                input = TextUtil.replace(input, "{" + placeholder + "}", replaced);
            }
        }
        return input;
    }
}

