/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.item.parser;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.item.MenuItem;
import dev.aurelium.slate.item.builder.SingleItemBuilder;
import dev.aurelium.slate.item.parser.MenuItemParser;
import dev.aurelium.slate.menu.MenuLoader;
import dev.aurelium.slate.util.Validate;
import java.util.Objects;
import org.spongepowered.configurate.ConfigurationNode;

public class SingleItemParser
extends MenuItemParser {
    public SingleItemParser(Slate slate) {
        super(slate);
    }

    @Override
    public MenuItem parse(ConfigurationNode section, String menuName) {
        SingleItemBuilder builder = new SingleItemBuilder(this.slate);
        String name = (String)Objects.requireNonNull(section.key());
        builder.name(name);
        builder.baseItem(this.itemParser.parseBaseItem(section));
        String positionString = section.node("pos").getString();
        Validate.notNull(positionString, "Item must specify pos");
        builder.position(this.parsePosition(positionString));
        builder.displayName(this.itemParser.parseDisplayName(section));
        builder.lore(this.itemParser.parseLore(section));
        this.parseActions(builder, section, menuName, name);
        builder.options(MenuLoader.loadOptions(section));
        return builder.build();
    }
}

