/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.lore;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.lore.LoreLine;
import dev.aurelium.slate.lore.LoreType;
import dev.aurelium.slate.lore.parser.LoreParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;

public class LoreFactory {
    private final Slate slate;

    public LoreFactory(Slate slate) {
        this.slate = slate;
    }

    public List<LoreLine> getLore(ConfigurationNode config) {
        ArrayList<LoreLine> lines = new ArrayList<LoreLine>();
        if (!config.isList()) {
            return lines;
        }
        for (ConfigurationNode configurationNode : config.childrenList()) {
            LoreLine loreLine = this.buildLoreLine(configurationNode);
            if (loreLine == null) continue;
            lines.add(loreLine);
        }
        return lines;
    }

    @Nullable
    private LoreLine buildLoreLine(ConfigurationNode config) {
        try {
            LoreType type = this.getType(config);
            Class<? extends LoreParser> parserClass = type.getParserClass();
            LoreParser parser = parserClass.newInstance();
            return parser.parse(config);
        }
        catch (Exception e) {
            this.slate.getPlugin().getLogger().warning("Error building lore line: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private LoreType getType(ConfigurationNode config) {
        LoreType type;
        if (!config.isMap()) {
            return LoreType.TEXT;
        }
        String typeExplicit = config.node("type").getString();
        if (typeExplicit != null) {
            type = LoreType.valueOf(typeExplicit.toUpperCase(Locale.ROOT));
        } else if (!config.node("text").virtual()) {
            type = LoreType.TEXT;
        } else if (!config.node("component").virtual()) {
            type = LoreType.COMPONENT;
        } else {
            throw new IllegalArgumentException("Line does not define an explicit type or contain auto-detectable keys");
        }
        return type;
    }
}

