/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.menu;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.action.Action;
import dev.aurelium.slate.action.click.ClickAction;
import dev.aurelium.slate.builder.BuiltItem;
import dev.aurelium.slate.builder.BuiltMenu;
import dev.aurelium.slate.builder.BuiltTemplate;
import dev.aurelium.slate.fill.FillData;
import dev.aurelium.slate.fill.FillItem;
import dev.aurelium.slate.info.ItemInfo;
import dev.aurelium.slate.info.MenuInfo;
import dev.aurelium.slate.info.TemplateInfo;
import dev.aurelium.slate.inv.ClickableItem;
import dev.aurelium.slate.inv.ItemClickData;
import dev.aurelium.slate.inv.content.InventoryContents;
import dev.aurelium.slate.inv.content.InventoryProvider;
import dev.aurelium.slate.inv.content.SlotPos;
import dev.aurelium.slate.item.ItemClick;
import dev.aurelium.slate.item.MenuItem;
import dev.aurelium.slate.item.SingleItem;
import dev.aurelium.slate.item.TemplateClick;
import dev.aurelium.slate.item.TemplateItem;
import dev.aurelium.slate.item.active.ActiveItem;
import dev.aurelium.slate.item.active.ActiveSingleItem;
import dev.aurelium.slate.item.active.ActiveTemplateItem;
import dev.aurelium.slate.item.provider.PlaceholderType;
import dev.aurelium.slate.lore.LoreInterpreter;
import dev.aurelium.slate.lore.LoreLine;
import dev.aurelium.slate.menu.ActiveMenu;
import dev.aurelium.slate.menu.LoadedMenu;
import dev.aurelium.slate.position.PositionProvider;
import dev.aurelium.slate.text.TextFormatter;
import dev.aurelium.slate.util.PaperUtil;
import dev.aurelium.slate.util.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class MenuInventory
implements InventoryProvider {
    private final Slate slate;
    private final LoreInterpreter loreInterpreter;
    private final LoadedMenu menu;
    private final ActiveMenu activeMenu;
    private final Map<String, ActiveItem> activeItems;
    private final Map<String, Object> properties;
    private final int totalPages;
    private final int currentPage;
    private final Player player;
    private InventoryContents contents;
    private final TextFormatter tf = new TextFormatter();
    private final BuiltMenu builtMenu;

    public MenuInventory(Slate slate, LoadedMenu menu, Player player, Map<String, Object> properties, int currentPage) {
        this.slate = slate;
        this.loreInterpreter = new LoreInterpreter(slate);
        this.menu = menu;
        this.activeItems = new LinkedHashMap<String, ActiveItem>();
        this.activeMenu = new ActiveMenu(this);
        this.properties = new HashMap<String, Object>(properties);
        this.player = player;
        this.builtMenu = slate.getBuiltMenu(menu.name());
        this.totalPages = this.builtMenu.pageProvider().getPages(new MenuInfo(slate, player, this.activeMenu));
        this.currentPage = currentPage;
    }

    public Slate getSlate() {
        return this.slate;
    }

    public LoadedMenu getMenu() {
        return this.menu;
    }

    public ActiveMenu getActiveMenu() {
        return this.activeMenu;
    }

    @Nullable
    public ActiveItem getActiveItem(String itemName) {
        return this.activeItems.get(itemName);
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(Player player, InventoryContents contents) {
        this.contents = contents;
        for (MenuItem menuItem : this.menu.items().values()) {
            void var5_9;
            ActiveItem activeItem = this.activeItems.get(menuItem.getName());
            if (activeItem != null && activeItem.isHidden()) continue;
            if (menuItem instanceof SingleItem) {
                ActiveSingleItem activeSingleItem = new ActiveSingleItem((SingleItem)menuItem);
            } else {
                if (!(menuItem instanceof TemplateItem)) continue;
                TemplateItem templateItem = (TemplateItem)menuItem;
                ActiveTemplateItem activeTemplateItem = new ActiveTemplateItem(templateItem);
            }
            this.activeItems.put(menuItem.getName(), (ActiveItem)var5_9);
        }
        this.builtMenu.openListener().handle(new MenuInfo(this.slate, player, this.activeMenu));
        FillData fillData = this.menu.fillData();
        if (fillData.enabled()) {
            ItemStack itemStack;
            ItemMeta meta;
            FillItem fillItem = fillData.item();
            ItemStack itemStack2 = this.builtMenu.fillItem().modify(new ItemInfo(this.slate, player, this.activeMenu, fillItem.getBaseItem()));
            if (itemStack2 != null) {
                fillItem = new FillItem(this.slate, itemStack2);
            }
            if ((meta = (itemStack = fillItem.getBaseItem()).getItemMeta()) != null) {
                List<LoreLine> loreLines;
                String displayName = fillItem.getDisplayName();
                if (displayName != null) {
                    this.setDisplayName(meta, this.tf.toComponent(displayName));
                }
                if ((loreLines = fillItem.getLore()) != null) {
                    this.setLore(meta, this.loreInterpreter.interpretLore(loreLines, player, this.activeMenu, BuiltItem.createEmpty()));
                }
                itemStack.setItemMeta(meta);
            }
            if (fillData.slots() == null) {
                contents.fill(ClickableItem.empty(itemStack));
            } else {
                for (SlotPos slot : fillData.slots()) {
                    contents.set(slot, ClickableItem.empty(itemStack));
                }
            }
        }
        for (ActiveItem activeItem : this.activeItems.values()) {
            if (activeItem instanceof ActiveSingleItem) {
                this.addSingleItem((ActiveSingleItem)activeItem, contents, player);
                continue;
            }
            if (!(activeItem instanceof ActiveTemplateItem)) continue;
            this.addTemplateItem((ActiveTemplateItem)activeItem, contents, player);
        }
    }

    @Override
    public void update(Player player, InventoryContents contents) {
        for (ActiveItem activeItem : this.activeItems.values()) {
            if (activeItem.getCooldown() <= 0) continue;
            activeItem.setCooldown(activeItem.getCooldown() - 1);
        }
        this.builtMenu.updateListener().handle(new MenuInfo(this.slate, player, this.activeMenu));
    }

    private void addSingleItem(ActiveSingleItem activeItem, InventoryContents contents, Player player) {
        SingleItem item = activeItem.getItem();
        BuiltItem builtItem = this.slate.getBuiltMenu(this.menu.name()).items().getOrDefault(item.getName(), BuiltItem.createEmpty());
        ItemStack itemStack = item.getBaseItem().clone();
        builtItem.initListener().handle(new MenuInfo(this.slate, player, this.activeMenu));
        this.replaceItemPlaceholders(itemStack);
        itemStack = builtItem.modifier().modify(new ItemInfo(this.slate, player, this.activeMenu, itemStack));
        if (itemStack == null) {
            return;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            List<LoreLine> loreLines;
            String displayName = item.getDisplayName();
            if (displayName != null) {
                displayName = builtItem.applyReplacers(displayName, this.slate, player, this.activeMenu, PlaceholderType.DISPLAY_NAME);
                if (this.slate.isPlaceholderAPIEnabled()) {
                    displayName = PlaceholderAPI.setPlaceholders((Player)player, (String)displayName);
                }
                this.setDisplayName(meta, this.tf.toComponent(displayName));
            }
            if ((loreLines = item.getLore()) != null) {
                this.setLore(meta, this.loreInterpreter.interpretLore(loreLines, player, this.activeMenu, builtItem));
            }
            itemStack.setItemMeta(meta);
        }
        SlotPos pos = item.getPosition();
        this.addSingleItemToInventory(item, itemStack, pos, contents, player, builtItem);
    }

    private <C> void addTemplateItem(ActiveTemplateItem<C> activeItem, InventoryContents contents, Player player) {
        TemplateItem<C> item = activeItem.getItem();
        BuiltTemplate<C> builtTemplate = this.slate.getBuiltMenu(this.menu.name()).getTemplate(item.getName(), item.getContextClass());
        builtTemplate.initListener().handle(new MenuInfo(this.slate, player, this.activeMenu));
        Set<C> builtDefined = builtTemplate.definedContexts().get(new MenuInfo(this.slate, player, this.activeMenu));
        Set<C> contexts = !builtDefined.isEmpty() ? builtDefined : item.getBaseItems().keySet();
        for (C context : contexts) {
            this.addContextItem(contents, player, context, item, builtTemplate, contexts);
        }
    }

    private <C> void addContextItem(InventoryContents contents, Player player, C context, TemplateItem<C> item, BuiltTemplate<C> builtTemplate, Set<C> contexts) {
        ItemStack itemStack = item.getBaseItems().get(context);
        if (itemStack == null) {
            itemStack = item.getDefaultBaseItem();
        }
        if (itemStack != null) {
            itemStack = itemStack.clone();
        }
        builtTemplate.contextListener().handle(new TemplateInfo<C>(this.slate, player, this.activeMenu, itemStack, context));
        this.replaceItemPlaceholders(itemStack);
        itemStack = builtTemplate.modifier().modify(new TemplateInfo<C>(this.slate, player, this.activeMenu, itemStack, context));
        if (itemStack == null) {
            return;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            this.setContextMeta(player, context, item, builtTemplate, meta, itemStack);
        }
        PositionProvider posProvider = item.getPosition(context);
        SlotPos pos = null;
        if (posProvider != null) {
            ArrayList<PositionProvider> providers = new ArrayList<PositionProvider>();
            for (C cont : contexts) {
                providers.add(item.getPosition(cont));
            }
            pos = posProvider.getPosition(providers);
        } else {
            @Nullable SlotPos builtSlot = builtTemplate.slotProvider().get(new TemplateInfo<C>(this.slate, player, this.activeMenu, itemStack, context));
            if (builtSlot != null) {
                pos = builtSlot;
            }
        }
        if (pos == null) {
            pos = item.getDefaultPosition();
        }
        if (pos != null) {
            this.addTemplateItemToInventory(item, itemStack, pos, contents, player, builtTemplate, context);
        }
    }

    private <C> void setContextMeta(Player player, C context, TemplateItem<C> item, BuiltTemplate<C> builtTemplate, ItemMeta meta, ItemStack itemStack) {
        List<LoreLine> loreLines;
        String displayName = item.getActiveDisplayName(context);
        if (displayName != null) {
            displayName = builtTemplate.applyReplacers(displayName, this.slate, player, this.activeMenu, PlaceholderType.DISPLAY_NAME, context);
            if (this.slate.isPlaceholderAPIEnabled()) {
                displayName = PlaceholderAPI.setPlaceholders((Player)player, (String)displayName);
            }
            this.setDisplayName(meta, this.tf.toComponent(displayName));
        }
        if ((loreLines = item.getActiveLore(context)) != null) {
            this.setLore(meta, this.loreInterpreter.interpretLore(loreLines, player, this.activeMenu, builtTemplate, context));
        }
        itemStack.setItemMeta(meta);
    }

    private void setDisplayName(ItemMeta meta, Component component) {
        String displayName = this.tf.toString(component);
        if (displayName.contains("!!REMOVE!!")) {
            return;
        }
        PaperUtil.setDisplayName(meta, component);
    }

    private void setLore(ItemMeta meta, List<Component> components) {
        if (components.isEmpty()) {
            return;
        }
        PaperUtil.setLore(meta, components);
    }

    private void addSingleItemToInventory(SingleItem singleItem, ItemStack itemStack, SlotPos pos, InventoryContents contents, Player player, BuiltItem builtItem) {
        contents.set(pos, ClickableItem.from(itemStack, c -> {
            Event patt12960$temp = c.getEvent();
            if (!(patt12960$temp instanceof InventoryClickEvent)) {
                return;
            }
            InventoryClickEvent event = (InventoryClickEvent)patt12960$temp;
            ActiveItem activeItem = this.activeItems.get(singleItem.getName());
            if (activeItem != null && activeItem.getCooldown() != 0) {
                return;
            }
            builtItem.handleClick(this.getClickActions(event.getClick()), new ItemClick(player, event, c.getItem(), pos, this.activeMenu));
            this.executeActions(singleItem, player, contents, (ItemClickData)c);
        }));
    }

    private <C> void addTemplateItemToInventory(TemplateItem<C> templateItem, ItemStack itemStack, SlotPos pos, InventoryContents contents, Player player, BuiltTemplate<C> builtTemplate, C context) {
        contents.set(pos, ClickableItem.from(itemStack, c -> {
            Event patt13772$temp = c.getEvent();
            if (!(patt13772$temp instanceof InventoryClickEvent)) {
                return;
            }
            InventoryClickEvent event = (InventoryClickEvent)patt13772$temp;
            ActiveItem activeItem = this.activeItems.get(templateItem.getName());
            if (activeItem != null && activeItem.getCooldown() != 0) {
                return;
            }
            builtTemplate.handleClick(this.getClickActions(event.getClick()), new TemplateClick<Object>(player, event, c.getItem(), pos, this.activeMenu, context));
            this.executeActions(templateItem, player, contents, (ItemClickData)c);
        }));
    }

    private void executeActions(MenuItem menuItem, Player player, InventoryContents contents, ItemClickData clickData) {
        Event event = clickData.getEvent();
        if (!(event instanceof InventoryClickEvent)) {
            return;
        }
        InventoryClickEvent event2 = (InventoryClickEvent)event;
        Set<ClickAction> clickActions = this.getClickActions(event2.getClick());
        Map<ClickAction, List<Action>> actions = menuItem.getActions();
        for (Map.Entry<ClickAction, List<Action>> entry : actions.entrySet()) {
            ClickAction clickAction = entry.getKey();
            if (!clickActions.contains((Object)clickAction)) continue;
            for (Action action : entry.getValue()) {
                action.execute(player, this, contents);
            }
        }
    }

    private Set<ClickAction> getClickActions(ClickType clickType) {
        HashSet<ClickAction> clickActions = new HashSet<ClickAction>();
        clickActions.add(ClickAction.ANY);
        switch (clickType) {
            case LEFT: 
            case SHIFT_LEFT: {
                clickActions.add(ClickAction.LEFT);
                break;
            }
            case RIGHT: 
            case SHIFT_RIGHT: {
                clickActions.add(ClickAction.RIGHT);
                break;
            }
            case MIDDLE: {
                clickActions.add(ClickAction.MIDDLE);
                break;
            }
            case DROP: 
            case CONTROL_DROP: {
                clickActions.add(ClickAction.DROP);
            }
        }
        return clickActions;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    private void replaceItemPlaceholders(ItemStack item) {
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof SkullMeta) {
            NamespacedKey key;
            SkullMeta skullMeta = (SkullMeta)meta;
            PersistentDataContainer container = skullMeta.getPersistentDataContainer();
            String placeholder = (String)container.get(key = new NamespacedKey((Plugin)this.slate.getPlugin(), "skull_placeholder_uuid"), PersistentDataType.STRING);
            if (placeholder != null) {
                placeholder = TextUtil.replace(placeholder, "{player}", this.player.getUniqueId().toString());
                if (this.slate.isPlaceholderAPIEnabled()) {
                    placeholder = PlaceholderAPI.setPlaceholders((Player)this.player, (String)placeholder);
                }
                try {
                    UUID uuid = UUID.fromString(placeholder);
                    skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)uuid));
                }
                catch (IllegalArgumentException e) {
                    this.slate.getPlugin().getLogger().warning("Error while opening menu: Unable to parse UUID for skull placeholder " + placeholder);
                }
            }
            item.setItemMeta((ItemMeta)skullMeta);
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public InventoryContents getContents() {
        return this.contents;
    }
}

