/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.menu;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.builder.BuiltTemplate;
import dev.aurelium.slate.component.ComponentParser;
import dev.aurelium.slate.component.MenuComponent;
import dev.aurelium.slate.fill.FillData;
import dev.aurelium.slate.fill.FillItem;
import dev.aurelium.slate.fill.FillItemParser;
import dev.aurelium.slate.fill.SlotParser;
import dev.aurelium.slate.item.MenuItem;
import dev.aurelium.slate.item.parser.SingleItemParser;
import dev.aurelium.slate.item.parser.TemplateItemParser;
import dev.aurelium.slate.menu.LoadedMenu;
import dev.aurelium.slate.util.YamlLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.plugin.Plugin;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class MenuLoader {
    private final Slate slate;
    private final File mainDir;
    private final List<File> mergeDirs;
    private final YamlLoader loader;

    public MenuLoader(Slate slate, File mainDir, List<File> mergeDirs) {
        this.slate = slate;
        this.mainDir = mainDir;
        this.mergeDirs = mergeDirs;
        this.loader = new YamlLoader((Plugin)slate.getPlugin());
    }

    public int loadMenus() {
        File[] files = this.mainDir.listFiles((d, name) -> name.endsWith(".yml"));
        if (files == null) {
            return 0;
        }
        int menusLoaded = 0;
        for (File menuFile : files) {
            try {
                this.loadAndAddMenu(menuFile);
                ++menusLoaded;
            }
            catch (RuntimeException | ConfigurateException e) {
                this.slate.getPlugin().getLogger().warning("Error loading menu file " + menuFile.getName());
                e.printStackTrace();
            }
        }
        return menusLoaded;
    }

    private void loadAndAddMenu(File file) throws ConfigurateException, RuntimeException {
        String menuName = file.getName();
        int pos = menuName.lastIndexOf(".");
        if (pos > 0) {
            menuName = menuName.substring(0, pos);
        }
        LoadedMenu menu = this.loadMenu(file, menuName);
        this.slate.addLoadedMenu(menu);
    }

    private ConfigurationNode mergeAndLoad(File mainFile) throws ConfigurateException {
        ConfigurationNode base = this.loader.loadUserFile(mainFile);
        ArrayList<ConfigurationNode> nodesToMerge = new ArrayList<ConfigurationNode>();
        nodesToMerge.add(base);
        for (File mergeDir : this.mergeDirs) {
            File[] files;
            if (!mergeDir.isDirectory() || (files = mergeDir.listFiles((d, name) -> name.equals(mainFile.getName()))) == null || files.length == 0) continue;
            File mergingFile = files[0];
            ConfigurationNode mergingNode = this.loader.loadUserFile(mergingFile);
            nodesToMerge.add(mergingNode);
        }
        return this.loader.mergeNodes(nodesToMerge.toArray(new ConfigurationNode[0]));
    }

    private LoadedMenu loadMenu(File file, String menuName) throws ConfigurateException, RuntimeException {
        FillData fillData;
        ConfigurationNode configurationNode;
        ConfigurationNode templatesSection;
        ConfigurationNode config = this.mergeAndLoad(file);
        String title = config.node("title").getString(menuName);
        int size = config.node("size").getInt(6);
        LinkedHashMap<String, MenuItem> items = new LinkedHashMap<String, MenuItem>();
        ConfigurationNode itemsSection = config.node("items");
        if (!itemsSection.virtual()) {
            for (Object object : itemsSection.childrenMap().keySet()) {
                String itemName = (String)Objects.requireNonNull(object);
                ConfigurationNode itemSection = itemsSection.node(object);
                if (itemSection.virtual()) continue;
                MenuItem item = new SingleItemParser(this.slate).parse(itemSection, menuName);
                items.put(itemName, item);
            }
        }
        if (!(templatesSection = config.node("templates")).virtual()) {
            for (Object keyObj : templatesSection.childrenMap().keySet()) {
                String templateName = (String)Objects.requireNonNull(keyObj);
                ConfigurationNode templateSection = templatesSection.node(keyObj);
                if (templateSection.virtual()) continue;
                Object contextProvider = null;
                BuiltTemplate<?> builtTemplate = this.slate.getBuiltMenu(menuName).templates().get(templateName);
                if (builtTemplate != null) {
                    contextProvider = this.slate.getContextManager().getContextProvider(builtTemplate.contextType());
                }
                if (contextProvider == null) continue;
                MenuItem item = new TemplateItemParser(this.slate, contextProvider).parse(templateSection, menuName);
                items.put(templateName, item);
            }
        }
        if (!(configurationNode = config.node("fill")).virtual()) {
            boolean fillEnabled = configurationNode.node("enabled").getBoolean(false);
            FillItem fillItem = new FillItemParser(this.slate).parse(configurationNode, menuName);
            fillData = new FillData(fillItem, new SlotParser().parse(configurationNode), fillEnabled);
        } else {
            fillData = new FillData(FillItem.getDefault(this.slate), null, false);
        }
        HashMap<String, MenuComponent> components = new HashMap<String, MenuComponent>();
        ConfigurationNode componentsSection = config.node("components");
        if (!componentsSection.virtual()) {
            for (Object object : componentsSection.childrenMap().keySet()) {
                String name = (String)Objects.requireNonNull(object);
                ConfigurationNode componentNode = componentsSection.node(object);
                if (componentNode.virtual()) continue;
                components.put(name, new ComponentParser(this.slate).parse(componentNode));
            }
        }
        HashMap<String, String> formats = new HashMap<String, String>();
        for (Object keyObj : config.node("formats").childrenMap().keySet()) {
            String key = (String)keyObj;
            String value = config.node("formats").node(keyObj).getString();
            if (value == null) continue;
            formats.put(key, value);
        }
        this.generateDefaultOptions(menuName, file, config);
        Map<String, Object> map = MenuLoader.loadOptions(config);
        return new LoadedMenu(menuName, title, size, items, components, formats, fillData, map);
    }

    private void generateDefaultOptions(String menuName, File file, ConfigurationNode mainConfig) throws SerializationException {
        Map<String, Object> defaultOptions = this.slate.getBuiltMenu(menuName).defaultOptions();
        if (defaultOptions == null) {
            return;
        }
        ConfigurationNode config = mainConfig.node("options");
        boolean changed = false;
        for (Map.Entry<String, Object> entry : defaultOptions.entrySet()) {
            if (!config.node(entry.getKey()).virtual()) continue;
            config.node(entry.getKey()).set(entry.getValue());
            if (changed) continue;
            changed = true;
        }
        if (changed) {
            try {
                this.loader.saveFile(file, mainConfig);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, Object> loadOptions(ConfigurationNode config) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        ConfigurationNode optionSection = config.node("options");
        for (Object keyObj : optionSection.childrenMap().keySet()) {
            String key = (String)keyObj;
            if (optionSection.node(keyObj).isMap()) continue;
            Object value = optionSection.node(key).raw();
            options.put(key, value);
        }
        return options;
    }
}

