/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.action.condition;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.action.condition.Condition;
import dev.aurelium.slate.action.condition.PermissionCondition;
import dev.aurelium.slate.action.condition.PlaceholderCondition;
import dev.aurelium.slate.util.YamlLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import org.spongepowered.configurate.ConfigurationNode;

public class ConditionParser {
    private final Slate slate;

    public ConditionParser(Slate slate) {
        this.slate = slate;
    }

    public List<Condition> parseConditions(ConfigurationNode config, String menuName) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        int index = 0;
        for (ConfigurationNode configurationNode : config.childrenList()) {
            try {
                String type = Objects.requireNonNull(this.detectType(configurationNode));
                if (type.equals("permission")) {
                    conditions.add(this.parsePermissionCondition(configurationNode));
                } else if (type.equals("placeholder")) {
                    conditions.add(this.parsePlaceholderCondition(configurationNode));
                }
            }
            catch (RuntimeException e) {
                this.slate.getPlugin().getLogger().warning("Error parsing condition in menu " + menuName + " at path " + YamlLoader.toDotString(config.path()) + ".[" + index + "], see below for error:");
                e.printStackTrace();
            }
            ++index;
        }
        return conditions;
    }

    private PermissionCondition parsePermissionCondition(ConfigurationNode config) {
        return new PermissionCondition(this.slate, Objects.requireNonNull(config.node("permission").getString()), config.node("value").getBoolean(true));
    }

    private PlaceholderCondition parsePlaceholderCondition(ConfigurationNode config) {
        return new PlaceholderCondition(this.slate, Objects.requireNonNull(config.node("placeholder").getString()), Objects.requireNonNull(config.node("value").getString()), PlaceholderCondition.Compare.valueOf(config.node("compare").getString("equals").toUpperCase(Locale.ROOT)));
    }

    @Nullable
    private String detectType(ConfigurationNode node) {
        String type = node.node("type").getString();
        if (type != null) {
            return type.toLowerCase(Locale.ROOT);
        }
        if (!node.node("permission").virtual()) {
            return "permission";
        }
        if (!node.node("placeholder").virtual()) {
            return "placeholder";
        }
        return null;
    }
}

