/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.action.parser;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.action.Action;
import dev.aurelium.slate.action.MenuAction;
import dev.aurelium.slate.action.parser.ActionParser;
import dev.aurelium.slate.context.ContextProvider;
import dev.aurelium.slate.util.TextUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.spongepowered.configurate.ConfigurationNode;

public class MenuActionParser
extends ActionParser {
    public MenuActionParser(Slate slate) {
        super(slate);
    }

    @Override
    public Action parse(ConfigurationNode config) {
        MenuAction.ActionType actionType = MenuAction.ActionType.valueOf(Objects.requireNonNull(config.node("action").getString()).toUpperCase(Locale.ROOT));
        String menuName = config.node("menu").getString();
        return new MenuAction(this.slate, actionType, menuName, this.getProperties(menuName, config));
    }

    private Map<String, Object> getProperties(String menuName, ConfigurationNode config) {
        ConfigurationNode propertiesConfig = config.node("properties");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (propertiesConfig != null) {
            for (Object keyObj : propertiesConfig.childrenMap().keySet()) {
                String key = String.valueOf(keyObj);
                Object valueObj = propertiesConfig.node(keyObj).raw();
                if (valueObj instanceof String) {
                    String value = (String)valueObj;
                    if (value.contains(":")) {
                        String type = TextUtil.substringBefore(value, ":");
                        value = TextUtil.substringAfter(value, ":");
                        ContextProvider<?> contextProvider = this.slate.getContextManager().getContextProvider(type);
                        if (contextProvider == null) continue;
                        properties.put(key, contextProvider.parse(menuName, value));
                        continue;
                    }
                    properties.put(key, value);
                    continue;
                }
                properties.put(key, valueObj);
            }
        }
        return properties;
    }
}

