/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.item;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.action.Action;
import dev.aurelium.slate.action.condition.ItemConditions;
import dev.aurelium.slate.action.trigger.ClickTrigger;
import dev.aurelium.slate.context.ContextGroup;
import dev.aurelium.slate.inv.content.SlotPos;
import dev.aurelium.slate.item.MenuItem;
import dev.aurelium.slate.item.TemplateData;
import dev.aurelium.slate.lore.LoreLine;
import dev.aurelium.slate.menu.MenuInventory;
import dev.aurelium.slate.position.PositionProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TemplateItem<C>
extends MenuItem {
    private final Class<C> contextClass;
    private final TemplateData<C> data;
    private final ItemStack defaultBaseItem;
    private final SlotPos defaultPosition;
    private final Map<String, ContextGroup> contextGroups;

    public TemplateItem(Slate slate, String name, Class<C> contextClass, TemplateData<C> data, ItemStack defaultBaseItem, String displayName, List<LoreLine> lore, Map<ClickTrigger, List<Action>> actions, ItemConditions conditions, SlotPos defaultPosition, Map<String, Object> options, Map<String, ContextGroup> contextGroups) {
        super(slate, name, displayName, lore, actions, conditions, options);
        this.contextClass = contextClass;
        this.data = data;
        this.defaultBaseItem = defaultBaseItem;
        this.defaultPosition = defaultPosition;
        this.contextGroups = contextGroups;
    }

    public Class<C> getContextClass() {
        return this.contextClass;
    }

    public PositionProvider getPosition(C context) {
        return this.data.positions().get(context);
    }

    public Map<C, PositionProvider> getPositionsMap() {
        return this.data.positions();
    }

    public Map<C, ItemStack> getBaseItems() {
        HashMap<C, ItemStack> clonedItems = new HashMap<C, ItemStack>();
        for (Map.Entry<C, ItemStack> entry : this.data.baseItems().entrySet()) {
            clonedItems.put(entry.getKey(), entry.getValue().clone());
        }
        return clonedItems;
    }

    @Nullable
    public ItemStack getDefaultBaseItem() {
        if (this.defaultBaseItem != null) {
            return this.defaultBaseItem.clone();
        }
        return null;
    }

    @Nullable
    public SlotPos getDefaultPosition() {
        return this.defaultPosition;
    }

    @Nullable
    public String getContextualDisplayName(C context) {
        return this.data.displayNames().get(context);
    }

    @Nullable
    public String getActiveDisplayName(C context) {
        String contextualDisplayName = this.getContextualDisplayName(context);
        if (contextualDisplayName != null) {
            return contextualDisplayName;
        }
        return this.getDisplayName();
    }

    @Nullable
    public List<LoreLine> getContextualLore(C context) {
        return this.data.lore().get(context);
    }

    @Nullable
    public List<LoreLine> getActiveLore(C context) {
        List<LoreLine> contextualLore = this.getContextualLore(context);
        if (contextualLore != null) {
            return contextualLore;
        }
        return this.getLore();
    }

    public Map<String, ContextGroup> getContextGroups() {
        return this.contextGroups;
    }

    public boolean failsContextViewConditions(C context, Player player, MenuInventory inventory) {
        return this.failsConditions(player, inventory, this.data.conditions().getOrDefault(context, ItemConditions.empty()).viewConditions());
    }

    public boolean failsContextClickConditions(C context, ClickTrigger trigger, Player player, MenuInventory inventory) {
        List conditions = this.data.conditions().getOrDefault(context, ItemConditions.empty()).clickConditions().getOrDefault((Object)trigger, new ArrayList());
        return this.failsConditions(player, inventory, conditions);
    }
}

