/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.item.parser;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.inv.content.SlotPos;
import dev.aurelium.slate.item.MenuItem;
import dev.aurelium.slate.item.builder.SingleItemBuilder;
import dev.aurelium.slate.item.parser.MenuItemParser;
import dev.aurelium.slate.util.Validate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.spongepowered.configurate.ConfigurationNode;

public class SingleItemParser
extends MenuItemParser {
    public SingleItemParser(Slate slate) {
        super(slate);
    }

    @Override
    public MenuItem parse(ConfigurationNode section, String menuName) {
        SingleItemBuilder builder = new SingleItemBuilder(this.slate);
        String name = (String)Objects.requireNonNull(section.key());
        builder.name(name);
        builder.baseItem(this.itemParser.parseBaseItem(section));
        ConfigurationNode posNode = section.node("pos");
        if (posNode.isList()) {
            ArrayList<SlotPos> positions = new ArrayList<SlotPos>();
            for (ConfigurationNode configurationNode : posNode.childrenList()) {
                String positionString = configurationNode.getString();
                if (positionString == null) continue;
                positions.add(this.parsePosition(positionString));
            }
            builder.positions(positions);
        } else {
            String positionString = posNode.getString();
            Validate.notNull(positionString, "Item must specify pos");
            builder.positions(List.of(this.parsePosition(positionString)));
        }
        this.parseCommonOptions(builder, section, menuName);
        return builder.build();
    }
}

