/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.lore.parser;

import dev.aurelium.slate.lore.LoreLine;
import dev.aurelium.slate.lore.LoreStyles;
import dev.aurelium.slate.lore.parser.LoreParser;
import dev.aurelium.slate.lore.type.TextLore;
import java.util.HashMap;
import org.spongepowered.configurate.ConfigurationNode;

public class TextLoreParser
implements LoreParser {
    @Override
    public LoreLine parse(ConfigurationNode config) {
        if (!config.isMap()) {
            String text = config.getString("");
            return new TextLore(text, new LoreStyles(new HashMap<Integer, String>()), false, 0, false, "");
        }
        String text = config.node("text").getString("");
        LoreStyles styles = this.parseStyles(config);
        boolean wrap = config.node("wrap").getBoolean(false);
        int wrapStyle = config.node("wrap_style").getInt(0);
        boolean smartWrap = config.node("smart_wrap").getBoolean(true);
        String wrapIndent = config.node("wrap_indent").getString("");
        return new TextLore(text, styles, wrap, wrapStyle, smartWrap, wrapIndent);
    }

    private LoreStyles parseStyles(ConfigurationNode config) {
        if (!config.node("style").virtual()) {
            String style = config.node("style").getString("");
            HashMap<Integer, String> styleMap = new HashMap<Integer, String>();
            styleMap.put(0, style);
            return new LoreStyles(styleMap);
        }
        if (config.node("styles").isMap()) {
            HashMap<Integer, String> styleMap = new HashMap<Integer, String>();
            for (ConfigurationNode configurationNode : config.node("styles").childrenMap().values()) {
                int index;
                Object key = configurationNode.key();
                if (key instanceof String) {
                    index = Integer.parseInt((String)key);
                } else {
                    if (!(key instanceof Integer)) continue;
                    index = (Integer)key;
                }
                String style = configurationNode.getString();
                if (style == null) continue;
                styleMap.put(index, style);
            }
            return new LoreStyles(styleMap);
        }
        return new LoreStyles(new HashMap<Integer, String>());
    }
}

